/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.html;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.html.CssBuilder;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class HTMLLayoutBase<E>
extends LayoutBase<E> {
    protected String pattern;
    protected Converter<E> head;
    protected String title = "Logback Log Messages";
    protected CssBuilder cssBuilder;
    protected long counter = 0L;

    /*
     * WARNING - void declaration
     */
    public void setPattern(String conversionPattern) {
        void var1_1;
        this.pattern = var1_1;
    }

    public String getPattern() {
        return this.pattern;
    }

    public CssBuilder getCssBuilder() {
        return this.cssBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public void setCssBuilder(CssBuilder cssBuilder) {
        void var1_1;
        this.cssBuilder = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        void var1_1;
        int errorCount = 0;
        try {
            void var3_4;
            Parser p = new Parser(this.pattern);
            p.setContext(((ContextAwareBase)this).getContext());
            Node t = p.parse();
            this.head = p.compile((Node)var3_4, this.getEffectiveConverterMap());
            ConverterUtil.startConverters(this.head);
        }
        catch (ScanException ex) {
            void var2_3;
            this.addError("Incorrect pattern found", (Throwable)var2_3);
            ++errorCount;
        }
        if (var1_1 == false) {
            this.started = true;
        }
    }

    protected abstract Map<String, String> getDefaultConverterMap();

    /*
     * WARNING - void declaration
     */
    public Map<String, String> getEffectiveConverterMap() {
        void var1_1;
        Map contextMap;
        Context context;
        HashMap<String, String> effectiveMap = new HashMap<String, String>();
        Map<String, String> defaultMap = this.getDefaultConverterMap();
        if (defaultMap != null) {
            effectiveMap.putAll(defaultMap);
        }
        if ((context = ((ContextAwareBase)this).getContext()) != null && (contextMap = (Map)context.getObject("PATTERN_RULE_REGISTRY")) != null) {
            void var2_2;
            effectiveMap.putAll((Map<String, String>)var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTitle(String title) {
        void var1_1;
        this.title = var1_1;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFileHeader() {
        void var1_1;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
        sbuf.append(" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        sbuf.append("<html>");
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        sbuf.append("  <head>");
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        sbuf.append("    <title>");
        sbuf.append(this.title);
        sbuf.append("</title>");
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        this.cssBuilder.addCss(sbuf);
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        sbuf.append("  </head>");
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        sbuf.append("<body>");
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getPresentationHeader() {
        void var1_1;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("<hr/>");
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        sbuf.append("<p>Log session start time ");
        sbuf.append(new Date());
        sbuf.append("</p><p></p>");
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        sbuf.append("<table cellspacing=\"0\">");
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        this.buildHeaderRowForTable(sbuf);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void buildHeaderRowForTable(StringBuilder sbuf) {
        void var1_1;
        Converter<E> c = this.head;
        sbuf.append("<tr class=\"header\">");
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        while (c != null) {
            String string = this.computeConverterName(c);
            if (string == null) {
                c = c.getNext();
                continue;
            }
            sbuf.append("<td class=\"");
            sbuf.append(this.computeConverterName(c));
            sbuf.append("\">");
            sbuf.append(this.computeConverterName(c));
            sbuf.append("</td>");
            sbuf.append(CoreConstants.LINE_SEPARATOR);
            c = c.getNext();
        }
        sbuf.append("</tr>");
        var1_1.append(CoreConstants.LINE_SEPARATOR);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getPresentationFooter() {
        void var1_1;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("</table>");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFileFooter() {
        void var1_1;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(CoreConstants.LINE_SEPARATOR);
        sbuf.append("</body></html>");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected void startNewTableIfLimitReached(StringBuilder sbuf) {
        if (this.counter >= 10000L) {
            void var1_1;
            this.counter = 0L;
            sbuf.append("</table>");
            sbuf.append(CoreConstants.LINE_SEPARATOR);
            sbuf.append("<p></p>");
            sbuf.append("<table cellspacing=\"0\">");
            sbuf.append(CoreConstants.LINE_SEPARATOR);
            this.buildHeaderRowForTable((StringBuilder)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String computeConverterName(Converter<E> c) {
        void var2_2;
        void var1_1;
        String className = c.getClass().getSimpleName();
        int index = className.indexOf("Converter");
        if (index == -1) {
            return className;
        }
        return var1_1.substring(0, (int)var2_2);
    }
}

