/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.spi.ContextAware;
import java.nio.charset.Charset;

public class LayoutWrappingEncoder<E>
extends EncoderBase<E> {
    protected Layout<E> layout;
    private Charset charset;
    ContextAware parent;
    Boolean immediateFlush = null;

    public Layout<E> getLayout() {
        return this.layout;
    }

    /*
     * WARNING - void declaration
     */
    public void setLayout(Layout<E> layout) {
        void var1_1;
        this.layout = var1_1;
    }

    public Charset getCharset() {
        return this.charset;
    }

    /*
     * WARNING - void declaration
     */
    public void setCharset(Charset charset) {
        void var1_1;
        this.charset = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setImmediateFlush(boolean immediateFlush) {
        void var1_1;
        this.addWarn("As of version 1.2.0 \"immediateFlush\" property should be set within the enclosing Appender.");
        this.addWarn("Please move \"immediateFlush\" property into the enclosing appender.");
        this.immediateFlush = (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] headerBytes() {
        void var1_1;
        if (this.layout == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        this.appendIfNotNull(sb, this.layout.getFileHeader());
        this.appendIfNotNull(sb, this.layout.getPresentationHeader());
        if (sb.length() > 0) {
            sb.append(CoreConstants.LINE_SEPARATOR);
        }
        return this.convertToBytes(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] footerBytes() {
        void var1_1;
        if (this.layout == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        this.appendIfNotNull(sb, this.layout.getPresentationFooter());
        this.appendIfNotNull(sb, this.layout.getFileFooter());
        return this.convertToBytes(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    private byte[] convertToBytes(String s) {
        void var1_1;
        if (this.charset == null) {
            return s.getBytes();
        }
        return var1_1.getBytes(this.charset);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] encode(E event) {
        void var1_1;
        String txt = this.layout.doLayout(event);
        return this.convertToBytes((String)var1_1);
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start() {
        if (this.immediateFlush != null) {
            if (this.parent instanceof OutputStreamAppender) {
                LayoutWrappingEncoder layoutWrappingEncoder = this;
                layoutWrappingEncoder.addWarn("Setting the \"immediateFlush\" property of the enclosing appender to " + layoutWrappingEncoder.immediateFlush);
                OutputStreamAppender outputStreamAppender = (OutputStreamAppender)this.parent;
                outputStreamAppender.setImmediateFlush(this.immediateFlush);
            } else {
                this.addError("Could not set the \"immediateFlush\" property of the enclosing appender.");
            }
        }
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
    }

    /*
     * WARNING - void declaration
     */
    private void appendIfNotNull(StringBuilder sb, String s) {
        if (s != null) {
            void var2_2;
            void var1_1;
            var1_1.append((String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setParent(ContextAware parent) {
        void var1_1;
        this.parent = var1_1;
    }
}

