/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.boolex;

import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Matcher
extends ContextAwareBase
implements LifeCycle {
    private String regex;
    private String name;
    private boolean caseSensitive = true;
    private boolean canonEq = false;
    private boolean unicodeCase = false;
    private boolean start = false;
    private Pattern pattern;

    public String getRegex() {
        return this.regex;
    }

    /*
     * WARNING - void declaration
     */
    public void setRegex(String regex) {
        void var1_1;
        this.regex = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        if (this.name == null) {
            this.addError("All Matcher objects must be named");
            return;
        }
        try {
            int code = 0;
            if (!this.caseSensitive) {
                code = 2;
            }
            if (this.canonEq) {
                code |= 0x80;
            }
            if (this.unicodeCase) {
                code |= 0x40;
            }
            this.pattern = Pattern.compile(this.regex, code);
            this.start = true;
            return;
        }
        catch (PatternSyntaxException pse) {
            void var1_2;
            Matcher matcher = this;
            matcher.addError("Failed to compile regex [" + matcher.regex + "]", (Throwable)var1_2);
            return;
        }
    }

    @Override
    public void stop() {
        this.start = false;
    }

    @Override
    public boolean isStarted() {
        return this.start;
    }

    public boolean matches(String input) throws EvaluationException {
        if (this.start) {
            java.util.regex.Matcher matcher;
            matcher = this.pattern.matcher((CharSequence)((Object)matcher));
            return matcher.find();
        }
        throw new EvaluationException("Matcher [" + this.regex + "] not started");
    }

    public boolean isCanonEq() {
        return this.canonEq;
    }

    /*
     * WARNING - void declaration
     */
    public void setCanonEq(boolean canonEq) {
        void var1_1;
        this.canonEq = var1_1;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    /*
     * WARNING - void declaration
     */
    public void setCaseSensitive(boolean caseSensitive) {
        void var1_1;
        this.caseSensitive = var1_1;
    }

    public boolean isUnicodeCase() {
        return this.unicodeCase;
    }

    /*
     * WARNING - void declaration
     */
    public void setUnicodeCase(boolean unicodeCase) {
        void var1_1;
        this.unicodeCase = var1_1;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        this.name = var1_1;
    }
}

