/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.status.ErrorStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantLock;

public class OutputStreamAppender<E>
extends UnsynchronizedAppenderBase<E> {
    protected Encoder<E> encoder;
    protected final ReentrantLock streamWriteLock = new ReentrantLock(false);
    private OutputStream outputStream;
    boolean immediateFlush = true;

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        void var1_1;
        int errors = 0;
        if (this.encoder == null) {
            this.addStatus(new ErrorStatus("No encoder set for the appender named \"" + this.name + "\".", this));
            ++errors;
        }
        if (this.outputStream == null) {
            this.addStatus(new ErrorStatus("No output stream set for the appender named \"" + this.name + "\".", this));
            ++errors;
        }
        if (this.encoder == null) {
            this.addWarn("Encoder has not been set. Cannot invoke its init method.");
            ++errors;
        }
        if (var1_1 == false) {
            super.start();
            this.encoderInit();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setLayout(Layout<E> layout) {
        void var2_2;
        void var1_1;
        this.addWarn("This appender no longer admits a layout as a sub-component, set an encoder instead.");
        this.addWarn("To ensure compatibility, wrapping your layout in LayoutWrappingEncoder.");
        this.addWarn("See also http://logback.qos.ch/codes.html#layoutInsteadOfEncoder for details");
        LayoutWrappingEncoder lwe = new LayoutWrappingEncoder();
        lwe.setLayout(var1_1);
        lwe.setContext(this.context);
        this.encoder = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void append(E eventObject) {
        void var1_1;
        if (!this.isStarted()) {
            return;
        }
        this.subAppend(var1_1);
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.streamWriteLock.lock();
        try {
            this.closeOutputStream();
            super.stop();
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void closeOutputStream() {
        if (this.outputStream != null) {
            try {
                this.encoderClose();
                this.outputStream.close();
                this.outputStream = null;
                return;
            }
            catch (IOException e) {
                void var1_1;
                this.addStatus(new ErrorStatus("Could not close output stream for OutputStreamAppender.", this, (Throwable)var1_1));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void encoderClose() {
        if (this.encoder != null && this.outputStream != null) {
            try {
                byte[] footer = this.encoder.footerBytes();
                this.writeBytes(footer);
                return;
            }
            catch (IOException ioe) {
                void var1_2;
                this.started = false;
                this.addStatus(new ErrorStatus("Failed to write footer for appender named [" + this.name + "].", this, (Throwable)var1_2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setOutputStream(OutputStream outputStream) {
        this.streamWriteLock.lock();
        try {
            void var1_1;
            this.closeOutputStream();
            this.outputStream = var1_1;
            if (this.isStarted()) {
                this.encoderInit();
            }
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    void encoderInit() {
        if (this.encoder != null && this.outputStream != null) {
            try {
                byte[] header = this.encoder.headerBytes();
                this.writeBytes(header);
                return;
            }
            catch (IOException ioe) {
                void var1_2;
                this.started = false;
                this.addStatus(new ErrorStatus("Failed to initialize encoder for appender named [" + this.name + "].", this, (Throwable)var1_2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void writeOut(E event) throws IOException {
        void var1_1;
        byte[] byteArray = this.encoder.encode(event);
        this.writeBytes((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void writeBytes(byte[] byteArray) throws IOException {
        if (byteArray == null || byteArray.length == 0) {
            return;
        }
        this.streamWriteLock.lock();
        try {
            if (this.isStarted()) {
                void var1_1;
                this.writeByteArrayToOutputStreamWithPossibleFlush(byteArray);
                this.updateByteCount((byte[])var1_1);
            }
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    protected void updateByteCount(byte[] byteArray) {
    }

    /*
     * WARNING - void declaration
     */
    protected final void writeByteArrayToOutputStreamWithPossibleFlush(byte[] byteArray) throws IOException {
        void var1_1;
        this.outputStream.write((byte[])var1_1);
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void subAppend(E event) {
        if (!this.isStarted()) {
            return;
        }
        try {
            if (event instanceof DeferredProcessingAware) {
                ((DeferredProcessingAware)event).prepareForDeferredProcessing();
            }
            this.writeOut(event);
            return;
        }
        catch (IOException ioe) {
            void var1_2;
            this.started = false;
            this.addStatus(new ErrorStatus("IO failure in appender", this, (Throwable)var1_2));
            return;
        }
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    /*
     * WARNING - void declaration
     */
    public void setEncoder(Encoder<E> encoder) {
        void var1_1;
        this.encoder = var1_1;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    /*
     * WARNING - void declaration
     */
    public void setImmediateFlush(boolean immediateFlush) {
        void var1_1;
        this.immediateFlush = var1_1;
    }
}

