/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LifeCycleManager;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.spi.ConfigurationEventListener;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.SequenceNumberGenerator;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.ExecutorServiceUtil;
import ch.qos.logback.core.util.NetworkAddressUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantLock;

public class ContextBase
implements Context,
LifeCycle {
    private long birthTime = System.currentTimeMillis();
    private String name;
    private StatusManager sm = new BasicStatusManager();
    Map<String, String> propertyMap = new HashMap<String, String>();
    Map<String, Object> objectMap = new ConcurrentHashMap<String, Object>();
    protected ReentrantLock configurationLock = new ReentrantLock();
    private final List<ConfigurationEventListener> configurationEventListenerList = new CopyOnWriteArrayList<ConfigurationEventListener>();
    private ScheduledExecutorService scheduledExecutorService;
    private ThreadPoolExecutor threadPoolExecutor;
    private ExecutorService alternateExecutorService;
    protected List<ScheduledFuture<?>> scheduledFutures = new ArrayList(1);
    private LifeCycleManager lifeCycleManager;
    private SequenceNumberGenerator sequenceNumberGenerator;
    private volatile boolean started;

    public ContextBase() {
        this.initCollisionMaps();
    }

    @Override
    public StatusManager getStatusManager() {
        return this.sm;
    }

    /*
     * WARNING - void declaration
     */
    public void setStatusManager(StatusManager statusManager) {
        void var1_1;
        if (statusManager == null) {
            throw new IllegalArgumentException("null StatusManager not allowed");
        }
        this.sm = var1_1;
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return new HashMap<String, String>(this.propertyMap);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putProperty(String key, String val) {
        void var2_2;
        void var1_1;
        if ("HOSTNAME".equalsIgnoreCase(key)) {
            this.putHostnameProperty(val);
            return;
        }
        this.propertyMap.put((String)var1_1, (String)var2_2);
    }

    protected void initCollisionMaps() {
        this.putObject("FA_FILENAMES_MAP", new HashMap());
        this.putObject("RFA_FILENAME_PATTERN_COLLISION_MAP", new HashMap());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addSubstitutionProperty(String key, String value) {
        void var2_2;
        void var1_1;
        if (key == null || value == null) {
            return;
        }
        value = value.trim();
        this.propertyMap.put((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getProperty(String key) {
        void var1_1;
        if ("CONTEXT_NAME".equals(key)) {
            return this.getName();
        }
        if ("HOSTNAME".equalsIgnoreCase(key)) {
            return this.lazyGetHostname();
        }
        return this.propertyMap.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private String lazyGetHostname() {
        void var1_1;
        String hostname = this.propertyMap.get("HOSTNAME");
        if (hostname == null) {
            hostname = new NetworkAddressUtil(this).safelyGetLocalHostName();
            this.putHostnameProperty(hostname);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void putHostnameProperty(String hostname) {
        String string = this.propertyMap.get("HOSTNAME");
        if (string == null) {
            void var1_1;
            this.propertyMap.put("HOSTNAME", (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getObject(String key) {
        void var1_1;
        return this.objectMap.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putObject(String key, Object value) {
        void var2_2;
        void var1_1;
        this.objectMap.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void removeObject(String key) {
        void var1_1;
        this.objectMap.remove(var1_1);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.stopExecutorServices();
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public void reset() {
        this.removeShutdownHook();
        this.getLifeCycleManager().reset();
        this.propertyMap.clear();
        this.objectMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setName(String name) throws IllegalStateException {
        if (name != null && name.equals(this.name)) {
            return;
        }
        if (this.name == null || "default".equals(this.name)) {
            void var1_1;
            this.name = var1_1;
            return;
        }
        throw new IllegalStateException("Context has been already given a name");
    }

    @Override
    public long getBirthTime() {
        return this.birthTime;
    }

    @Override
    public ReentrantLock getConfigurationLock() {
        return this.configurationLock;
    }

    @Override
    public synchronized ExecutorService getExecutorService() {
        if (this.threadPoolExecutor == null) {
            this.threadPoolExecutor = ExecutorServiceUtil.newThreadPoolExecutor();
        }
        return this.threadPoolExecutor;
    }

    @Override
    public synchronized ExecutorService getAlternateExecutorService() {
        if (this.alternateExecutorService == null) {
            this.alternateExecutorService = ExecutorServiceUtil.newAlternateThreadPoolExecutor();
        }
        return this.alternateExecutorService;
    }

    @Override
    public synchronized ScheduledExecutorService getScheduledExecutorService() {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = ExecutorServiceUtil.newScheduledExecutorService();
        }
        return this.scheduledExecutorService;
    }

    private synchronized void stopExecutorServices() {
        ExecutorServiceUtil.shutdown(this.scheduledExecutorService);
        this.scheduledExecutorService = null;
        ExecutorServiceUtil.shutdown(this.threadPoolExecutor);
        this.threadPoolExecutor = null;
    }

    /*
     * WARNING - void declaration
     */
    private void removeShutdownHook() {
        Thread hook = (Thread)this.getObject("SHUTDOWN_HOOK");
        if (hook != null) {
            this.removeObject("SHUTDOWN_HOOK");
            try {
                void var1_2;
                this.sm.add(new InfoStatus("Removing shutdownHook " + String.valueOf(hook), this));
                Runtime runtime = Runtime.getRuntime();
                boolean result = runtime.removeShutdownHook(hook);
                this.sm.add(new InfoStatus("ShutdownHook removal result: " + (boolean)var1_2, this));
                return;
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void register(LifeCycle component) {
        void var1_1;
        this.getLifeCycleManager().register((LifeCycle)var1_1);
    }

    synchronized LifeCycleManager getLifeCycleManager() {
        if (this.lifeCycleManager == null) {
            this.lifeCycleManager = new LifeCycleManager();
        }
        return this.lifeCycleManager;
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        void var1_1;
        this.scheduledFutures.add((ScheduledFuture<?>)var1_1);
    }

    @Deprecated
    public List<ScheduledFuture<?>> getScheduledFutures() {
        return this.getCopyOfScheduledFutures();
    }

    public List<ScheduledFuture<?>> getCopyOfScheduledFutures() {
        return new ArrayList(this.scheduledFutures);
    }

    @Override
    public SequenceNumberGenerator getSequenceNumberGenerator() {
        return this.sequenceNumberGenerator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSequenceNumberGenerator(SequenceNumberGenerator sequenceNumberGenerator) {
        void var1_1;
        this.sequenceNumberGenerator = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addConfigurationEventListener(ConfigurationEventListener listener) {
        void var1_1;
        this.configurationEventListenerList.add((ConfigurationEventListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeConfigurationEventListener(ConfigurationEventListener listener) {
        void var1_1;
        this.configurationEventListenerList.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fireConfigurationEvent(ConfigurationEvent configurationEvent) {
        void var1_1;
        this.configurationEventListenerList.forEach(arg_0 -> ContextBase.lambda$fireConfigurationEvent$0((ConfigurationEvent)var1_1, arg_0));
    }

    private static /* synthetic */ void lambda$fireConfigurationEvent$0(ConfigurationEvent configurationEvent, ConfigurationEventListener l) {
        ConfigurationEvent configurationEvent2;
        l.listen(configurationEvent2);
    }
}

