/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

public final class Util {
    private static ClassContextSecurityManager SECURITY_MANAGER;
    private static boolean SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED;

    private Util() {
    }

    /*
     * WARNING - void declaration
     */
    public static String safeGetSystemProperty(String key) {
        void var1_1;
        if (key == null) {
            throw new IllegalArgumentException("null input");
        }
        String result = null;
        try {
            String string;
            result = System.getProperty(string);
        }
        catch (SecurityException securityException) {}
        return var1_1;
    }

    public static boolean safeGetBooleanSystemProperty(String key) {
        String string;
        String value = Util.safeGetSystemProperty(key);
        if (value == null) {
            return false;
        }
        return string.equalsIgnoreCase("true");
    }

    private static ClassContextSecurityManager getSecurityManager() {
        if (SECURITY_MANAGER != null) {
            return SECURITY_MANAGER;
        }
        if (SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED) {
            return null;
        }
        SECURITY_MANAGER = Util.safeCreateSecurityManager();
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = true;
        return SECURITY_MANAGER;
    }

    private static ClassContextSecurityManager safeCreateSecurityManager() {
        try {
            return new ClassContextSecurityManager();
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> getCallingClass() {
        void var2_2;
        void var0;
        int i;
        ClassContextSecurityManager securityManager = Util.getSecurityManager();
        if (securityManager == null) {
            return null;
        }
        Class<?>[] trace = securityManager.getClassContext();
        String thisClassName = Util.class.getName();
        for (i = 0; i < trace.length && !thisClassName.equals(trace[i].getName()); ++i) {
        }
        if (i >= trace.length || i + 2 >= trace.length) {
            throw new IllegalStateException("Failed to find org.slf4j.helpers.Util or its caller in the stack; this should not happen");
        }
        return var0[var2_2 + 2];
    }

    /*
     * WARNING - void declaration
     */
    public static final void report(String msg, Throwable t) {
        void var1_1;
        String string;
        System.err.println(string);
        System.err.println("Reported exception:");
        var1_1.printStackTrace();
    }

    public static final void report(String msg) {
        String string;
        System.err.println("SLF4J: " + string);
    }

    static {
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = false;
    }

    private static final class ClassContextSecurityManager
    extends SecurityManager {
        private ClassContextSecurityManager() {
        }

        @Override
        protected final Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

