/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.StatusUtil;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.slf4j.Marker;

@Deprecated
public class ReconfigureOnChangeFilter
extends TurboFilter {
    public static final long DEFAULT_REFRESH_PERIOD = 60000L;
    long refreshPeriod = 60000L;
    URL mainConfigurationURL;
    protected volatile long nextCheck;
    ConfigurationWatchList configurationWatchList;
    private long invocationCounter = 0L;
    private volatile long mask = 15L;
    private volatile long lastMaskCheck = System.currentTimeMillis();
    private static final int MAX_MASK = 65535;
    private static final long MASK_INCREASE_THRESHOLD = 100L;
    private static final long MASK_DECREASE_THRESHOLD = 800L;

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        this.configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)this.context);
        if (this.configurationWatchList != null) {
            void var2_2;
            ConfigurationWatchList configurationWatchList;
            this.mainConfigurationURL = this.configurationWatchList.getMainURL();
            if (this.mainConfigurationURL == null) {
                this.addWarn("Due to missing top level configuration file, automatic reconfiguration is impossible.");
                return;
            }
            List watchList = this.configurationWatchList.getCopyOfFileWatchList();
            long inSeconds = this.refreshPeriod / 1000L;
            this.addInfo("Will scan for changes in [" + String.valueOf(configurationWatchList) + "] every " + (long)var2_2 + " seconds. ");
            configurationWatchList = this.configurationWatchList;
            synchronized (configurationWatchList) {
                this.updateNextCheck(System.currentTimeMillis());
            }
            super.start();
            return;
        }
        this.addWarn("Empty ConfigurationWatchList in context");
    }

    public String toString() {
        return "ReconfigureOnChangeFilter{invocationCounter=" + this.invocationCounter + "}";
    }

    @Override
    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if ((this.invocationCounter++ & this.mask) != this.mask) {
            return FilterReply.NEUTRAL;
        }
        long now = System.currentTimeMillis();
        ConfigurationWatchList configurationWatchList = this.configurationWatchList;
        synchronized (configurationWatchList) {
            this.updateMaskIfNecessary(now);
            if (this.changeDetected(now)) {
                this.disableSubsequentReconfiguration();
                this.detachReconfigurationToNewThread();
            }
        }
        return FilterReply.NEUTRAL;
    }

    /*
     * WARNING - void declaration
     */
    private void updateMaskIfNecessary(long now) {
        void var3_2;
        void var1_1;
        long timeElapsedSinceLastMaskUpdateCheck = now - this.lastMaskCheck;
        this.lastMaskCheck = var1_1;
        if (timeElapsedSinceLastMaskUpdateCheck < 100L && this.mask < 65535L) {
            this.mask = this.mask << 1 | 1L;
            return;
        }
        if (var3_2 > 800L) {
            this.mask >>>= 2;
        }
    }

    void detachReconfigurationToNewThread() {
        ReconfigureOnChangeFilter reconfigureOnChangeFilter = this;
        reconfigureOnChangeFilter.addInfo("Detected change in [" + String.valueOf(reconfigureOnChangeFilter.configurationWatchList.getCopyOfFileWatchList()) + "]");
        this.context.getExecutorService().submit(new ReconfiguringThread(this));
    }

    /*
     * WARNING - void declaration
     */
    void updateNextCheck(long now) {
        void var1_1;
        this.nextCheck = var1_1 + this.refreshPeriod;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean changeDetected(long now) {
        if (now >= this.nextCheck) {
            void var1_1;
            this.updateNextCheck((long)var1_1);
            File file = this.configurationWatchList.changeDetected();
            return file != null;
        }
        return false;
    }

    void disableSubsequentReconfiguration() {
        this.nextCheck = Long.MAX_VALUE;
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    /*
     * WARNING - void declaration
     */
    public void setRefreshPeriod(long refreshPeriod) {
        void var1_1;
        this.refreshPeriod = var1_1;
    }

    class ReconfiguringThread
    implements Runnable {
        final /* synthetic */ ReconfigureOnChangeFilter this$0;

        /*
         * WARNING - void declaration
         */
        ReconfiguringThread(ReconfigureOnChangeFilter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            if (this.this$0.mainConfigurationURL == null) {
                this.this$0.addInfo("Due to missing top level configuration file, skipping reconfiguration");
                return;
            }
            LoggerContext lc = (LoggerContext)this.this$0.context;
            this.this$0.addInfo("Will reset and reconfigure context named [" + this.this$0.context.getName() + "]");
            if (this.this$0.mainConfigurationURL.toString().endsWith("xml")) {
                void var1_1;
                this.performXMLConfiguration((LoggerContext)var1_1);
                return;
            }
            if (this.this$0.mainConfigurationURL.toString().endsWith("groovy")) {
                this.this$0.addError("Groovy configuration disabled due to Java 9 compilation issues.");
            }
        }

        /*
         * WARNING - void declaration
         */
        private void performXMLConfiguration(LoggerContext lc) {
            JoranConfigurator jc = new JoranConfigurator();
            jc.setContext(this.this$0.context);
            StatusUtil statusUtil = new StatusUtil(this.this$0.context);
            Model failSafeTop = jc.recallSafeConfiguration();
            URL mainURL = ConfigurationWatchListUtil.getMainWatchURL((Context)this.this$0.context);
            lc.reset();
            long threshold = System.currentTimeMillis();
            try {
                void var3_3;
                void var2_2;
                var2_2.doConfigure(this.this$0.mainConfigurationURL);
                if (var3_3.hasXMLParsingErrors(threshold)) {
                    this.fallbackConfiguration(lc, failSafeTop, mainURL);
                }
                return;
            }
            catch (JoranException joranException) {
                void var1_1;
                this.fallbackConfiguration((LoggerContext)var1_1, failSafeTop, mainURL);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fallbackConfiguration(LoggerContext lc, Model failSafeTop, URL mainURL) {
            JoranConfigurator joranConfigurator = new JoranConfigurator();
            joranConfigurator.setContext(this.this$0.context);
            if (failSafeTop != null) {
                this.this$0.addWarn("Falling back to previously registered safe configuration.");
                try {
                    void var2_3;
                    void var3_4;
                    lc.reset();
                    JoranConfigurator.informContextOfURLUsedForConfiguration((Context)this.this$0.context, (URL)var3_4);
                    ModelUtil.resetForReuse((Model)failSafeTop);
                    joranConfigurator.processModel(failSafeTop);
                    this.this$0.addInfo("Re-registering previous fallback configuration once more as a fallback configuration point");
                    joranConfigurator.registerSafeConfiguration((Model)var2_3);
                    return;
                }
                catch (Exception e) {
                    void var1_2;
                    this.this$0.addError("Unexpected exception thrown by a configuration considered safe.", (Throwable)var1_2);
                    return;
                }
            }
            this.this$0.addWarn("No previous configuration to fall back on.");
        }
    }
}

