/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.ModelClassToModelHandlerLinker;
import ch.qos.logback.classic.joran.serializedModel.HardenedModelInputStream;
import ch.qos.logback.classic.model.processor.LogbackClassicDefaultNestedComponentRules;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ConfiguratorRank;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.locks.ReentrantLock;

@ConfiguratorRank(value=10)
public class SerializedModelConfigurator
extends ContextAwareBase
implements Configurator {
    public static final String AUTOCONFIG_MODEL_FILE = "logback.scmo";
    public static final String TEST_AUTOCONFIG_MODEL_FILE = "logback-test.scmo";
    protected ModelInterpretationContext modelInterpretationContext;

    /*
     * WARNING - void declaration
     */
    @Override
    public Configurator.ExecutionStatus configure(LoggerContext loggerContext) {
        URL url = this.performMultiStepModelFileSearch(true);
        if (url != null) {
            void var1_1;
            this.configureByResource((URL)var1_1);
            return Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY;
        }
        return Configurator.ExecutionStatus.INVOKE_NEXT_IF_ANY;
    }

    /*
     * WARNING - void declaration
     */
    private void configureByResource(URL url) {
        void var1_1;
        String string = url.toString();
        if (string.endsWith(".scmo")) {
            Model model = this.retrieveModel(url);
            if (model == null) {
                this.addWarn("Empty model. Abandoning.");
                return;
            }
            ModelUtil.resetForReuse((Model)model);
            this.buildModelInterpretationContext(model);
            DefaultProcessor defaultProcessor = new DefaultProcessor(this.context, this.modelInterpretationContext);
            ModelClassToModelHandlerLinker modelClassToModelHandlerLinker = new ModelClassToModelHandlerLinker(this.context);
            modelClassToModelHandlerLinker.link(defaultProcessor);
            ReentrantLock configurationLock = this.context.getConfigurationLock();
            try {
                configurationLock.lock();
                string.process((Model)var1_1);
                configurationLock.unlock();
            }
            catch (Throwable throwable) {
                ((ReentrantLock)((Object)modelClassToModelHandlerLinker)).unlock();
                throw throwable;
            }
        } else {
            throw new LogbackException("Unexpected filename extension of file [" + var1_1.toString() + "]. Should be .scmo");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildModelInterpretationContext(Model topModel) {
        void var1_1;
        this.modelInterpretationContext = new ModelInterpretationContext(this.context, (Object)this);
        this.modelInterpretationContext.setTopModel((Model)var1_1);
        LogbackClassicDefaultNestedComponentRules.addDefaultNestedComponentRegistryRules(this.modelInterpretationContext.getDefaultNestedComponentRegistry());
        this.modelInterpretationContext.createAppenderBags();
    }

    /*
     * WARNING - void declaration
     */
    private Model retrieveModel(URL url) {
        block10: {
            Model model;
            block9: {
                long start = System.currentTimeMillis();
                InputStream is = url.openStream();
                try {
                    void var2_2;
                    HardenedModelInputStream hardenedModelInputStream = new HardenedModelInputStream(is);
                    Model model2 = (Model)hardenedModelInputStream.readObject();
                    long diff = System.currentTimeMillis() - var2_2;
                    this.addInfo("Model at [" + String.valueOf(url) + "] read in " + diff + " milliseconds");
                    model = model2;
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.addError("Failed to open " + String.valueOf(url), e);
                        break block10;
                    }
                    catch (ClassNotFoundException e) {
                        void var1_1;
                        this.addError("Failed read model object in " + String.valueOf(var1_1), e);
                    }
                }
                is.close();
            }
            return model;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private URL performMultiStepModelFileSearch(boolean updateState) {
        void var1_1;
        void var2_2;
        URL uRL;
        ClassLoader myClassLoader = Loader.getClassLoaderOfObject((Object)this);
        URL url = this.findModelConfigFileURLFromSystemProperties(myClassLoader);
        if (url != null) {
            return url;
        }
        url = this.getResource(TEST_AUTOCONFIG_MODEL_FILE, myClassLoader, updateState);
        if (url != null) {
            return uRL;
        }
        uRL = this.getResource(AUTOCONFIG_MODEL_FILE, (ClassLoader)var2_2, (boolean)var1_1);
        return uRL;
    }

    /*
     * WARNING - void declaration
     */
    URL findModelConfigFileURLFromSystemProperties(ClassLoader classLoader) {
        String logbackModelFile = OptionHelper.getSystemProperty((String)"logback.scmoFile");
        if (logbackModelFile != null) {
            URL result = null;
            try {
                URL uRL = result = new URL(logbackModelFile);
                this.statusOnResourceSearch(logbackModelFile, result);
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                block9: {
                    block8: {
                        try {
                            result = Loader.getResource((String)logbackModelFile, (ClassLoader)classLoader);
                            if (result == null) break block8;
                            classLoader = result;
                            this.statusOnResourceSearch(logbackModelFile, result);
                            return classLoader;
                        }
                        catch (Throwable throwable) {
                            void var3_4;
                            void var2_3;
                            this.statusOnResourceSearch((String)var2_3, (URL)var3_4);
                            throw throwable;
                        }
                    }
                    File f = new File(logbackModelFile);
                    if (!f.exists() || !f.isFile()) break block9;
                    try {
                        URL uRL;
                        uRL = result = ((File)((Object)uRL)).toURI().toURL();
                        this.statusOnResourceSearch(logbackModelFile, result);
                        return uRL;
                    }
                    catch (MalformedURLException malformedURLException2) {}
                }
                this.statusOnResourceSearch(logbackModelFile, result);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private URL getResource(String filename, ClassLoader classLoader, boolean updateStatus) {
        void var2_2;
        void var3_3;
        URL url = Loader.getResource((String)filename, (ClassLoader)classLoader);
        if (var3_3 != false) {
            void var1_1;
            this.statusOnResourceSearch((String)var1_1, url);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void statusOnResourceSearch(String resourceName, URL url) {
        void var2_2;
        void var1_1;
        void var3_3;
        StatusManager sm = this.context.getStatusManager();
        if (url == null) {
            sm.add((Status)new InfoStatus("Could NOT find resource [" + resourceName + "]", (Object)this.context));
            return;
        }
        var3_3.add((Status)new InfoStatus("Found resource [" + (String)var1_1 + "] at [" + var2_2.toString() + "]", (Object)this.context));
    }
}

