/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.encoder.JsonEscapeUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;

public class JsonEncoder
extends EncoderBase<ILoggingEvent> {
    static final boolean DO_NOT_ADD_QUOTE_KEY = false;
    static final boolean ADD_QUOTE_KEY = true;
    static int DEFAULT_SIZE = 1024;
    static int DEFAULT_SIZE_WITH_THROWABLE = 1024 * 8;
    static byte[] EMPTY_BYTES = new byte[0];
    public static final String CONTEXT_ATTR_NAME = "context";
    public static final String NAME_ATTR_NAME = "name";
    public static final String BIRTHDATE_ATTR_NAME = "birthdate";
    public static final String CONTEXT_PROPERTIES_ATTR_NAME = "properties";
    public static final String TIMESTAMP_ATTR_NAME = "timestamp";
    public static final String NANOSECONDS_ATTR_NAME = "nanoseconds";
    public static final String SEQUENCE_NUMBER_ATTR_NAME = "sequenceNumber";
    public static final String LEVEL_ATTR_NAME = "level";
    public static final String MARKERS_ATTR_NAME = "markers";
    public static final String THREAD_NAME_ATTR_NAME = "threadName";
    public static final String MDC_ATTR_NAME = "mdc";
    public static final String LOGGER_ATTR_NAME = "loggerName";
    public static final String MESSAGE_ATTR_NAME = "message";
    public static final String FORMATTED_MESSAGE_ATTR_NAME = "formattedMessage";
    public static final String ARGUMENT_ARRAY_ATTR_NAME = "arguments";
    public static final String KEY_VALUE_PAIRS_ATTR_NAME = "kvpList";
    public static final String THROWABLE_ATTR_NAME = "throwable";
    private static final String CYCLIC_THROWABLE_ATTR_NAME = "cyclic";
    public static final String CAUSE_ATTR_NAME = "cause";
    public static final String SUPPRESSED_ATTR_NAME = "suppressed";
    public static final String COMMON_FRAMES_COUNT_ATTR_NAME = "commonFramesCount";
    public static final String CLASS_NAME_ATTR_NAME = "className";
    public static final String METHOD_NAME_ATTR_NAME = "methodName";
    private static final String FILE_NAME_ATTR_NAME = "fileName";
    private static final String LINE_NUMBER_ATTR_NAME = "lineNumber";
    public static final String STEP_ARRAY_NAME_ATTRIBUTE = "stepArray";
    private static final char OPEN_OBJ = '{';
    private static final char CLOSE_OBJ = '}';
    private static final char OPEN_ARRAY = '[';
    private static final char CLOSE_ARRAY = ']';
    private static final char QUOTE = '\"';
    private static final char SP = ' ';
    private static final char ENTRY_SEPARATOR = ':';
    private static final String COL_SP = ": ";
    private static final String QUOTE_COL = "\":";
    private static final char VALUE_SEPARATOR = ',';
    private boolean withSequenceNumber = true;
    private boolean withTimestamp = true;
    private boolean withNanoseconds = true;
    private boolean withLevel = true;
    private boolean withThreadName = true;
    private boolean withLoggerName = true;
    private boolean withContext = true;
    private boolean withMarkers = true;
    private boolean withMDC = true;
    private boolean withKVPList = true;
    private boolean withMessage = true;
    private boolean withArguments = true;
    private boolean withThrowable = true;
    private boolean withFormattedMessage = false;

    public byte[] headerBytes() {
        return EMPTY_BYTES;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encode(ILoggingEvent event) {
        void var2_3;
        int initialCapacity = event.getThrowableProxy() == null ? DEFAULT_SIZE : DEFAULT_SIZE_WITH_THROWABLE;
        StringBuilder sb = new StringBuilder(initialCapacity);
        sb.append('{');
        if (this.withSequenceNumber) {
            this.appenderMemberWithLongValue(sb, SEQUENCE_NUMBER_ATTR_NAME, event.getSequenceNumber());
        }
        if (this.withTimestamp) {
            this.appendValueSeparator(sb, this.withSequenceNumber);
            this.appenderMemberWithLongValue(sb, TIMESTAMP_ATTR_NAME, event.getTimeStamp());
        }
        if (this.withNanoseconds) {
            this.appendValueSeparator(sb, this.withSequenceNumber, this.withTimestamp);
            this.appenderMemberWithLongValue(sb, NANOSECONDS_ATTR_NAME, event.getNanoseconds());
        }
        if (this.withLevel) {
            void var3_4;
            this.appendValueSeparator(sb, this.withNanoseconds, this.withSequenceNumber, this.withTimestamp);
            String levelStr = event.getLevel() != null ? event.getLevel().levelStr : "null";
            this.appenderMember(sb, LEVEL_ATTR_NAME, (String)var3_4);
        }
        if (this.withThreadName) {
            this.appendValueSeparator(sb, this.withLevel, this.withNanoseconds, this.withSequenceNumber, this.withTimestamp);
            this.appenderMember(sb, THREAD_NAME_ATTR_NAME, this.jsonEscape(event.getThreadName()));
        }
        if (this.withLoggerName) {
            this.appendValueSeparator(sb, this.withThreadName, this.withLevel, this.withNanoseconds, this.withSequenceNumber, this.withTimestamp);
            this.appenderMember(sb, LOGGER_ATTR_NAME, event.getLoggerName());
        }
        if (this.withContext) {
            sb.append(',');
            this.appendLoggerContext(sb, event.getLoggerContextVO());
        }
        if (this.withMarkers) {
            this.appendMarkers(sb, event);
        }
        if (this.withMDC) {
            this.appendMDC(sb, event);
        }
        if (this.withKVPList) {
            this.appendKeyValuePairs(sb, event);
        }
        if (this.withMessage) {
            sb.append(',');
            this.appenderMember(sb, MESSAGE_ATTR_NAME, this.jsonEscape(event.getMessage()));
        }
        if (this.withFormattedMessage) {
            sb.append(',');
            this.appenderMember(sb, FORMATTED_MESSAGE_ATTR_NAME, this.jsonEscape(event.getFormattedMessage()));
        }
        if (this.withArguments) {
            this.appendArgumentArray(sb, event);
        }
        if (this.withThrowable) {
            void var1_1;
            this.appendThrowableProxy(sb, THROWABLE_ATTR_NAME, var1_1.getThrowableProxy());
        }
        sb.append('}');
        sb.append('\n');
        return var2_3.toString().getBytes(CoreConstants.UTF_8_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    void appendValueSeparator(StringBuilder sb, boolean ... subsequentConditionals) {
        void var3_3;
        void var2_2;
        boolean enabled = false;
        for (void var6_6 : var2_2) {
            if (var6_6 == false) continue;
            enabled = true;
            break;
        }
        if (var3_3 != false) {
            void var1_1;
            var1_1.append(',');
        }
    }

    /*
     * WARNING - void declaration
     */
    private void appendLoggerContext(StringBuilder sb, LoggerContextVO loggerContextVO) {
        void var1_1;
        void var2_2;
        sb.append('\"').append("context\":");
        if (loggerContextVO == null) {
            sb.append("null");
            return;
        }
        sb.append('{');
        this.appenderMember(sb, NAME_ATTR_NAME, this.nullSafeStr(loggerContextVO.getName()));
        sb.append(',');
        this.appenderMemberWithLongValue(sb, BIRTHDATE_ATTR_NAME, loggerContextVO.getBirthTime());
        sb.append(',');
        this.appendMap(sb, CONTEXT_PROPERTIES_ATTR_NAME, var2_2.getPropertyMap());
        var1_1.append('}');
    }

    /*
     * WARNING - void declaration
     */
    private void appendMap(StringBuilder sb, String attrName, Map<String, String> map) {
        void var1_1;
        Object object;
        sb.append('\"').append(attrName).append(QUOTE_COL);
        if (map == null) {
            sb.append("null");
            return;
        }
        sb.append('{');
        boolean addComma = false;
        object = object.entrySet();
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            if (addComma) {
                sb.append(',');
            }
            addComma = true;
            this.appenderMember(sb, this.jsonEscapedToString(entry.getKey()), this.jsonEscapedToString(entry.getValue()));
        }
        var1_1.append('}');
    }

    /*
     * WARNING - void declaration
     */
    private void appendThrowableProxy(StringBuilder sb, String attributeName, IThrowableProxy itp) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appendThrowableProxy((StringBuilder)var1_1, (String)var2_2, (IThrowableProxy)var3_3, true);
    }

    /*
     * WARNING - void declaration
     */
    private void appendThrowableProxy(StringBuilder sb, String attributeName, IThrowableProxy itp, boolean appendValueSeparator) {
        void var1_1;
        IThrowableProxy[] suppressedArray;
        IThrowableProxy cause;
        if (appendValueSeparator) {
            sb.append(',');
        }
        if (attributeName != null) {
            sb.append('\"').append(attributeName).append(QUOTE_COL);
            if (itp == null) {
                sb.append("null");
                return;
            }
        }
        sb.append('{');
        this.appenderMember(sb, CLASS_NAME_ATTR_NAME, this.nullSafeStr(itp.getClassName()));
        sb.append(',');
        this.appenderMember(sb, MESSAGE_ATTR_NAME, this.jsonEscape(itp.getMessage()));
        if (itp.isCyclic()) {
            sb.append(',');
            this.appenderMember(sb, CYCLIC_THROWABLE_ATTR_NAME, this.jsonEscape("true"));
        }
        sb.append(',');
        this.appendSTEPArray(sb, itp.getStackTraceElementProxyArray(), itp.getCommonFrames());
        if (itp.getCommonFrames() != 0) {
            sb.append(',');
            this.appenderMemberWithIntValue(sb, COMMON_FRAMES_COUNT_ATTR_NAME, itp.getCommonFrames());
        }
        if ((cause = itp.getCause()) != null) {
            this.appendThrowableProxy(sb, CAUSE_ATTR_NAME, cause);
        }
        if ((suppressedArray = itp.getSuppressed()) != null && suppressedArray.length != 0) {
            void var2_2;
            sb.append(',');
            sb.append('\"').append("suppressed\":");
            sb.append('[');
            boolean first = true;
            for (void suppressedITP : var2_2) {
                this.appendThrowableProxy(sb, null, (IThrowableProxy)suppressedITP, !first);
                if (!first) continue;
                first = false;
            }
            sb.append(']');
        }
        var1_1.append('}');
    }

    /*
     * WARNING - void declaration
     */
    private void appendSTEPArray(StringBuilder sb, StackTraceElementProxy[] stepArray, int commonFrames) {
        void var1_1;
        int len;
        sb.append('\"').append("stepArray\":").append('[');
        int n = len = stepArray != null ? stepArray.length : 0;
        if (commonFrames >= len) {
            commonFrames = 0;
        }
        for (int i = 0; i < len - commonFrames; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            StackTraceElementProxy step = stepArray[i];
            sb.append('{');
            StackTraceElement ste = step.getStackTraceElement();
            this.appenderMember(sb, CLASS_NAME_ATTR_NAME, this.nullSafeStr(ste.getClassName()));
            sb.append(',');
            this.appenderMember(sb, METHOD_NAME_ATTR_NAME, this.nullSafeStr(ste.getMethodName()));
            sb.append(',');
            this.appenderMember(sb, FILE_NAME_ATTR_NAME, this.nullSafeStr(ste.getFileName()));
            sb.append(',');
            this.appenderMemberWithIntValue(sb, LINE_NUMBER_ATTR_NAME, ste.getLineNumber());
            sb.append('}');
        }
        var1_1.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private void appenderMember(StringBuilder sb, String key, String value) {
        void var3_3;
        void var2_2;
        sb.append('\"').append((String)var2_2).append("\":\"").append((String)var3_3).append('\"');
    }

    /*
     * WARNING - void declaration
     */
    private void appenderMemberWithIntValue(StringBuilder sb, String key, int value) {
        void var3_3;
        void var2_2;
        sb.append('\"').append((String)var2_2).append(QUOTE_COL).append((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void appenderMemberWithLongValue(StringBuilder sb, String key, long value) {
        void var3_3;
        void var2_2;
        sb.append('\"').append((String)var2_2).append(QUOTE_COL).append((long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void appendKeyValuePairs(StringBuilder sb, ILoggingEvent event) {
        void var1_1;
        List<KeyValuePair> kvpList = event.getKeyValuePairs();
        if (kvpList == null || kvpList.isEmpty()) {
            return;
        }
        sb.append(',');
        sb.append('\"').append("kvpList\":").append(' ').append('[');
        int len = kvpList.size();
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            KeyValuePair kvp = kvpList.get(i);
            sb.append('{');
            this.appenderMember(sb, this.jsonEscapedToString(kvp.key), this.jsonEscapedToString(kvp.value));
            sb.append('}');
        }
        var1_1.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private void appendArgumentArray(StringBuilder sb, ILoggingEvent event) {
        void var1_1;
        Object[] argumentArray = event.getArgumentArray();
        if (argumentArray == null) {
            return;
        }
        sb.append(',');
        sb.append('\"').append("arguments\":").append(' ').append('[');
        int len = argumentArray.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append('\"').append(this.jsonEscapedToString(argumentArray[i])).append('\"');
        }
        var1_1.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private void appendMarkers(StringBuilder sb, ILoggingEvent event) {
        void var1_1;
        List<Marker> markerList = event.getMarkerList();
        if (markerList == null) {
            return;
        }
        sb.append(',');
        sb.append('\"').append("markers\":").append(' ').append('[');
        int len = markerList.size();
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append('\"').append(this.jsonEscapedToString(markerList.get(i))).append('\"');
        }
        var1_1.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private String jsonEscapedToString(Object o) {
        void var1_1;
        if (o == null) {
            return "null";
        }
        return JsonEscapeUtil.jsonEscapeString((String)var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    private String nullSafeStr(String s) {
        void var1_1;
        if (s == null) {
            return "null";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String jsonEscape(String s) {
        void var1_1;
        if (s == null) {
            return "null";
        }
        return JsonEscapeUtil.jsonEscapeString((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void appendMDC(StringBuilder sb, ILoggingEvent event) {
        void var1_1;
        Map<String, String> map = event.getMDCPropertyMap();
        sb.append(',');
        sb.append('\"').append("mdc\":").append(' ').append('{');
        if (this.isNotEmptyMap(map)) {
            Iterator iterator;
            Set<Map.Entry<String, String>> entrySet = map.entrySet();
            int i = 0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (i != 0) {
                    sb.append(',');
                }
                this.appenderMember(sb, this.jsonEscapedToString(entry.getKey()), this.jsonEscapedToString(entry.getValue()));
                ++i;
            }
        }
        var1_1.append('}');
    }

    /*
     * WARNING - void declaration
     */
    boolean isNotEmptyMap(Map map) {
        void var1_1;
        if (map == null) {
            return false;
        }
        return !var1_1.isEmpty();
    }

    public byte[] footerBytes() {
        return EMPTY_BYTES;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithSequenceNumber(boolean withSequenceNumber) {
        void var1_1;
        this.withSequenceNumber = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithTimestamp(boolean withTimestamp) {
        void var1_1;
        this.withTimestamp = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithNanoseconds(boolean withNanoseconds) {
        void var1_1;
        this.withNanoseconds = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithLevel(boolean withLevel) {
        void var1_1;
        this.withLevel = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithThreadName(boolean withThreadName) {
        void var1_1;
        this.withThreadName = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithLoggerName(boolean withLoggerName) {
        void var1_1;
        this.withLoggerName = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithContext(boolean withContext) {
        void var1_1;
        this.withContext = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithMarkers(boolean withMarkers) {
        void var1_1;
        this.withMarkers = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithMDC(boolean withMDC) {
        void var1_1;
        this.withMDC = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithKVPList(boolean withKVPList) {
        void var1_1;
        this.withKVPList = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithMessage(boolean withMessage) {
        void var1_1;
        this.withMessage = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithArguments(boolean withArguments) {
        void var1_1;
        this.withArguments = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithThrowable(boolean withThrowable) {
        void var1_1;
        this.withThrowable = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithFormattedMessage(boolean withFormattedMessage) {
        void var1_1;
        this.withFormattedMessage = var1_1;
    }
}

