/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.Util;
import okio.Utf8;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0014J\u001f\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0011J#\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0018J\u001f\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0011J\u0013\u0010\u001b\u001a\u00020\u0007*\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u000f*\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e"}, d2={"Lokhttp3/internal/tls/OkHostnameVerifier;", "Ljavax/net/ssl/HostnameVerifier;", "<init>", "()V", "Ljava/security/cert/X509Certificate;", "certificate", "", "", "allSubjectAltNames", "(Ljava/security/cert/X509Certificate;)Ljava/util/List;", "", "type", "getSubjectAltNames", "(Ljava/security/cert/X509Certificate;I)Ljava/util/List;", "host", "", "verify", "(Ljava/lang/String;Ljava/security/cert/X509Certificate;)Z", "Ljavax/net/ssl/SSLSession;", "session", "(Ljava/lang/String;Ljavax/net/ssl/SSLSession;)Z", "hostname", "verifyHostname", "pattern", "(Ljava/lang/String;Ljava/lang/String;)Z", "ipAddress", "verifyIpAddress", "asciiToLowercase", "(Ljava/lang/String;)Ljava/lang/String;", "isAscii", "(Ljava/lang/String;)Z"})
@SourceDebugExtension(value={"SMAP\nOkHostnameVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHostnameVerifier.kt\nokhttp3/internal/tls/OkHostnameVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1747#2,3:209\n1747#2,3:212\n*S KotlinDebug\n*F\n+ 1 OkHostnameVerifier.kt\nokhttp3/internal/tls/OkHostnameVerifier\n*L\n63#1:209,3\n71#1:212,3\n*E\n"})
public final class OkHostnameVerifier
implements HostnameVerifier {
    public static final OkHostnameVerifier INSTANCE = new OkHostnameVerifier();

    private OkHostnameVerifier() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean verify(String host, SSLSession session) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!OkHostnameVerifier.isAscii(host)) {
            return false;
        }
        try {
            void var1_1;
            void var2_3;
            Certificate certificate = var2_3.getPeerCertificates()[0];
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            bl = this.verify((String)var1_1, (X509Certificate)certificate);
        }
        catch (SSLException sSLException) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean verify(String host, X509Certificate certificate) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        if (Util.canParseAsIpAddress(host)) {
            return this.verifyIpAddress(host, certificate);
        }
        return this.verifyHostname((String)var1_1, (X509Certificate)var2_2);
    }

    private final boolean verifyIpAddress(String ipAddress, X509Certificate certificate) {
        String canonicalIpAddress = HostnamesKt.toCanonicalHost(ipAddress);
        Iterable $this$any$iv = OkHostnameVerifier.getSubjectAltNames(certificate, 7);
        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                String it = (String)t;
                if (!Intrinsics.areEqual((Object)canonicalIpAddress, (Object)HostnamesKt.toCanonicalHost(t))) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean verifyHostname(String hostname, X509Certificate certificate) {
        hostname = this.asciiToLowercase(hostname);
        Iterable $this$any$iv = OkHostnameVerifier.getSubjectAltNames(certificate, 2);
        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                String it = (String)t;
                if (!INSTANCE.verifyHostname(hostname, (String)t)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final String asciiToLowercase(String $this$asciiToLowercase) {
        void var1_1;
        if (OkHostnameVerifier.isAscii($this$asciiToLowercase)) {
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string = $this$asciiToLowercase.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
            return string;
        }
        return var1_1;
    }

    private static boolean isAscii(String $this$isAscii) {
        String string;
        return $this$isAscii.length() == (int)Utf8.size$default((String)string, (int)0, (int)0, (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean verifyHostname(String hostname, String pattern) {
        void var2_3;
        void var1_1;
        CharSequence charSequence = hostname;
        if (charSequence == null || charSequence.length() == 0 || StringsKt.startsWith$default((String)hostname, (String)".", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)hostname, (String)"..", (boolean)false, (int)2, null)) {
            return false;
        }
        charSequence = pattern;
        if (charSequence == null || charSequence.length() == 0 || StringsKt.startsWith$default((String)pattern, (String)".", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)pattern, (String)"..", (boolean)false, (int)2, null)) {
            return false;
        }
        if (!StringsKt.endsWith$default((String)hostname, (String)".", (boolean)false, (int)2, null)) {
            hostname = hostname + '.';
        }
        if (!StringsKt.endsWith$default((String)pattern, (String)".", (boolean)false, (int)2, null)) {
            pattern = pattern + '.';
        }
        if (!StringsKt.contains$default((CharSequence)(pattern = this.asciiToLowercase(pattern)), (CharSequence)"*", (boolean)false, (int)2, null)) {
            return Intrinsics.areEqual((Object)hostname, (Object)pattern);
        }
        if (!StringsKt.startsWith$default((String)pattern, (String)"*.", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)pattern, (char)'*', (int)1, (boolean)false, (int)4, null) != -1) {
            return false;
        }
        if (hostname.length() < pattern.length()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)"*.", (Object)pattern)) {
            return false;
        }
        String string = pattern.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String suffix = string;
        if (!StringsKt.endsWith$default((String)hostname, (String)suffix, (boolean)false, (int)2, null)) {
            return false;
        }
        int suffixStartIndexInHostname = hostname.length() - ((String)charSequence).length();
        return suffixStartIndexInHostname <= 0 || StringsKt.lastIndexOf$default((CharSequence)((CharSequence)var1_1), (char)'.', (int)(var2_3 - true), (boolean)false, (int)4, null) == -1;
    }

    /*
     * WARNING - void declaration
     */
    public final List<String> allSubjectAltNames(X509Certificate certificate) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        List<String> altIpaNames = OkHostnameVerifier.getSubjectAltNames(certificate, 7);
        List<String> altDnsNames = OkHostnameVerifier.getSubjectAltNames(certificate, 2);
        return CollectionsKt.plus((Collection)((Collection)var2_2), (Iterable)((Iterable)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> getSubjectAltNames(X509Certificate certificate, int type) {
        try {
            void var2_2;
            Iterator iterator;
            Collection<List<?>> collection = certificate.getSubjectAlternativeNames();
            if (collection == null) {
                return CollectionsKt.emptyList();
            }
            Iterator subjectAltNames = collection;
            List result = new ArrayList();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                List subjectAltName = (List)iterator.next();
                if (subjectAltName == null || subjectAltName.size() < 2 || !Intrinsics.areEqual(subjectAltName.get(0), (Object)type) || subjectAltName.get(1) == null) continue;
                result.add((String)var3_3);
            }
            return var2_2;
        }
        catch (CertificateParsingException certificateParsingException) {
            return CollectionsKt.emptyList();
        }
    }
}

