/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import okio.Okio;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u000b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0013\u0010\u0006J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0018\u0010\u0019"}, d2={"Lokhttp3/internal/io/FileSystem;", "", "Ljava/io/File;", "file", "Lokio/Sink;", "appendingSink", "(Ljava/io/File;)Lokio/Sink;", "", "delete", "(Ljava/io/File;)V", "directory", "deleteContents", "", "exists", "(Ljava/io/File;)Z", "from", "to", "rename", "(Ljava/io/File;Ljava/io/File;)V", "sink", "", "size", "(Ljava/io/File;)J", "Lokio/Source;", "source", "(Ljava/io/File;)Lokio/Source;", "Companion"})
public interface FileSystem {
    public static final Companion Companion = okhttp3.internal.io.FileSystem$Companion.$$INSTANCE;
    @JvmField
    public static final FileSystem SYSTEM = new Companion.SystemFileSystem();

    public Source source(File var1) throws FileNotFoundException;

    public Sink sink(File var1) throws FileNotFoundException;

    public Sink appendingSink(File var1) throws FileNotFoundException;

    public void delete(File var1) throws IOException;

    public boolean exists(File var1);

    public long size(File var1);

    public void rename(File var1, File var2) throws IOException;

    public void deleteContents(File var1) throws IOException;

    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }

        private static final class SystemFileSystem
        implements FileSystem {
            /*
             * WARNING - void declaration
             */
            @Override
            public final Source source(File file) throws FileNotFoundException {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return Okio.source((File)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final Sink sink(File file) throws FileNotFoundException {
                Sink sink;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                try {
                    sink = Okio.sink$default((File)file, (boolean)false, (int)1, null);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    void var1_1;
                    file.getParentFile().mkdirs();
                    sink = Okio.sink$default((File)var1_1, (boolean)false, (int)1, null);
                }
                return sink;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final Sink appendingSink(File file) throws FileNotFoundException {
                Sink sink;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                try {
                    sink = Okio.appendingSink((File)file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    void var1_1;
                    file.getParentFile().mkdirs();
                    sink = Okio.appendingSink((File)var1_1);
                }
                return sink;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void delete(File file) throws IOException {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!file.delete() && file.exists()) {
                    void var1_1;
                    throw new IOException("failed to delete " + var1_1);
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean exists(File file) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return var1_1.exists();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final long size(File file) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return var1_1.length();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void rename(File from, File to) throws IOException {
                Intrinsics.checkNotNullParameter((Object)from, (String)"from");
                Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                this.delete(to);
                if (!from.renameTo(to)) {
                    void var2_2;
                    void var1_1;
                    throw new IOException("failed to rename " + var1_1 + " to " + var2_2);
                }
            }

            @Override
            public final void deleteContents(File directory) throws IOException {
                Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                File[] fileArray = directory.listFiles();
                if (fileArray == null) {
                    throw new IOException("not a readable directory: " + directory);
                }
                for (File file : fileArray) {
                    if (file.isDirectory()) {
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                        this.deleteContents(file);
                    }
                    if (file.delete()) continue;
                    throw new IOException("failed to delete " + file);
                }
            }

            public final String toString() {
                return "FileSystem.SYSTEM";
            }
        }
    }
}

