/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okio.ByteString;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ5\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0013"}, d2={"Lokhttp3/internal/http2/Http2;", "", "<init>", "()V", "", "type", "", "formattedType$okhttp", "(I)Ljava/lang/String;", "formattedType", "", "inbound", "streamId", "length", "flags", "frameLog", "(ZIIII)Ljava/lang/String;", "", "BINARY", "[Ljava/lang/String;", "Lokio/ByteString;", "CONNECTION_PREFACE", "Lokio/ByteString;", "FLAGS", "FRAME_NAMES"})
public final class Http2 {
    public static final Http2 INSTANCE = new Http2();
    @JvmField
    public static final ByteString CONNECTION_PREFACE = ByteString.Companion.encodeUtf8("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
    private static final String[] FRAME_NAMES;
    private static final String[] FLAGS;
    private static final String[] BINARY;

    private Http2() {
    }

    /*
     * WARNING - void declaration
     */
    public final String frameLog(boolean inbound, int streamId, int length, int type, int flags) {
        void var3_4;
        void var2_3;
        void var1_2;
        String string;
        String formattedType = Http2.formattedType$okhttp(type);
        int n = flags;
        if (n == 0) {
            string = "";
        } else {
            switch (type) {
                case 4: 
                case 6: {
                    if (n == 1) {
                        string = "ACK";
                        break;
                    }
                    string = BINARY[n];
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    string = BINARY[n];
                    break;
                }
                default: {
                    String string2;
                    String string3;
                    if (n < FLAGS.length) {
                        String string4 = FLAGS[n];
                        string3 = string4;
                        Intrinsics.checkNotNull((Object)string4);
                    } else {
                        string3 = string2 = BINARY[n];
                    }
                    string = type == 5 && (n & 4) != 0 ? StringsKt.replace$default((String)string2, (String)"HEADERS", (String)"PUSH_PROMISE", (boolean)false, (int)4, null) : (type == 0 && (n & 0x20) != 0 ? StringsKt.replace$default((String)string2, (String)"PRIORITY", (String)"COMPRESSED", (boolean)false, (int)4, null) : string2);
                }
            }
        }
        String formattedFlags = string;
        String direction = inbound ? "<<" : ">>";
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = objectArray;
        objectArray[0] = var1_2;
        objectArray2[1] = (int)var2_3;
        objectArray2[2] = (int)var3_4;
        objectArray2[3] = formattedType;
        objectArray2[4] = formattedFlags;
        return Util.format("%s 0x%08x %5d %-13s %s", objectArray2);
    }

    public static String formattedType$okhttp(int type) {
        int n;
        if (type < FRAME_NAMES.length) {
            return FRAME_NAMES[type];
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n;
        return Util.format("0x%02x", objectArray2);
    }

    static {
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        stringArray[0] = "DATA";
        stringArray2[1] = "HEADERS";
        stringArray2[2] = "PRIORITY";
        stringArray2[3] = "RST_STREAM";
        stringArray2[4] = "SETTINGS";
        stringArray2[5] = "PUSH_PROMISE";
        stringArray2[6] = "PING";
        stringArray2[7] = "GOAWAY";
        stringArray2[8] = "WINDOW_UPDATE";
        stringArray2[9] = "CONTINUATION";
        FRAME_NAMES = stringArray2;
        FLAGS = new String[64];
        int n = 0;
        Object[] objectArray = new String[256];
        while (n < 256) {
            int n2 = n++;
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            String string = Integer.toBinaryString(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toBinaryString(it)");
            objectArray2[0] = string;
            objectArray[n2] = StringsKt.replace$default((String)Util.format("%8s", objectArray3), (char)' ', (char)'0', (boolean)false, (int)4, null);
        }
        BINARY = objectArray;
        Http2.FLAGS[0] = "";
        Http2.FLAGS[1] = "END_STREAM";
        int[] nArray = new int[1];
        objectArray = nArray;
        nArray[0] = 1;
        Object[] prefixFlags = objectArray;
        Http2.FLAGS[8] = "PADDED";
        int cfr_ignored_0 = prefixFlags.length;
        for (int i = 0; i <= 0; ++i) {
            String prefixFlag = prefixFlags[0];
            Http2.FLAGS[prefixFlag | 8] = FLAGS[prefixFlag] + "|PADDED";
        }
        Http2.FLAGS[4] = "END_HEADERS";
        Http2.FLAGS[32] = "PRIORITY";
        Http2.FLAGS[36] = "END_HEADERS|PRIORITY";
        int[] nArray2 = new int[3];
        int[] nArray3 = nArray2;
        nArray2[0] = 4;
        nArray3[1] = 32;
        nArray3[2] = 36;
        int[] frameFlags = nArray3;
        int cfr_ignored_1 = frameFlags.length;
        for (int i = 0; i < 3; ++i) {
            int frameFlag = frameFlags[i];
            int cfr_ignored_2 = prefixFlags.length;
            for (int j = 0; j <= 0; ++j) {
                String prefixFlag = prefixFlags[j];
                Http2.FLAGS[prefixFlag | frameFlag] = FLAGS[prefixFlag] + '|' + FLAGS[frameFlag];
                Http2.FLAGS[prefixFlag | frameFlag | 8] = FLAGS[prefixFlag] + '|' + FLAGS[frameFlag] + "|PADDED";
            }
        }
        int n3 = FLAGS.length;
        for (int i = 0; i < n3; ++i) {
            if (FLAGS[i] != null) continue;
            Http2.FLAGS[i] = BINARY[i];
        }
    }
}

