/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.IOException;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;

@SourceDebugExtension(value={"SMAP\nRealInterceptorChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealInterceptorChain.kt\nokhttp3/internal/http/RealInterceptorChain\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class RealInterceptorChain
implements Interceptor.Chain {
    private final RealCall call;
    private final List<Interceptor> interceptors;
    private final int index;
    private final Exchange exchange;
    private final Request request;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final int writeTimeoutMillis;
    private int calls;

    /*
     * WARNING - void declaration
     */
    public RealInterceptorChain(RealCall call, List<? extends Interceptor> interceptors, int index, Exchange exchange, Request request, int connectTimeoutMillis, int readTimeoutMillis, int writeTimeoutMillis) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.call = var1_1;
        this.interceptors = var2_2;
        this.index = var3_3;
        this.exchange = exchange;
        this.request = request;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    public final RealCall getCall$okhttp() {
        return this.call;
    }

    public final Exchange getExchange$okhttp() {
        return this.exchange;
    }

    public final Request getRequest$okhttp() {
        return this.request;
    }

    public final int getConnectTimeoutMillis$okhttp() {
        return this.connectTimeoutMillis;
    }

    public final int getReadTimeoutMillis$okhttp() {
        return this.readTimeoutMillis;
    }

    public final int getWriteTimeoutMillis$okhttp() {
        return this.writeTimeoutMillis;
    }

    public static /* synthetic */ RealInterceptorChain copy$okhttp$default$194b511d(RealInterceptorChain realInterceptorChain, int n, Exchange exchange, Request request, int n2, int n3, int n4, int n5) {
        if ((n5 & 1) != 0) {
            n = realInterceptorChain.index;
        }
        if ((n5 & 2) != 0) {
            exchange = realInterceptorChain.exchange;
        }
        if ((n5 & 4) != 0) {
            request = realInterceptorChain.request;
        }
        if ((n5 & 8) != 0) {
            n2 = realInterceptorChain.connectTimeoutMillis;
        }
        if ((n5 & 0x10) != 0) {
            n3 = realInterceptorChain.readTimeoutMillis;
        }
        if ((n5 & 0x20) != 0) {
            n4 = realInterceptorChain.writeTimeoutMillis;
        }
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new RealInterceptorChain(realInterceptorChain.call, realInterceptorChain.interceptors, n, exchange, request, n2, n3, n4);
    }

    public final int readTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    @Override
    public final Call call() {
        return this.call;
    }

    @Override
    public final Request request() {
        return this.request;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Response proceed(Request request) throws IOException {
        void var3_4;
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(this.index < this.interceptors.size())) {
            request = "Check failed.";
            throw new IllegalStateException(request.toString());
        }
        int n = this.calls;
        this.calls = n + 1;
        if (this.exchange != null) {
            if (!this.exchange.getFinder$okhttp().sameHostAndPort(((Request)request).url())) {
                request = "network interceptor " + this.interceptors.get(this.index - 1) + " must retain the same host and port";
                throw new IllegalStateException(request.toString());
            }
            if (!(this.calls == 1)) {
                request = "network interceptor " + this.interceptors.get(this.index - 1) + " must call proceed() exactly once";
                throw new IllegalStateException(request.toString());
            }
        }
        RealInterceptorChain realInterceptorChain = this;
        RealInterceptorChain next = RealInterceptorChain.copy$okhttp$default$194b511d(realInterceptorChain, realInterceptorChain.index + 1, null, (Request)request, 0, 0, 0, 58);
        Object interceptor = this.interceptors.get(this.index);
        Response response = interceptor.intercept(next);
        if (response == null) {
            throw new NullPointerException("interceptor " + interceptor + " returned null");
        }
        Response response2 = response;
        if (this.exchange != null && !(this.index + 1 >= this.interceptors.size() || var2_3.calls == 1)) {
            interceptor = "network interceptor " + interceptor + " must call proceed() exactly once";
            throw new IllegalStateException(interceptor.toString());
        }
        if (!(response2.body() != null)) {
            String string;
            string = "interceptor " + string + " returned a response with no body";
            throw new IllegalStateException(string.toString());
        }
        return var3_4;
    }
}

