/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RealResponseBody;
import okio.GzipSource;
import okio.Okio;
import okio.Source;

@SourceDebugExtension(value={"SMAP\nBridgeInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeInterceptor.kt\nokhttp3/internal/http/BridgeInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1864#2,3:118\n*S KotlinDebug\n*F\n+ 1 BridgeInterceptor.kt\nokhttp3/internal/http/BridgeInterceptor\n*L\n111#1:118,3\n*E\n"})
public final class BridgeInterceptor
implements Interceptor {
    private final CookieJar cookieJar;

    /*
     * WARNING - void declaration
     */
    public BridgeInterceptor(CookieJar cookieJar) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)cookieJar, (String)"cookieJar");
        this.cookieJar = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Response intercept(Interceptor.Chain chain) throws IOException {
        void var1_1;
        ResponseBody responseBody;
        List<Cookie> cookies;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request userRequest = chain.request();
        Request.Builder requestBuilder = userRequest.newBuilder();
        RequestBody body = userRequest.body();
        if (body != null) {
            long contentLength;
            MediaType contentType = body.contentType();
            if (contentType != null) {
                requestBuilder.header("Content-Type", contentType.toString());
            }
            if ((contentLength = body.contentLength()) != -1L) {
                requestBuilder.header("Content-Length", String.valueOf(contentLength));
                requestBuilder.removeHeader("Transfer-Encoding");
            } else {
                requestBuilder.header("Transfer-Encoding", "chunked");
                requestBuilder.removeHeader("Content-Length");
            }
        }
        if (userRequest.header("Host") == null) {
            requestBuilder.header("Host", Util.toHostHeader$default$11ec9d50(userRequest.url(), false, 1));
        }
        if (userRequest.header("Connection") == null) {
            requestBuilder.header("Connection", "Keep-Alive");
        }
        boolean transparentGzip = false;
        if (userRequest.header("Accept-Encoding") == null && userRequest.header("Range") == null) {
            transparentGzip = true;
            requestBuilder.header("Accept-Encoding", "gzip");
        }
        if (!((Collection)(cookies = this.cookieJar.loadForRequest(userRequest.url()))).isEmpty()) {
            StringBuilder stringBuilder;
            Object object = cookies;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            object = (Iterable)object;
            int n = 0;
            object = object.iterator();
            while (object.hasNext()) {
                int n2;
                Object object2 = object.next();
                if ((n2 = n++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                object2 = (Cookie)object2;
                if (n2 > 0) {
                    stringBuilder2.append("; ");
                }
                stringBuilder2.append(((Cookie)object2).name()).append('=').append(((Cookie)object2).value());
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            requestBuilder.header("Cookie", string);
        }
        if (userRequest.header("User-Agent") == null) {
            requestBuilder.header("User-Agent", "okhttp/4.12.0");
        }
        Response networkResponse = chain.proceed(requestBuilder.build());
        HttpHeaders.receiveHeaders(this.cookieJar, userRequest.url(), networkResponse.headers());
        Response.Builder responseBuilder = networkResponse.newBuilder().request(userRequest);
        if (transparentGzip && StringsKt.equals((String)"gzip", (String)Response.header$default$b4243d8(networkResponse, "Content-Encoding", null, 2), (boolean)true) && HttpHeaders.promisesBody(networkResponse) && (responseBody = networkResponse.body()) != null) {
            void var2_2;
            void var3_3;
            GzipSource gzipSource = new GzipSource((Source)responseBody.source());
            Headers strippedHeaders = networkResponse.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
            responseBuilder.headers(strippedHeaders);
            String contentType = Response.header$default$b4243d8(networkResponse, "Content-Type", null, 2);
            responseBuilder.body(new RealResponseBody((String)var3_3, -1L, Okio.buffer((Source)((Source)var2_2))));
        }
        return var1_1.build();
    }
}

