/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RouteDatabase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0002#$B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\fH\u0086\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u0010H\u0086\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0014R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0015R\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0019R\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\""}, d2={"Lokhttp3/internal/connection/RouteSelector;", "", "Lokhttp3/Address;", "address", "Lokhttp3/internal/connection/RouteDatabase;", "routeDatabase", "Lokhttp3/Call;", "call", "Lokhttp3/EventListener;", "eventListener", "<init>", "(Lokhttp3/Address;Lokhttp3/internal/connection/RouteDatabase;Lokhttp3/Call;Lokhttp3/EventListener;)V", "", "hasNext", "()Z", "hasNextProxy", "Lokhttp3/internal/connection/RouteSelector$Selection;", "next", "()Lokhttp3/internal/connection/RouteSelector$Selection;", "Lokhttp3/Address;", "Lokhttp3/Call;", "Lokhttp3/EventListener;", "", "Ljava/net/InetSocketAddress;", "inetSocketAddresses", "Ljava/util/List;", "", "nextProxyIndex", "I", "", "Lokhttp3/Route;", "postponedRoutes", "Ljava/net/Proxy;", "proxies", "Lokhttp3/internal/connection/RouteDatabase;", "Companion", "Selection"})
public final class RouteSelector {
    public static final Companion Companion = new Companion(null);
    private final Address address;
    private final RouteDatabase routeDatabase;
    private final Call call;
    private final EventListener eventListener;
    private List<? extends Proxy> proxies;
    private int nextProxyIndex;
    private List<? extends InetSocketAddress> inetSocketAddresses;
    private final List<Route> postponedRoutes;

    public RouteSelector(Address address, RouteDatabase routeDatabase, Call call, EventListener eventListener) {
        List<Proxy> list;
        Object object;
        HttpUrl httpUrl;
        RouteSelector routeSelector;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)routeDatabase, (String)"routeDatabase");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        this.address = routeSelector;
        this.routeDatabase = httpUrl;
        this.call = object;
        this.eventListener = eventListener;
        this.proxies = CollectionsKt.emptyList();
        this.inetSocketAddresses = CollectionsKt.emptyList();
        this.postponedRoutes = new ArrayList();
        RouteSelector routeSelector2 = this;
        object = this.address.proxy();
        httpUrl = routeSelector2.address.url();
        routeSelector = routeSelector2;
        EventListener cfr_ignored_0 = routeSelector2.eventListener;
        EventListener.proxySelectStart(routeSelector.call, httpUrl);
        RouteSelector routeSelector3 = routeSelector;
        Object object2 = httpUrl;
        if (object != null) {
            list = CollectionsKt.listOf((Object)object);
        } else {
            object = object2.uri();
            if (object.getHost() == null) {
                Proxy[] proxyArray = new Proxy[1];
                object = proxyArray;
                proxyArray[0] = Proxy.NO_PROXY;
                list = Util.immutableListOf(object);
            } else {
                object = routeSelector3.address.proxySelector().select((URI)object);
                object2 = (Collection)object;
                if (object2 == null || object2.isEmpty()) {
                    Proxy[] proxyArray = new Proxy[1];
                    object2 = proxyArray;
                    proxyArray[0] = Proxy.NO_PROXY;
                    list = Util.immutableListOf(object2);
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"proxiesOrNull");
                    list = Util.toImmutableList(object);
                }
            }
        }
        routeSelector.proxies = list;
        routeSelector.nextProxyIndex = 0;
        EventListener cfr_ignored_1 = routeSelector.eventListener;
        EventListener.proxySelectEnd(routeSelector.call, httpUrl, routeSelector.proxies);
    }

    public final boolean hasNext() {
        return this.hasNextProxy() || !((Collection)this.postponedRoutes).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final Selection next() throws IOException {
        void var1_1;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List routes = new ArrayList();
        while (this.hasNextProxy()) {
            Object object;
            int n;
            String string;
            List list;
            RouteSelector routeSelector = this;
            if (!routeSelector.hasNextProxy()) {
                throw new SocketException("No route to " + routeSelector.address.url().host() + "; exhausted proxy configurations: " + routeSelector.proxies);
            }
            int n2 = routeSelector.nextProxyIndex;
            routeSelector.nextProxyIndex = n2 + 1;
            Proxy proxy = routeSelector.proxies.get(n2);
            Proxy proxy2 = proxy;
            RouteSelector routeSelector2 = routeSelector;
            routeSelector2.inetSocketAddresses = list = (List)new ArrayList();
            if (proxy2.type() == Proxy.Type.DIRECT || proxy2.type() == Proxy.Type.SOCKS) {
                string = routeSelector2.address.url().host();
                n = routeSelector2.address.url().port();
            } else {
                object = proxy2.address();
                if (!(object instanceof InetSocketAddress)) {
                    String string2 = "Proxy.address() is not an InetSocketAddress: " + object.getClass();
                    throw new IllegalArgumentException(string2.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"proxyAddress");
                string = okhttp3.internal.connection.RouteSelector$Companion.getSocketHost((InetSocketAddress)object);
                n = ((InetSocketAddress)object).getPort();
            }
            if (!(n > 0 ? n < 65536 : false)) {
                throw new SocketException("No route to " + string + ':' + n + "; port is out of range");
            }
            if (proxy2.type() == Proxy.Type.SOCKS) {
                ((Collection)list).add(InetSocketAddress.createUnresolved(string, n));
            } else {
                List<InetAddress> list2;
                if (Util.canParseAsIpAddress(string)) {
                    list2 = CollectionsKt.listOf((Object)InetAddress.getByName(string));
                } else {
                    EventListener cfr_ignored_0 = routeSelector2.eventListener;
                    EventListener.dnsStart(routeSelector2.call, string);
                    List<InetAddress> list3 = routeSelector2.address.dns().lookup(string);
                    if (list3.isEmpty()) {
                        throw new UnknownHostException(routeSelector2.address.dns() + " returned no addresses for " + string);
                    }
                    EventListener cfr_ignored_1 = routeSelector2.eventListener;
                    EventListener.dnsEnd(routeSelector2.call, string, list3);
                    list2 = list3;
                }
                object = list2;
                for (InetAddress inetAddress : list2) {
                    ((Collection)list).add(new InetSocketAddress(inetAddress, n));
                }
            }
            Proxy object22 = proxy;
            for (InetSocketAddress inetSocketAddress : this.inetSocketAddresses) {
                Route route = new Route(this.address, object22, inetSocketAddress);
                if (this.routeDatabase.shouldPostpone(route)) {
                    ((Collection)this.postponedRoutes).add(route);
                    continue;
                }
                ((Collection)routes).add(route);
            }
            if (!(!((Collection)routes).isEmpty())) continue;
        }
        if (routes.isEmpty()) {
            CollectionsKt.addAll((Collection)routes, (Iterable)this.postponedRoutes);
            this.postponedRoutes.clear();
        }
        return new Selection((List<Route>)var1_1);
    }

    private final boolean hasNextProxy() {
        return this.nextProxyIndex < this.proxies.size();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0015\u0010\b\u001a\u00020\u0005*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007"}, d2={"Lokhttp3/internal/connection/RouteSelector$Companion;", "", "<init>", "()V", "Ljava/net/InetSocketAddress;", "", "getSocketHost", "(Ljava/net/InetSocketAddress;)Ljava/lang/String;", "socketHost"})
    public static final class Companion {
        private Companion() {
        }

        public static String getSocketHost(InetSocketAddress $this$socketHost) {
            Serializable serializable;
            Intrinsics.checkNotNullParameter((Object)$this$socketHost, (String)"<this>");
            InetAddress inetAddress = $this$socketHost.getAddress();
            if (inetAddress == null) {
                String string = serializable.getHostName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hostName");
                return string;
            }
            serializable = inetAddress;
            String string = inetAddress.getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"address.hostAddress");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Selection {
        private final List<Route> routes;
        private int nextRouteIndex;

        /*
         * WARNING - void declaration
         */
        public Selection(List<Route> routes) {
            void var1_1;
            Intrinsics.checkNotNullParameter(routes, (String)"routes");
            this.routes = var1_1;
        }

        public final List<Route> getRoutes() {
            return this.routes;
        }

        public final boolean hasNext() {
            return this.nextRouteIndex < this.routes.size();
        }

        public final Route next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = this.nextRouteIndex;
            this.nextRouteIndex = n + 1;
            return this.routes.get(n);
        }
    }
}

