/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.IOException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ForwardingSink;
import okio.Sink;

public final class FaultHidingSink
extends ForwardingSink {
    private final Function1<IOException, Unit> onException;
    private boolean hasErrors;

    /*
     * WARNING - void declaration
     */
    public FaultHidingSink(Sink delegate, Function1<? super IOException, Unit> onException) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(onException, (String)"onException");
        super((Sink)var1_1);
        this.onException = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void write(Buffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.hasErrors) {
            source.skip(byteCount);
            return;
        }
        try {
            void var2_3;
            super.write(source, (long)var2_3);
            return;
        }
        catch (IOException e) {
            void var1_2;
            this.hasErrors = true;
            this.onException.invoke((Object)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void flush() {
        if (this.hasErrors) {
            return;
        }
        try {
            super.flush();
            return;
        }
        catch (IOException e) {
            void var1_1;
            this.hasErrors = true;
            this.onException.invoke((Object)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void close() {
        if (this.hasErrors) {
            return;
        }
        try {
            super.close();
            return;
        }
        catch (IOException e) {
            void var1_1;
            this.hasErrors = true;
            this.onException.invoke((Object)var1_1);
            return;
        }
    }
}

