/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.http.DatesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u001d\b\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\b\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\r"}, d2={"Lokhttp3/internal/cache/CacheStrategy;", "", "Lokhttp3/Request;", "networkRequest", "Lokhttp3/Response;", "cacheResponse", "<init>", "(Lokhttp3/Request;Lokhttp3/Response;)V", "Lokhttp3/Response;", "getCacheResponse", "()Lokhttp3/Response;", "Lokhttp3/Request;", "getNetworkRequest", "()Lokhttp3/Request;", "Companion", "Factory"})
public final class CacheStrategy {
    public static final Companion Companion = new Companion(null);
    private final Request networkRequest;
    private final Response cacheResponse;

    /*
     * WARNING - void declaration
     */
    public CacheStrategy(Request networkRequest, Response cacheResponse) {
        void var2_2;
        void var1_1;
        this.networkRequest = var1_1;
        this.cacheResponse = var2_2;
    }

    public final Request getNetworkRequest() {
        return this.networkRequest;
    }

    public final Response getCacheResponse() {
        return this.cacheResponse;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lokhttp3/internal/cache/CacheStrategy$Companion;", "", "<init>", "()V", "Lokhttp3/Response;", "response", "Lokhttp3/Request;", "request", "", "isCacheable", "(Lokhttp3/Response;Lokhttp3/Request;)Z"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public static boolean isCacheable(Response response, Request request) {
            void var1_1;
            Response response2;
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            switch (response.code()) {
                case 200: 
                case 203: 
                case 204: 
                case 300: 
                case 301: 
                case 308: 
                case 404: 
                case 405: 
                case 410: 
                case 414: 
                case 501: {
                    break;
                }
                case 302: 
                case 307: {
                    if (Response.header$default$b4243d8(response, "Expires", null, 2) != null || response.cacheControl().maxAgeSeconds() != -1 || response.cacheControl().isPublic() || response.cacheControl().isPrivate()) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            return !response2.cacheControl().noStore() && !var1_1.cacheControl().noStore();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Factory {
        private final long nowMillis;
        private final Request request;
        private final Response cacheResponse;
        private Date servedDate;
        private String servedDateString;
        private Date lastModified;
        private String lastModifiedString;
        private Date expires;
        private long sentRequestMillis;
        private long receivedResponseMillis;
        private String etag;
        private int ageSeconds;

        /*
         * WARNING - void declaration
         */
        public Factory(long nowMillis, Request request, Response cacheResponse) {
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.nowMillis = nowMillis;
            this.request = var3_3;
            this.cacheResponse = cacheResponse;
            this.ageSeconds = -1;
            if (this.cacheResponse != null) {
                this.sentRequestMillis = this.cacheResponse.sentRequestAtMillis();
                this.receivedResponseMillis = this.cacheResponse.receivedResponseAtMillis();
                Headers headers = this.cacheResponse.headers();
                int n = headers.size();
                for (int i = 0; i < n; ++i) {
                    String fieldName = headers.name(i);
                    String value = headers.value(i);
                    if (StringsKt.equals((String)fieldName, (String)"Date", (boolean)true)) {
                        this.servedDate = DatesKt.toHttpDateOrNull(value);
                        this.servedDateString = value;
                        continue;
                    }
                    if (StringsKt.equals((String)fieldName, (String)"Expires", (boolean)true)) {
                        this.expires = DatesKt.toHttpDateOrNull(value);
                        continue;
                    }
                    if (StringsKt.equals((String)fieldName, (String)"Last-Modified", (boolean)true)) {
                        this.lastModified = DatesKt.toHttpDateOrNull(value);
                        this.lastModifiedString = value;
                        continue;
                    }
                    if (StringsKt.equals((String)fieldName, (String)"ETag", (boolean)true)) {
                        this.etag = value;
                        continue;
                    }
                    if (!StringsKt.equals((String)fieldName, (String)"Age", (boolean)true)) continue;
                    this.ageSeconds = Util.toNonNegativeInt(value, -1);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        public final CacheStrategy compute() {
            block16: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block15: {
                                            var1_1 = this;
                                            if (var1_1.cacheResponse != null) break block15;
                                            v0 = new CacheStrategy(var1_1.request, null);
                                            break block16;
                                        }
                                        if (!var1_1.request.isHttps() || var1_1.cacheResponse.handshake() != null) break block17;
                                        v0 = new CacheStrategy(var1_1.request, null);
                                        break block16;
                                    }
                                    if (okhttp3.internal.cache.CacheStrategy$Companion.isCacheable(var1_1.cacheResponse, var1_1.request)) break block18;
                                    v0 = new CacheStrategy(var1_1.request, null);
                                    break block16;
                                }
                                var2_2 = var1_1.request.cacheControl();
                                if (!var2_2.noCache() && !((var4_3 = var1_1.request).header("If-Modified-Since") != null || var4_3.header("If-None-Match") != null)) break block19;
                                v0 = new CacheStrategy(var1_1.request, null);
                                break block16;
                            }
                            var3_4 = var1_1.cacheResponse.cacheControl();
                            var4_3 = var1_1;
                            var7_5 = var4_3.servedDate;
                            var19_7 = var7_5 != null ? Math.max(0L, var4_3.receivedResponseMillis - var7_5.getTime()) : 0L;
                            var21_9 = var4_3.ageSeconds != -1 ? Math.max(var19_7, TimeUnit.SECONDS.toMillis(var4_3.ageSeconds)) : var19_7;
                            var23_10 = var4_3.receivedResponseMillis - var4_3.sentRequestMillis;
                            var25_11 = var4_3.nowMillis - var4_3.receivedResponseMillis;
                            var5_12 = var21_9 + var23_10 + var25_11;
                            var4_3 = var1_1;
                            v1 = var4_3.cacheResponse;
                            Intrinsics.checkNotNull((Object)v1);
                            var7_5 = v1.cacheControl();
                            if (var7_5.maxAgeSeconds() != -1) {
                                v2 = TimeUnit.SECONDS.toMillis(var7_5.maxAgeSeconds());
                            } else {
                                var19_8 = var4_3.expires;
                                if (var19_8 != null) {
                                    v3 = var4_3.servedDate;
                                    var20_13 = v3 != null ? v3.getTime() : var4_3.receivedResponseMillis;
                                    var22_14 = var19_8.getTime() - var20_13;
                                    v2 = var22_14 > 0L ? var22_14 : 0L;
                                } else if (var4_3.lastModified != null && var4_3.cacheResponse.request().url().query() == null) {
                                    v4 = var4_3.servedDate;
                                    var20_13 = v4 != null ? v4.getTime() : var4_3.sentRequestMillis;
                                    v5 = var4_3.lastModified;
                                    Intrinsics.checkNotNull((Object)v5);
                                    var22_14 = var20_13 - v5.getTime();
                                    v2 = var22_14 > 0L ? var22_14 / 10L : 0L;
                                } else {
                                    v2 = var7_6 = 0L;
                                }
                            }
                            if (var2_2.maxAgeSeconds() != -1) {
                                var7_6 = Math.min(var7_6, TimeUnit.SECONDS.toMillis(var2_2.maxAgeSeconds()));
                            }
                            var9_15 = 0L;
                            if (var2_2.minFreshSeconds() != -1) {
                                var9_15 = TimeUnit.SECONDS.toMillis(var2_2.minFreshSeconds());
                            }
                            var11_16 = 0L;
                            if (!var3_4.mustRevalidate() && var2_2.maxStaleSeconds() != -1) {
                                var11_16 = TimeUnit.SECONDS.toMillis(var2_2.maxStaleSeconds());
                            }
                            if (var3_4.noCache() || var5_12 + var9_15 >= var7_6 + var11_16) break block20;
                            var2_2 = var1_1.cacheResponse.newBuilder();
                            if (var5_12 + var9_15 >= var7_6) {
                                var2_2.addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
                            }
                            if (var5_12 > 86400000L) {
                                var4_3 = var1_1;
                                v6 = var4_3.cacheResponse;
                                Intrinsics.checkNotNull((Object)v6);
                                if (v6.cacheControl().maxAgeSeconds() == -1 && var4_3.expires == null) {
                                    var2_2.addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
                                }
                            }
                            v0 = new CacheStrategy(null, var2_2.build());
                            break block16;
                        }
                        if (var1_1.etag == null) break block21;
                        var2_2 = "If-None-Match";
                        var3_4 = var1_1.etag;
                        ** GOTO lbl88
                    }
                    if (var1_1.lastModified == null) break block22;
                    var2_2 = "If-Modified-Since";
                    var3_4 = var1_1.lastModifiedString;
                    ** GOTO lbl88
                }
                if (var1_1.servedDate == null) {
                    v0 = new CacheStrategy(var1_1.request, null);
                } else {
                    var2_2 = "If-Modified-Since";
                    var3_4 = var1_1.servedDateString;
lbl88:
                    // 3 sources

                    var4_3 = var1_1.request.headers().newBuilder();
                    v7 = var3_4;
                    Intrinsics.checkNotNull((Object)v7);
                    var4_3.addLenient$okhttp((String)var2_2, (String)v7);
                    var2_2 = var1_1.request.newBuilder().headers(var4_3.build()).build();
                    v0 = candidate = new CacheStrategy((Request)var2_2, var1_1.cacheResponse);
                }
            }
            if (v0.getNetworkRequest() != null && this.request.cacheControl().onlyIfCached()) {
                return new CacheStrategy(null, null);
            }
            return var1_1;
        }
    }
}

