/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000b"}, d2={"Lokhttp3/internal/cache/CacheInterceptor;", "Lokhttp3/Interceptor;", "Lokhttp3/Cache;", "cache", "<init>", "(Lokhttp3/Cache;)V", "Lokhttp3/Interceptor$Chain;", "chain", "Lokhttp3/Response;", "intercept", "(Lokhttp3/Interceptor$Chain;)Lokhttp3/Response;", "Lokhttp3/Cache;", "Companion"})
public final class CacheInterceptor
implements Interceptor {
    public static final Companion Companion = new Companion(null);
    public final Cache cache;

    /*
     * WARNING - void declaration
     */
    public CacheInterceptor(Cache cache) {
        void var1_1;
        this.cache = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Response intercept(Interceptor.Chain chain) throws IOException {
        Object object;
        Response response;
        Object response2;
        Response networkResponse;
        Response cacheResponse;
        Request networkRequest;
        Call call;
        block26: {
            ResponseBody responseBody;
            Response it2;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            call = chain.call();
            Cache cache = this.cache;
            Response cacheCandidate = cache != null ? cache.get$okhttp(chain.request()) : null;
            long now = System.currentTimeMillis();
            CacheStrategy strategy = new CacheStrategy.Factory(now, chain.request(), cacheCandidate).compute();
            networkRequest = strategy.getNetworkRequest();
            cacheResponse = strategy.getCacheResponse();
            Cache cache2 = this.cache;
            if (cache2 != null) {
                cache2.trackResponse$okhttp(strategy);
            }
            if ((object2 = call instanceof RealCall ? (RealCall)call : null) == null || (object2 = ((RealCall)object2).getEventListener$okhttp()) == null) {
                object2 = EventListener.NONE;
            }
            if (cacheCandidate != null && cacheResponse == null) {
                ResponseBody responseBody2 = cacheCandidate.body();
                if (responseBody2 != null) {
                    Util.closeQuietly(responseBody2);
                }
            }
            if (networkRequest == null && cacheResponse == null) {
                chain = new Response.Builder().request(chain.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
                it2 = chain;
                EventListener.satisfactionFailure(call, it2);
                return chain;
            }
            if (networkRequest == null) {
                Response response3 = cacheResponse;
                Intrinsics.checkNotNull((Object)response3);
                chain = response3.newBuilder().cacheResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, cacheResponse)).build();
                it2 = chain;
                EventListener.cacheHit(call, it2);
                return chain;
            }
            if (cacheResponse != null) {
                EventListener.cacheConditionalHit(call, cacheResponse);
            } else if (this.cache != null) {
                EventListener.cacheMiss(call);
            }
            try {
                networkResponse = chain.proceed(networkRequest);
                if (networkResponse != null || cacheCandidate == null) break block26;
                responseBody = cacheCandidate.body();
            }
            catch (Throwable it2) {
                if (cacheCandidate != null) {
                    ResponseBody responseBody3 = cacheCandidate.body();
                    if (responseBody3 != null) {
                        Util.closeQuietly(responseBody3);
                    }
                }
                throw it2;
            }
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
        }
        if (cacheResponse != null) {
            Response response4 = networkResponse;
            boolean bl = response4 != null ? response4.code() == 304 : false;
            if (bl) {
                response2 = cacheResponse.newBuilder().headers(okhttp3.internal.cache.CacheInterceptor$Companion.access$combine(Companion, cacheResponse.headers(), networkResponse.headers())).sentRequestAtMillis(networkResponse.sentRequestAtMillis()).receivedResponseAtMillis(networkResponse.receivedResponseAtMillis()).cacheResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, cacheResponse)).networkResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, networkResponse)).build();
                ResponseBody responseBody = networkResponse.body();
                Intrinsics.checkNotNull((Object)responseBody);
                responseBody.close();
                Cache cache = this.cache;
                Intrinsics.checkNotNull((Object)cache);
                cache.trackConditionalCacheHit$okhttp();
                this.cache.update$okhttp(cacheResponse, (Response)response2);
                Response it = networkResponse = response2;
                EventListener.cacheHit(call, response);
                return networkResponse;
            }
            ResponseBody responseBody = cacheResponse.body();
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
        }
        Response response5 = networkResponse;
        Intrinsics.checkNotNull((Object)response5);
        response2 = response5.newBuilder().cacheResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, cacheResponse)).networkResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, (Response)object)).build();
        if (this.cache != null) {
            if (HttpHeaders.promisesBody((Response)response2)) {
                if (CacheStrategy.Companion.isCacheable((Response)response2, networkRequest)) {
                    Response response6;
                    CacheRequest cacheRequest = this.cache.put$okhttp((Response)response2);
                    object = cacheRequest;
                    response = response2;
                    object = cacheRequest;
                    if (cacheRequest == null) {
                        response6 = response;
                    } else {
                        response2 = object.body();
                        ResponseBody responseBody = response.body();
                        Intrinsics.checkNotNull((Object)responseBody);
                        networkRequest = responseBody.source();
                        response2 = Okio.buffer((Sink)response2);
                        object = new Source((BufferedSource)networkRequest, (CacheRequest)object, (BufferedSink)response2){
                            private boolean cacheRequestClosed;
                            final /* synthetic */ BufferedSource $source;
                            final /* synthetic */ CacheRequest $cacheRequest;
                            final /* synthetic */ BufferedSink $cacheBody;
                            {
                                void var3_3;
                                void var2_2;
                                void var1_1;
                                this.$source = var1_1;
                                this.$cacheRequest = var2_2;
                                this.$cacheBody = var3_3;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final long read(Buffer sink, long byteCount) throws IOException {
                                void var1_1;
                                long bytesRead;
                                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                                try {
                                    void var2_3;
                                    bytesRead = this.$source.read(sink, (long)var2_3);
                                }
                                catch (IOException e) {
                                    void var1_2;
                                    if (!this.cacheRequestClosed) {
                                        this.cacheRequestClosed = true;
                                        this.$cacheRequest.abort();
                                    }
                                    throw var1_2;
                                }
                                if (bytesRead == -1L) {
                                    if (!this.cacheRequestClosed) {
                                        this.cacheRequestClosed = true;
                                        this.$cacheBody.close();
                                    }
                                    return -1L;
                                }
                                var1_1.copyTo(this.$cacheBody.getBuffer(), var1_1.size() - bytesRead, bytesRead);
                                this.$cacheBody.emitCompleteSegments();
                                return bytesRead;
                            }

                            public final Timeout timeout() {
                                return this.$source.timeout();
                            }

                            public final void close() throws IOException {
                                if (!this.cacheRequestClosed && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                                    this.cacheRequestClosed = true;
                                    this.$cacheRequest.abort();
                                }
                                this.$source.close();
                            }
                        };
                        response2 = Response.header$default$b4243d8(response, "Content-Type", null, 2);
                        long l = response.body().contentLength();
                        response6 = response = response.newBuilder().body(new RealResponseBody((String)response2, l, Okio.buffer((Source)((Source)object)))).build();
                    }
                    if (cacheResponse != null) {
                        void var2_2;
                        EventListener.cacheMiss((Call)var2_2);
                    }
                    return response;
                }
            }
            if (HttpMethod.invalidatesCache(networkRequest.method())) {
                try {
                    this.cache.remove$okhttp(networkRequest);
                }
                catch (IOException iOException) {}
            }
        }
        return response2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\b"}, d2={"Lokhttp3/internal/cache/CacheInterceptor$Companion;", "", "<init>", "()V", "", "fieldName", "", "isContentSpecificHeader", "(Ljava/lang/String;)Z", "isEndToEnd"})
    public static final class Companion {
        private Companion() {
        }

        private static boolean isEndToEnd(String fieldName) {
            String string;
            return !StringsKt.equals((String)"Connection", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Keep-Alive", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authenticate", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authorization", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"TE", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Trailers", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Transfer-Encoding", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Upgrade", (String)string, (boolean)true);
        }

        private static boolean isContentSpecificHeader(String fieldName) {
            String string;
            return StringsKt.equals((String)"Content-Length", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Encoding", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Type", (String)string, (boolean)true);
        }

        public static final /* synthetic */ Response access$stripBody(Companion $this, Response response) {
            Response response2 = response;
            if ((response2 != null ? response2.body() : null) != null) {
                return response2.newBuilder().body(null).build();
            }
            return response2;
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ Headers access$combine(Companion $this, Headers cachedHeaders, Headers networkHeaders) {
            void var2_2;
            String string;
            int n;
            void var1_1;
            Object object = $this;
            object = new Headers.Builder();
            int n2 = var1_1.size();
            for (n = 0; n < n2; ++n) {
                string = var1_1.name(n);
                String string2 = var1_1.value(n);
                if (StringsKt.equals((String)"Warning", (String)string, (boolean)true) && StringsKt.startsWith$default((String)string2, (String)"1", (boolean)false, (int)2, null) || !okhttp3.internal.cache.CacheInterceptor$Companion.isContentSpecificHeader(string) && okhttp3.internal.cache.CacheInterceptor$Companion.isEndToEnd(string) && var2_2.get(string) != null) continue;
                ((Headers.Builder)object).addLenient$okhttp(string, string2);
            }
            n2 = var2_2.size();
            for (n = 0; n < n2; ++n) {
                string = var2_2.name(n);
                if (okhttp3.internal.cache.CacheInterceptor$Companion.isContentSpecificHeader(string) || !okhttp3.internal.cache.CacheInterceptor$Companion.isEndToEnd(string)) continue;
                ((Headers.Builder)object).addLenient$okhttp(string, var2_2.value(n));
            }
            return ((Headers.Builder)object).build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

