/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http2.Header;
import okhttp3.internal.io.FileSystem;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Sink;
import okio.Source;

@JvmName(name="Util")
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\nokhttp3/internal/Util\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,636:1\n37#2,2:637\n1627#3,6:639\n1#4:645\n1549#5:646\n1620#5,3:647\n*S KotlinDebug\n*F\n+ 1 Util.kt\nokhttp3/internal/Util\n*L\n127#1:637,2\n167#1:639,6\n300#1:646\n300#1:647,3\n*E\n"})
public final class Util {
    @JvmField
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @JvmField
    public static final Headers EMPTY_HEADERS = Headers.Companion.of(new String[0]);
    @JvmField
    public static final ResponseBody EMPTY_RESPONSE = ResponseBody.Companion.create$default$5dbfdd3a(ResponseBody.Companion, EMPTY_BYTE_ARRAY, null, 1);
    @JvmField
    public static final RequestBody EMPTY_REQUEST = RequestBody.Companion.create$default$62b140a(RequestBody.Companion, EMPTY_BYTE_ARRAY, null, 0, 0, 7);
    private static final Options UNICODE_BOMS;
    @JvmField
    public static final TimeZone UTC;
    private static final Regex VERIFY_AS_IP_ADDRESS;
    @JvmField
    public static final boolean assertionsEnabled;
    @JvmField
    public static final String okHttpName;

    /*
     * WARNING - void declaration
     */
    public static final void checkOffsetAndCount(long arrayLength, long offset, long count) {
        void var2_2;
        long l;
        if ((offset | count) < 0L || offset > arrayLength || l - var2_2 < count) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final ThreadFactory threadFactory(String name, boolean daemon) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return arg_0 -> Util.threadFactory$lambda$1(string, (boolean)var1_1, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    public static final String[] intersect(String[] $this$intersect, String[] other, Comparator<? super String> comparator) {
        void var3_3;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)$this$intersect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        List result = new ArrayList();
        block0: for (String a : $this$intersect) {
            for (String b : other) {
                if (comparator.compare(a, b) != 0) continue;
                result.add(a);
                continue block0;
            }
        }
        Collection collection2 = collection = (Collection)var3_3;
        return collection.toArray(new String[0]);
    }

    public static final boolean hasIntersection(String[] $this$hasIntersection, String[] other, Comparator<? super String> comparator) {
        Intrinsics.checkNotNullParameter((Object)$this$hasIntersection, (String)"<this>");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        if ($this$hasIntersection.length == 0 || other == null || other.length == 0) {
            return false;
        }
        for (String a : $this$hasIntersection) {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])other);
            while (iterator.hasNext()) {
                String b = (String)iterator.next();
                if (comparator.compare(a, b) != 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final String toHostHeader(HttpUrl $this$toHostHeader, boolean includeDefaultPort) {
        void var2_2;
        block3: {
            HttpUrl httpUrl;
            String host;
            block2: {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)$this$toHostHeader, (String)"<this>");
                String string = host = StringsKt.contains$default((CharSequence)$this$toHostHeader.host(), (CharSequence)":", (boolean)false, (int)2, null) ? "[" + $this$toHostHeader.host() + ']' : $this$toHostHeader.host();
                if (var1_1 != false) break block2;
                if ($this$toHostHeader.port() == HttpUrl.Companion.defaultPort($this$toHostHeader.scheme())) break block3;
            }
            return host + ':' + httpUrl.port();
        }
        return var2_2;
    }

    public static /* synthetic */ String toHostHeader$default$11ec9d50(HttpUrl httpUrl, boolean bl, int n) {
        return Util.toHostHeader(httpUrl, false);
    }

    public static final int indexOf(String[] $this$indexOf, String value, Comparator<String> comparator) {
        String[] $this$indexOfFirst$iv;
        Intrinsics.checkNotNullParameter((Object)$this$indexOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        int n = $this$indexOfFirst$iv.length;
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            String it = $this$indexOfFirst$iv[index$iv];
            if (!(comparator.compare(it, value) == 0)) continue;
            return index$iv;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static final String[] concat(String[] $this$concat, String value) {
        String[] stringArray;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String[] stringArray2 = Arrays.copyOf($this$concat, $this$concat.length + 1);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"copyOf(this, newSize)");
        String[] result = stringArray2;
        stringArray2[ArraysKt.getLastIndex((Object[])result)] = var1_1;
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    private static int indexOfFirstNonAsciiWhitespace(String $this$indexOfFirstNonAsciiWhitespace, int startIndex, int endIndex) {
        void var2_2;
        void i;
        Intrinsics.checkNotNullParameter((Object)$this$indexOfFirstNonAsciiWhitespace, (String)"<this>");
        while (i < endIndex) {
            char c = $this$indexOfFirstNonAsciiWhitespace.charAt((int)i);
            if (!((((c == '\t' ? true : c == '\n') ? true : c == '\f') ? true : c == '\r') ? true : c == ' ')) {
                return (int)i;
            }
            ++i;
        }
        return (int)var2_2;
    }

    public static /* synthetic */ int indexOfFirstNonAsciiWhitespace$default$4abc9f13(String string, int n, int n2, int n3) {
        n2 = string.length();
        return Util.indexOfFirstNonAsciiWhitespace(string, 0, n2);
    }

    /*
     * WARNING - void declaration
     */
    private static int indexOfLastNonAsciiWhitespace(String $this$indexOfLastNonAsciiWhitespace, int startIndex, int endIndex) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$indexOfLastNonAsciiWhitespace, (String)"<this>");
        int i = endIndex - 1;
        if (startIndex <= i) {
            while (true) {
                char c;
                if (!(((((c = $this$indexOfLastNonAsciiWhitespace.charAt(i)) == '\t' ? true : c == '\n') ? true : c == '\f') ? true : c == '\r') ? true : c == ' ')) {
                    return i + 1;
                }
                if (i == startIndex) break;
                --i;
            }
        }
        return (int)var1_1;
    }

    public static /* synthetic */ int indexOfLastNonAsciiWhitespace$default$4abc9f13(String string, int n, int n2, int n3) {
        n2 = string.length();
        return Util.indexOfLastNonAsciiWhitespace(string, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public static final String trimSubstring(String $this$trimSubstring, int startIndex, int endIndex) {
        void var2_2;
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$trimSubstring, (String)"<this>");
        int start = Util.indexOfFirstNonAsciiWhitespace($this$trimSubstring, startIndex, endIndex);
        int end = Util.indexOfLastNonAsciiWhitespace($this$trimSubstring, start, endIndex);
        String string2 = string.substring((int)var1_1, (int)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    public static /* synthetic */ String trimSubstring$default$7bab7980(String string, int n, int n2, int n3) {
        return Util.trimSubstring(string, 0, n2);
    }

    /*
     * WARNING - void declaration
     */
    public static final int delimiterOffset(String $this$delimiterOffset, String delimiters, int startIndex, int endIndex) {
        void var3_3;
        void i;
        Intrinsics.checkNotNullParameter((Object)$this$delimiterOffset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)delimiters, (String)"delimiters");
        while (i < endIndex) {
            if (StringsKt.contains$default((CharSequence)delimiters, (char)$this$delimiterOffset.charAt((int)i), (boolean)false, (int)2, null)) {
                return (int)i;
            }
            ++i;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static final int delimiterOffset(String $this$delimiterOffset, char delimiter, int startIndex, int endIndex) {
        void var3_3;
        void i;
        Intrinsics.checkNotNullParameter((Object)$this$delimiterOffset, (String)"<this>");
        while (i < endIndex) {
            if ($this$delimiterOffset.charAt((int)i) == delimiter) {
                return (int)i;
            }
            ++i;
        }
        return (int)var3_3;
    }

    public static /* synthetic */ int delimiterOffset$default$263f57ec(String string, char c, int n, int n2, int n3) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = string.length();
        }
        return Util.delimiterOffset(string, c, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public static final int indexOfControlOrNonAscii(String $this$indexOfControlOrNonAscii) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOfControlOrNonAscii, (String)"<this>");
        int n = $this$indexOfControlOrNonAscii.length();
        for (int i = 0; i < n; ++i) {
            void var3_3;
            char c = $this$indexOfControlOrNonAscii.charAt(i);
            if (Intrinsics.compare((int)c, (int)31) > 0 && Intrinsics.compare((int)var3_3, (int)127) < 0) continue;
            return i;
        }
        return -1;
    }

    public static final boolean canParseAsIpAddress(String $this$canParseAsIpAddress) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$canParseAsIpAddress, (String)"<this>");
        return VERIFY_AS_IP_ADDRESS.matches((CharSequence)string);
    }

    public static final boolean isSensitiveHeader(String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.equals((String)name, (String)"Authorization", (boolean)true) || StringsKt.equals((String)name, (String)"Cookie", (boolean)true) || StringsKt.equals((String)name, (String)"Proxy-Authorization", (boolean)true) || StringsKt.equals((String)string, (String)"Set-Cookie", (boolean)true);
    }

    public static final String format(String format, Object ... args) {
        String string;
        T[] TArray;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Locale locale = Locale.US;
        void v0 = TArray;
        TArray = Arrays.copyOf(v0, ((void)v0).length);
        String string2 = String.format(locale, string, (Object[])Arrays.copyOf(TArray, TArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static final int checkDuration(String name, long duration, TimeUnit unit) {
        void var1_1;
        void var3_2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!(duration >= 0L)) {
            String string = name + " < 0";
            throw new IllegalStateException(string.toString());
        }
        if (!(unit != null)) {
            String string = "unit == null";
            throw new IllegalStateException(string.toString());
        }
        long millis = var3_2.toMillis(duration);
        if (!(millis <= Integer.MAX_VALUE)) {
            name = name + " too large.";
            throw new IllegalArgumentException(name.toString());
        }
        if (!(millis != 0L || var1_1 <= 0L)) {
            String string;
            string = string + " too small.";
            throw new IllegalArgumentException(string.toString());
        }
        return (int)millis;
    }

    public static final int parseHexDigit(char $this$parseHexDigit) {
        char c = $this$parseHexDigit;
        boolean bl = '0' <= c ? c < ':' : false;
        if (bl) {
            return $this$parseHexDigit - 48;
        }
        boolean bl2 = 'a' <= c ? c < 'g' : false;
        if (bl2) {
            return $this$parseHexDigit - 97 + 10;
        }
        boolean bl3 = 'A' <= c ? c < 'G' : false;
        if (bl3) {
            char c2;
            return c2 - 65 + 10;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static final Headers toHeaders(List<Header> $this$toHeaders) {
        void var1_1;
        Iterator<Header> iterator;
        Intrinsics.checkNotNullParameter($this$toHeaders, (String)"<this>");
        Headers.Builder builder = new Headers.Builder();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Header header = (Header)iterator.next();
            ByteString name = header.component1();
            ByteString value = header.value;
            builder.addLenient$okhttp(var3_3.utf8(), header.utf8());
        }
        return var1_1.build();
    }

    /*
     * WARNING - void declaration
     */
    public static final List<Header> toHeaderList(Headers $this$toHeaderList) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$toHeaderList, (String)"<this>");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$toHeaderList.size());
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            int item$iv$iv = ((IntIterator)object).nextInt();
            Collection collection = destination$iv$iv;
            collection.add(new Header($this$toHeaderList.name(item$iv$iv), $this$toHeaderList.value((int)var3_3)));
        }
        return (List)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean canReuseConnectionFor(HttpUrl $this$canReuseConnectionFor, HttpUrl other) {
        void var1_1;
        HttpUrl httpUrl;
        Intrinsics.checkNotNullParameter((Object)$this$canReuseConnectionFor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)$this$canReuseConnectionFor.host(), (Object)other.host()) && $this$canReuseConnectionFor.port() == other.port() && Intrinsics.areEqual((Object)httpUrl.scheme(), (Object)var1_1.scheme());
    }

    public static final EventListener.Factory asFactory(EventListener $this$asFactory) {
        EventListener eventListener;
        Intrinsics.checkNotNullParameter((Object)$this$asFactory, (String)"<this>");
        return arg_0 -> Util.asFactory$lambda$8(eventListener, arg_0);
    }

    public static final int and(byte $this$and, int mask) {
        return $this$and & 0xFF;
    }

    public static final int and(short $this$and, int mask) {
        return $this$and & 0xFFFF;
    }

    public static final long and(int $this$and, long mask) {
        return (long)$this$and & Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeMedium(BufferedSink $this$writeMedium, int medium) throws IOException {
        void var1_1;
        BufferedSink bufferedSink;
        Intrinsics.checkNotNullParameter((Object)$this$writeMedium, (String)"<this>");
        $this$writeMedium.writeByte(medium >>> 16 & 0xFF);
        $this$writeMedium.writeByte(medium >>> 8 & 0xFF);
        bufferedSink.writeByte(var1_1 & 0xFF);
    }

    public static final int readMedium(BufferedSource $this$readMedium) throws IOException {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)$this$readMedium, (String)"<this>");
        byte by = $this$readMedium.readByte();
        int n = 255;
        n = by;
        byte by2 = $this$readMedium.readByte();
        n = 255;
        n = by2;
        byte by3 = bufferedSource.readByte();
        n = 255;
        n = by3;
        return (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean skipAll(Source $this$skipAll, int duration, TimeUnit timeUnit) throws IOException {
        boolean bl;
        block9: {
            long originalDurationNs;
            long nowNs;
            block8: {
                void var2_4;
                Intrinsics.checkNotNullParameter((Object)$this$skipAll, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
                nowNs = System.nanoTime();
                originalDurationNs = $this$skipAll.timeout().hasDeadline() ? $this$skipAll.timeout().deadlineNanoTime() - nowNs : Long.MAX_VALUE;
                $this$skipAll.timeout().deadlineNanoTime(nowNs + Math.min(originalDurationNs, var2_4.toNanos(duration)));
                try {
                    Buffer skipBuffer = new Buffer();
                    while ($this$skipAll.read(skipBuffer, 8192L) != -1L) {
                        skipBuffer.clear();
                    }
                    bl = true;
                    if (originalDurationNs != Long.MAX_VALUE) break block8;
                }
                catch (InterruptedIOException interruptedIOException) {
                    bl = false;
                    if (originalDurationNs == Long.MAX_VALUE) {
                        $this$skipAll.timeout().clearDeadline();
                    } else {
                        $this$skipAll.timeout().deadlineNanoTime(nowNs + originalDurationNs);
                    }
                }
                catch (Throwable throwable) {
                    if (originalDurationNs == Long.MAX_VALUE) {
                        $this$skipAll.timeout().clearDeadline();
                    } else {
                        void var3_5;
                        Source source;
                        source.timeout().deadlineNanoTime((long)(var3_5 + originalDurationNs));
                    }
                    throw throwable;
                }
                $this$skipAll.timeout().clearDeadline();
                break block9;
            }
            $this$skipAll.timeout().deadlineNanoTime(nowNs + originalDurationNs);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean discard(Source $this$discard, int timeout2, TimeUnit timeUnit) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$discard, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        try {
            void var2_3;
            Source source;
            bl = Util.skipAll(source, 100, (TimeUnit)var2_3);
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isHealthy(Socket $this$isHealthy, BufferedSource source) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$isHealthy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            int n2;
            int readTimeout = $this$isHealthy.getSoTimeout();
            try {
                void var1_1;
                $this$isHealthy.setSoTimeout(1);
                n2 = !var1_1.exhausted() ? 1 : 0;
            }
            catch (Throwable throwable) {
                Socket socket;
                socket.setSoTimeout(n);
                throw throwable;
            }
            $this$isHealthy.setSoTimeout(readTimeout);
            n = n2;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            n = 1;
        }
        catch (IOException iOException) {
            n = 0;
        }
        return n != 0;
    }

    /*
     * WARNING - void declaration
     */
    public static final int skipAll(Buffer $this$skipAll, byte b) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$skipAll, (String)"<this>");
        int count = 0;
        while (!$this$skipAll.exhausted() && $this$skipAll.getByte(0L) == 61) {
            ++count;
            $this$skipAll.readByte();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final int indexOfNonWhitespace(String $this$indexOfNonWhitespace, int startIndex) {
        String string;
        void i;
        Intrinsics.checkNotNullParameter((Object)$this$indexOfNonWhitespace, (String)"<this>");
        int n = $this$indexOfNonWhitespace.length();
        while (i < n) {
            void var3_3;
            char c = $this$indexOfNonWhitespace.charAt((int)i);
            if (c != ' ' && var3_3 != 9) {
                return (int)i;
            }
            ++i;
        }
        return string.length();
    }

    public static final long headersContentLength(Response $this$headersContentLength) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)$this$headersContentLength, (String)"<this>");
        String string = response.headers().get("Content-Length");
        if (string != null) {
            return Util.toLongOrDefault(string, -1L);
        }
        return -1L;
    }

    public static final long toLongOrDefault(String $this$toLongOrDefault, long defaultValue) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$toLongOrDefault, (String)"<this>");
        try {
            String string;
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l = -1L;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public static final int toNonNegativeInt(String $this$toNonNegativeInt, int defaultValue) {
        try {
            void var2_2;
            String string = $this$toNonNegativeInt;
            if (string == null) {
                return defaultValue;
            }
            long value = Long.parseLong(string);
            if (value > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (value < 0L) {
                return 0;
            }
            return (int)var2_2;
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            return (int)var1_1;
        }
    }

    public static final <T> List<T> toImmutableList(List<? extends T> $this$toImmutableList) {
        List<? extends T> list;
        Intrinsics.checkNotNullParameter($this$toImmutableList, (String)"<this>");
        List list2 = Collections.unmodifiableList(CollectionsKt.toMutableList((Collection)list));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"unmodifiableList(toMutableList())");
        return list2;
    }

    @SafeVarargs
    public static final <T> List<T> immutableListOf(T ... elements) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        objectArray = (Object[])objectArray.clone();
        List list = Collections.unmodifiableList(CollectionsKt.listOf((Object[])Arrays.copyOf(objectArray, objectArray.length)));
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(listOf(*elements.clone()))");
        return list;
    }

    public static final <K, V> Map<K, V> toImmutableMap(Map<K, ? extends V> $this$toImmutableMap) {
        Map<K, ? extends V> map;
        Intrinsics.checkNotNullParameter($this$toImmutableMap, (String)"<this>");
        if ($this$toImmutableMap.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map map2 = Collections.unmodifiableMap((Map)new LinkedHashMap<K, V>(map));
        Intrinsics.checkNotNullExpressionValue(map2, (String)"{\n    Collections.unmodi\u2026(LinkedHashMap(this))\n  }");
        return map2;
    }

    public static final void closeQuietly(Closeable $this$closeQuietly) {
        RuntimeException runtimeException;
        Intrinsics.checkNotNullParameter((Object)$this$closeQuietly, (String)"<this>");
        try {
            runtimeException.close();
            return;
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
            throw runtimeException2;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final void closeQuietly(Socket $this$closeQuietly) {
        Intrinsics.checkNotNullParameter((Object)$this$closeQuietly, (String)"<this>");
        try {
            ((Socket)$this$closeQuietly).close();
            return;
        }
        catch (AssertionError assertionError) {
            $this$closeQuietly = assertionError;
            throw assertionError;
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2;
            RuntimeException rethrown = runtimeException;
            if (Intrinsics.areEqual((Object)runtimeException.getMessage(), (Object)"bio == null")) {
                return;
            }
            throw runtimeException2;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static final boolean isCivilized(FileSystem $this$isCivilized2222, File file) {
        void var1_2;
        FileSystem fileSystem;
        Intrinsics.checkNotNullParameter((Object)$this$isCivilized2222, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = (Closeable)$this$isCivilized2222.sink(file);
        Throwable throwable = null;
        Sink cfr_ignored_0 = (Sink)closeable;
        $this$isCivilized2222.delete(file);
        CloseableKt.closeFinally((Closeable)closeable, null);
        return true;
        {
            catch (IOException iOException) {
                try {
                }
                catch (Throwable throwable2) {
                    try {
                        $this$isCivilized2222 = throwable2;
                        throwable = throwable2;
                        throw $this$isCivilized2222;
                    }
                    catch (Throwable $this$isCivilized2222) {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        throw $this$isCivilized2222;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable, null);
            }
        }
        fileSystem.delete((File)var1_2);
        return false;
    }

    public static final String toHexString(long $this$toHexString) {
        String string = Long.toHexString($this$toHexString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(this)");
        return string;
    }

    public static final String toHexString(int $this$toHexString) {
        String string = Integer.toHexString($this$toHexString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(this)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final <E> void addIfAbsent$48b700c2(List<E> $this$addIfAbsent, E element) {
        Intrinsics.checkNotNullParameter($this$addIfAbsent, (String)"<this>");
        if (!$this$addIfAbsent.contains(element)) {
            void var1_1;
            List<void> list;
            list.add(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final Throwable withSuppressed(Exception $this$withSuppressed, List<? extends Exception> suppressed) {
        Iterator iterator;
        Exception exception;
        Intrinsics.checkNotNullParameter((Object)$this$withSuppressed, (String)"<this>");
        Intrinsics.checkNotNullParameter(suppressed, (String)"suppressed");
        Exception $this$withSuppressed_u24lambda_u2410 = exception;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Exception e = (Exception)iterator.next();
            ExceptionsKt.addSuppressed((Throwable)$this$withSuppressed_u24lambda_u2410, (Throwable)((Throwable)var3_3));
        }
        return exception;
    }

    /*
     * WARNING - void declaration
     */
    private static final Thread threadFactory$lambda$1(String $name, boolean $daemon, Runnable runnable2) {
        void var1_1;
        Thread thread;
        Thread thread2;
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        thread = new Thread((Runnable)thread2, (String)((Object)thread));
        thread2 = thread;
        thread.setDaemon((boolean)var1_1);
        return thread;
    }

    /*
     * WARNING - void declaration
     */
    private static final EventListener asFactory$lambda$8(EventListener $this_asFactory, Call it) {
        EventListener eventListener;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this_asFactory, (String)"$this_asFactory");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"it");
        return eventListener;
    }

    static {
        ByteString[] byteStringArray = new ByteString[5];
        ByteString[] byteStringArray2 = byteStringArray;
        byteStringArray[0] = ByteString.Companion.decodeHex("efbbbf");
        byteStringArray2[1] = ByteString.Companion.decodeHex("feff");
        byteStringArray2[2] = ByteString.Companion.decodeHex("fffe");
        byteStringArray2[3] = ByteString.Companion.decodeHex("0000ffff");
        byteStringArray2[4] = ByteString.Companion.decodeHex("ffff0000");
        UNICODE_BOMS = Options.Companion.of(byteStringArray2);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Intrinsics.checkNotNull((Object)timeZone);
        UTC = timeZone;
        VERIFY_AS_IP_ADDRESS = new Regex("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");
        assertionsEnabled = OkHttpClient.class.desiredAssertionStatus();
        String string = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"OkHttpClient::class.java.name");
        okHttpName = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"okhttp3."), (CharSequence)"Client");
    }
}

