/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpMethod;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001:\u0001+BC\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0013J\r\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0019\u0010\t\u001a\u0004\u0018\u00010\b8\u0007\u00a2\u0006\f\n\u0004\b\t\u0010\u0019\u001a\u0004\b\t\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\u001b8G\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001e\u001a\u0004\b\u0007\u0010\u001fR\u0011\u0010!\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0018\u0010#\u001a\u0004\u0018\u00010\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0017\u0010\u0005\u001a\u00020\u00048\u0007\u00a2\u0006\f\n\u0004\b\u0005\u0010%\u001a\u0004\b\u0005\u0010\u0018R*\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\u00010\n8\u0000X\u0081\u0004\u00a2\u0006\f\n\u0004\b\f\u0010&\u001a\u0004\b'\u0010(R\u0017\u0010\u0003\u001a\u00020\u00028\u0007\u00a2\u0006\f\n\u0004\b\u0003\u0010)\u001a\u0004\b\u0003\u0010*"}, d2={"Lokhttp3/Request;", "", "Lokhttp3/HttpUrl;", "url", "", "method", "Lokhttp3/Headers;", "headers", "Lokhttp3/RequestBody;", "body", "", "Ljava/lang/Class;", "tags", "<init>", "(Lokhttp3/HttpUrl;Ljava/lang/String;Lokhttp3/Headers;Lokhttp3/RequestBody;Ljava/util/Map;)V", "name", "header", "(Ljava/lang/String;)Ljava/lang/String;", "", "(Ljava/lang/String;)Ljava/util/List;", "Lokhttp3/Request$Builder;", "newBuilder", "()Lokhttp3/Request$Builder;", "toString", "()Ljava/lang/String;", "Lokhttp3/RequestBody;", "()Lokhttp3/RequestBody;", "Lokhttp3/CacheControl;", "cacheControl", "()Lokhttp3/CacheControl;", "Lokhttp3/Headers;", "()Lokhttp3/Headers;", "", "isHttps", "()Z", "lazyCacheControl", "Lokhttp3/CacheControl;", "Ljava/lang/String;", "Ljava/util/Map;", "getTags$okhttp", "()Ljava/util/Map;", "Lokhttp3/HttpUrl;", "()Lokhttp3/HttpUrl;", "Builder"})
@SourceDebugExtension(value={"SMAP\nRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Request.kt\nokhttp3/Request\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,298:1\n1864#2,3:299\n*S KotlinDebug\n*F\n+ 1 Request.kt\nokhttp3/Request\n*L\n119#1:299,3\n*E\n"})
public final class Request {
    private final HttpUrl url;
    private final String method;
    private final Headers headers;
    private final RequestBody body;
    private final Map<Class<?>, Object> tags;
    private CacheControl lazyCacheControl;

    /*
     * WARNING - void declaration
     */
    public Request(HttpUrl url, String method, Headers headers, RequestBody body, Map<Class<?>, ? extends Object> tags) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.url = var1_1;
        this.method = var2_2;
        this.headers = var3_3;
        this.body = body;
        this.tags = tags;
    }

    @JvmName(name="url")
    public final HttpUrl url() {
        return this.url;
    }

    @JvmName(name="method")
    public final String method() {
        return this.method;
    }

    @JvmName(name="headers")
    public final Headers headers() {
        return this.headers;
    }

    @JvmName(name="body")
    public final RequestBody body() {
        return this.body;
    }

    public final Map<Class<?>, Object> getTags$okhttp() {
        return this.tags;
    }

    public final boolean isHttps() {
        return this.url.isHttps();
    }

    /*
     * WARNING - void declaration
     */
    public final String header(String name) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.headers.get((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final List<String> headers(String name) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.headers.values((String)var1_1);
    }

    public final Builder newBuilder() {
        return new Builder(this);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="cacheControl")
    public final CacheControl cacheControl() {
        void var1_1;
        CacheControl result = this.lazyCacheControl;
        if (result == null) {
            this.lazyCacheControl = result = CacheControl.Companion.parse(this.headers);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        stringBuilder.append("Request{method=");
        $this$toString_u24lambda_u241.append(this.method);
        $this$toString_u24lambda_u241.append(", url=");
        $this$toString_u24lambda_u241.append(this.url);
        if (this.headers.size() != 0) {
            Iterator iterator;
            $this$toString_u24lambda_u241.append(", headers=[");
            Iterable $this$forEachIndexed$iv = this.headers;
            int index$iv = 0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                int n;
                Object item$iv = iterator.next();
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv = (Pair)item$iv;
                int index = n;
                String name = (String)item$iv.component1();
                String value = (String)item$iv.component2();
                if (index > 0) {
                    $this$toString_u24lambda_u241.append(", ");
                }
                $this$toString_u24lambda_u241.append(name);
                $this$toString_u24lambda_u241.append(':');
                $this$toString_u24lambda_u241.append(value);
            }
            $this$toString_u24lambda_u241.append(']');
        }
        if (!this.tags.isEmpty()) {
            $this$toString_u24lambda_u241.append(", tags=");
            $this$toString_u24lambda_u241.append(this.tags);
        }
        var2_2.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u001f\u0010\n\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000e\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000bJ\u0017\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J!\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u001aR\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00138\u0000@\u0000X\u0081\f\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u001bR\u0016\u0010\u0010\u001a\u00020\u001c8\u0000@\u0000X\u0081\f\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u001dR\u0016\u0010\u0012\u001a\u00020\u00078\u0000@\u0000X\u0081\f\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u001eR&\u0010!\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030 \u0012\u0004\u0012\u00020\u00010\u001f8\u0000@\u0000X\u0081\f\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00198\u0000@\u0000X\u0081\f\u00a2\u0006\u0006\n\u0004\b\u0018\u0010#"}, d2={"Lokhttp3/Request$Builder;", "", "<init>", "()V", "Lokhttp3/Request;", "request", "(Lokhttp3/Request;)V", "", "name", "value", "addHeader", "(Ljava/lang/String;Ljava/lang/String;)Lokhttp3/Request$Builder;", "build", "()Lokhttp3/Request;", "header", "Lokhttp3/Headers;", "headers", "(Lokhttp3/Headers;)Lokhttp3/Request$Builder;", "method", "Lokhttp3/RequestBody;", "body", "(Ljava/lang/String;Lokhttp3/RequestBody;)Lokhttp3/Request$Builder;", "removeHeader", "(Ljava/lang/String;)Lokhttp3/Request$Builder;", "url", "Lokhttp3/HttpUrl;", "(Lokhttp3/HttpUrl;)Lokhttp3/Request$Builder;", "Lokhttp3/RequestBody;", "Lokhttp3/Headers$Builder;", "Lokhttp3/Headers$Builder;", "Ljava/lang/String;", "", "Ljava/lang/Class;", "tags", "Ljava/util/Map;", "Lokhttp3/HttpUrl;"})
    @SourceDebugExtension(value={"SMAP\nRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Request.kt\nokhttp3/Request$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n1#2:299\n*E\n"})
    public static class Builder {
        public HttpUrl url;
        public String method;
        public Headers.Builder headers;
        public RequestBody body;
        public Map<Class<?>, Object> tags;

        public Builder() {
            this.tags = new LinkedHashMap();
            this.method = "GET";
            this.headers = new Headers.Builder();
        }

        /*
         * WARNING - void declaration
         */
        public Builder(Request request) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.tags = new LinkedHashMap();
            this.url = request.url();
            this.method = request.method();
            this.body = request.body();
            this.tags = request.getTags$okhttp().isEmpty() ? (Map)new LinkedHashMap() : MapsKt.toMutableMap(request.getTags$okhttp());
            this.headers = var1_1.headers().newBuilder();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder url(HttpUrl url) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Builder builder2 = builder = this;
            builder.url = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder url(String url) {
            void var1_1;
            void finalUrl;
            String string;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            if (StringsKt.startsWith((String)url, (String)"ws:", (boolean)true)) {
                StringBuilder stringBuilder = new StringBuilder("http:");
                String string2 = url.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                string = stringBuilder.append(string2).toString();
            } else if (StringsKt.startsWith((String)url, (String)"wss:", (boolean)true)) {
                StringBuilder stringBuilder = new StringBuilder("https:");
                String string3 = url.substring(4);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                string = stringBuilder.append(string3).toString();
            } else {
                string = finalUrl;
            }
            finalUrl = string;
            return this.url(HttpUrl.Companion.get((String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final Builder header(String name, String value) {
            void var2_2;
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder2 = builder = this;
            builder.headers.set((String)var1_1, (String)var2_2);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addHeader(String name, String value) {
            void var2_2;
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder2 = builder = this;
            builder.headers.add((String)var1_1, (String)var2_2);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder removeHeader(String name) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder builder2 = builder = this;
            builder.headers.removeAll((String)var1_1);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder headers(Headers headers) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder builder2 = builder = this;
            builder.headers = var1_1.newBuilder();
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder method(String method, RequestBody body) {
            void var2_2;
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Builder $this$method_u24lambda_u248 = builder = this;
            if (!(((CharSequence)method).length() > 0)) {
                method = "method.isEmpty() == true";
                throw new IllegalArgumentException(method.toString());
            }
            if (body == null) {
                if (!(!HttpMethod.requiresRequestBody(method))) {
                    method = "method " + method + " must have a request body.";
                    throw new IllegalArgumentException(method.toString());
                }
            } else if (!HttpMethod.permitsRequestBody(method)) {
                method = "method " + method + " must not have a request body.";
                throw new IllegalArgumentException(method.toString());
            }
            $this$method_u24lambda_u248.method = var1_1;
            $this$method_u24lambda_u248.body = var2_2;
            return builder;
        }

        public final Request build() {
            HttpUrl httpUrl = this.url;
            if (httpUrl == null) {
                String string = "url == null";
                throw new IllegalStateException(string.toString());
            }
            Map<Class<?>, Object> map = Util.toImmutableMap(this.tags);
            RequestBody requestBody = this.body;
            Headers headers = this.headers.build();
            String string = this.method;
            HttpUrl httpUrl2 = httpUrl;
            return new Request(httpUrl2, string, headers, requestBody, map);
        }
    }
}

