/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.Util;
import okio.Buffer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 12\u00020\u0001:\u000221Bc\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u0012\u0010\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\t\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u000f\u0010 \u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010#\u001a\u00020!H\u0007\u00a2\u0006\u0004\b\r\u0010\"R\u0011\u0010$\u001a\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001bR\u0011\u0010%\u001a\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001bR\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0013\u0010(\u001a\u0004\u0018\u00010\u00028G\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001bR\u0011\u0010)\u001a\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001bR\u0016\u0010\f\u001a\u0004\u0018\u00010\u00028\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010*R\u001a\u0010\u0006\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010*\u001a\u0004\b\u0006\u0010\u001bR\u001a\u0010+\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b+\u0010-R\u0011\u0010\u0005\u001a\u00020\u00028\u0007\u00a2\u0006\u0006\n\u0004\b\u0005\u0010*R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\t8\u0007\u00a2\u0006\u0006\n\u0004\b\n\u0010.R\u0017\u0010\b\u001a\u00020\u00078\u0007\u00a2\u0006\f\n\u0004\b\b\u0010/\u001a\u0004\b\b\u0010\u0015R\u0013\u00100\u001a\u0004\u0018\u00010\u00028G\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001bR\u001e\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010.R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010*\u001a\u0004\b\u0003\u0010\u001bR\u0014\u0010\r\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010*R\u0014\u0010\u0004\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010*"}, d2={"Lokhttp3/HttpUrl;", "", "", "scheme", "username", "password", "host", "", "port", "", "pathSegments", "queryNamesAndValues", "fragment", "url", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "link", "Lokhttp3/HttpUrl$Builder;", "newBuilder", "(Ljava/lang/String;)Lokhttp3/HttpUrl$Builder;", "redact", "()Ljava/lang/String;", "toString", "Ljava/net/URI;", "uri", "()Ljava/net/URI;", "toUri", "Ljava/net/URL;", "()Ljava/net/URL;", "toUrl", "encodedPassword", "encodedPath", "encodedPathSegments", "()Ljava/util/List;", "encodedQuery", "encodedUsername", "Ljava/lang/String;", "isHttps", "Z", "()Z", "Ljava/util/List;", "I", "query", "Companion", "Builder"})
public final class HttpUrl {
    public static final Companion Companion = new Companion(null);
    private final String scheme;
    public final String username;
    public final String password;
    private final String host;
    private final int port;
    public final List<String> pathSegments;
    private final List<String> queryNamesAndValues;
    public final String fragment;
    private final String url;
    private final boolean isHttps;
    private static final char[] HEX_DIGITS;

    /*
     * WARNING - void declaration
     */
    public HttpUrl(String scheme, String username, String password, String host, int port, List<String> pathSegments, List<String> queryNamesAndValues, String fragment, String url) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.scheme = var1_1;
        this.username = var2_2;
        this.password = var3_3;
        this.host = host;
        this.port = port;
        this.pathSegments = pathSegments;
        this.queryNamesAndValues = queryNamesAndValues;
        this.fragment = fragment;
        this.url = url;
        this.isHttps = Intrinsics.areEqual((Object)this.scheme, (Object)"https");
    }

    @JvmName(name="scheme")
    public final String scheme() {
        return this.scheme;
    }

    @JvmName(name="host")
    public final String host() {
        return this.host;
    }

    @JvmName(name="port")
    public final int port() {
        return this.port;
    }

    public final boolean isHttps() {
        return this.isHttps;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="url")
    public final URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException e) {
            void var1_1;
            throw new RuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="uri")
    public final URI uri() {
        String string;
        Object object = this;
        Object object2 = new Builder();
        ((Builder)object2).setScheme$okhttp(((HttpUrl)object).scheme);
        ((Builder)object2).setEncodedUsername$okhttp(((HttpUrl)object).encodedUsername());
        ((Builder)object2).setEncodedPassword$okhttp(((HttpUrl)object).encodedPassword());
        ((Builder)object2).setHost$okhttp(((HttpUrl)object).host);
        ((Builder)object2).setPort$okhttp(((HttpUrl)object).port != okhttp3.HttpUrl$Companion.defaultPort(((HttpUrl)object).scheme) ? ((HttpUrl)object).port : -1);
        ((Builder)object2).getEncodedPathSegments$okhttp().clear();
        ((Builder)object2).getEncodedPathSegments$okhttp().addAll((Collection<String>)((HttpUrl)object).encodedPathSegments());
        ((Builder)object2).encodedQuery(((HttpUrl)object).encodedQuery());
        if (((HttpUrl)object).fragment == null) {
            string = null;
        } else {
            int n = StringsKt.indexOf$default((CharSequence)((HttpUrl)object).url, (char)'#', (int)0, (boolean)false, (int)6, null) + 1;
            String string2 = ((HttpUrl)object).url.substring(n);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        }
        ((Builder)object2).setEncodedFragment$okhttp(string);
        String uri = ((Builder)object2).reencodeForUri$okhttp().toString();
        try {
            object2 = new URI(uri);
        }
        catch (URISyntaxException e) {
            try {
                object = (CharSequence)object;
                Regex regex = new Regex("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]");
                String string3 = "";
                object = regex.replace((CharSequence)object, string3);
                object = URI.create((String)object);
            }
            catch (Exception exception) {
                void var2_3;
                throw new RuntimeException((Throwable)var2_3);
            }
            Object object3 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"{\n      // Unlikely edge\u2026Unexpected!\n      }\n    }");
            object2 = object3;
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="encodedUsername")
    public final String encodedUsername() {
        void var2_2;
        void var1_1;
        if (((CharSequence)this.username).length() == 0) {
            return "";
        }
        int usernameStart = this.scheme.length() + 3;
        int usernameEnd = Util.delimiterOffset(this.url, ":@", usernameStart, this.url.length());
        String string = this.url.substring((int)var1_1, (int)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="encodedPassword")
    public final String encodedPassword() {
        void var2_2;
        void var1_1;
        if (((CharSequence)this.password).length() == 0) {
            return "";
        }
        int passwordStart = StringsKt.indexOf$default((CharSequence)this.url, (char)':', (int)(this.scheme.length() + 3), (boolean)false, (int)4, null) + 1;
        int passwordEnd = StringsKt.indexOf$default((CharSequence)this.url, (char)'@', (int)0, (boolean)false, (int)6, null);
        String string = this.url.substring((int)var1_1, (int)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="encodedPath")
    public final String encodedPath() {
        void var2_2;
        void var1_1;
        int pathStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'/', (int)(this.scheme.length() + 3), (boolean)false, (int)4, null);
        int pathEnd = Util.delimiterOffset(this.url, "?#", pathStart, this.url.length());
        String string = this.url.substring((int)var1_1, (int)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="encodedPathSegments")
    public final List<String> encodedPathSegments() {
        void var3_3;
        int i;
        int pathStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'/', (int)(this.scheme.length() + 3), (boolean)false, (int)4, null);
        int pathEnd = Util.delimiterOffset(this.url, "?#", pathStart, this.url.length());
        List result = new ArrayList();
        while (i < pathEnd) {
            int segmentEnd = Util.delimiterOffset(this.url, '/', ++i, pathEnd);
            String string = this.url.substring(i, segmentEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            result.add(string);
            i = segmentEnd;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="encodedQuery")
    public final String encodedQuery() {
        void var2_2;
        void var1_1;
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int queryStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'?', (int)0, (boolean)false, (int)6, null) + 1;
        int queryEnd = Util.delimiterOffset(this.url, '#', queryStart, this.url.length());
        String string = this.url.substring((int)var1_1, (int)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="query")
    public final String query() {
        void var1_1;
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        okhttp3.HttpUrl$Companion.toQueryString$okhttp(this.queryNamesAndValues, result);
        return var1_1.toString();
    }

    public final String redact() {
        Builder builder = this.newBuilder("/...");
        Intrinsics.checkNotNull((Object)builder);
        return builder.username("").password("").build().toString();
    }

    public final Builder newBuilder(String link) {
        Builder builder;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        try {
            builder = new Builder().parse$okhttp(this, (String)((Object)builder));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            builder = null;
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof HttpUrl && Intrinsics.areEqual((Object)((HttpUrl)var1_1).url, (Object)this.url);
    }

    public final int hashCode() {
        return this.url.hashCode();
    }

    public final String toString() {
        return this.url;
    }

    static {
        char[] cArray = new char[16];
        char[] cArray2 = cArray;
        cArray[0] = 48;
        cArray2[1] = 49;
        cArray2[2] = 50;
        cArray2[3] = 51;
        cArray2[4] = 52;
        cArray2[5] = 53;
        cArray2[6] = 54;
        cArray2[7] = 55;
        cArray2[8] = 56;
        cArray2[9] = 57;
        cArray2[10] = 65;
        cArray2[11] = 66;
        cArray2[12] = 67;
        cArray2[13] = 68;
        cArray2[14] = 69;
        cArray2[15] = 70;
        HEX_DIGITS = cArray2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010!\n\u0002\b\r\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\fJ!\u0010\u0012\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\n\u00a2\u0006\u0004\b\u0013\u0010\fJ\u0015\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0018\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\n\u00a2\u0006\u0004\b\u0019\u0010\fJ\u000f\u0010\u001a\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\n\u00a2\u0006\u0004\b\u001c\u0010\fR\u001e\u0010\u001d\u001a\u0004\u0018\u00010\n8\u0000@\u0000X\u0080\u000e\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u00020\n8\u0000@\u0000X\u0080\u000e\u00a2\u0006\f\n\u0004\b!\u0010\u001e\"\u0004\b\"\u0010 R \u0010$\u001a\b\u0012\u0004\u0012\u00020\n0#8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R \u0010(\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010#8\u0000@\u0000X\u0080\f\u00a2\u0006\u0006\n\u0004\b(\u0010%R\u001c\u0010)\u001a\u00020\n8\u0000@\u0000X\u0080\u000e\u00a2\u0006\f\n\u0004\b)\u0010\u001e\"\u0004\b*\u0010 R\u001e\u0010\r\u001a\u0004\u0018\u00010\n8\u0000@\u0000X\u0080\u000e\u00a2\u0006\f\n\u0004\b\r\u0010\u001e\"\u0004\b+\u0010 R\u001c\u0010\u0014\u001a\u00020\u00078\u0000@\u0000X\u0080\u000e\u00a2\u0006\f\n\u0004\b\u0014\u0010,\"\u0004\b-\u0010.R\u001e\u0010\u0019\u001a\u0004\u0018\u00010\n8\u0000@\u0000X\u0080\u000e\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001e\"\u0004\b/\u0010 "}, d2={"Lokhttp3/HttpUrl$Builder;", "", "<init>", "()V", "Lokhttp3/HttpUrl;", "build", "()Lokhttp3/HttpUrl;", "", "effectivePort", "()I", "", "encodedQuery", "(Ljava/lang/String;)Lokhttp3/HttpUrl$Builder;", "host", "base", "input", "parse$okhttp", "(Lokhttp3/HttpUrl;Ljava/lang/String;)Lokhttp3/HttpUrl$Builder;", "parse", "password", "port", "(I)Lokhttp3/HttpUrl$Builder;", "reencodeForUri$okhttp", "()Lokhttp3/HttpUrl$Builder;", "reencodeForUri", "scheme", "toString", "()Ljava/lang/String;", "username", "encodedFragment", "Ljava/lang/String;", "setEncodedFragment$okhttp", "(Ljava/lang/String;)V", "encodedPassword", "setEncodedPassword$okhttp", "", "encodedPathSegments", "Ljava/util/List;", "getEncodedPathSegments$okhttp", "()Ljava/util/List;", "encodedQueryNamesAndValues", "encodedUsername", "setEncodedUsername$okhttp", "setHost$okhttp", "I", "setPort$okhttp", "(I)V", "setScheme$okhttp", "Companion"})
    @SourceDebugExtension(value={"SMAP\nHttpUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpUrl.kt\nokhttp3/HttpUrl$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1869:1\n1#2:1870\n1549#3:1871\n1620#3,3:1872\n1549#3:1875\n1620#3,3:1876\n*S KotlinDebug\n*F\n+ 1 HttpUrl.kt\nokhttp3/HttpUrl$Builder\n*L\n1180#1:1871\n1180#1:1872,3\n1181#1:1875\n1181#1:1876,3\n*E\n"})
    public static final class Builder {
        public static final Companion Companion = new Companion(null);
        private String scheme;
        private String encodedUsername = "";
        private String encodedPassword = "";
        private String host;
        private int port = -1;
        private final List<String> encodedPathSegments = new ArrayList();
        public List<String> encodedQueryNamesAndValues;
        private String encodedFragment;

        public Builder() {
            this.encodedPathSegments.add("");
        }

        /*
         * WARNING - void declaration
         */
        public final void setScheme$okhttp(String string) {
            void var1_1;
            this.scheme = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setEncodedUsername$okhttp(String string) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.encodedUsername = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setEncodedPassword$okhttp(String string) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.encodedPassword = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setHost$okhttp(String string) {
            void var1_1;
            this.host = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPort$okhttp(int n) {
            void var1_1;
            this.port = var1_1;
        }

        public final List<String> getEncodedPathSegments$okhttp() {
            return this.encodedPathSegments;
        }

        /*
         * WARNING - void declaration
         */
        public final void setEncodedFragment$okhttp(String string) {
            void var1_1;
            this.encodedFragment = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder scheme(String scheme) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            Builder $this$scheme_u24lambda_u240 = builder = this;
            if (StringsKt.equals((String)scheme, (String)"http", (boolean)true)) {
                $this$scheme_u24lambda_u240.scheme = "http";
            } else if (StringsKt.equals((String)scheme, (String)"https", (boolean)true)) {
                var3_3.scheme = "https";
            } else {
                void var1_1;
                throw new IllegalArgumentException("unexpected scheme: " + (String)var1_1);
            }
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder username(String username) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Builder builder2 = builder = this;
            builder.encodedUsername = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, (String)var1_1, 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, null, 251);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder password(String password) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Builder builder2 = builder = this;
            builder.encodedPassword = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, (String)var1_1, 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, null, 251);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder host(String host) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Builder $this$host_u24lambda_u245 = builder = this;
            String string = HostnamesKt.toCanonicalHost(okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, host, 0, 0, false, 7));
            if (string == null) {
                throw new IllegalArgumentException("unexpected host: " + host);
            }
            String encoded = string;
            var3_3.host = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder port(int port2) {
            void var1_1;
            Builder builder;
            Builder $this$port_u24lambda_u247 = builder = this;
            if (!(port2 > 0 ? port2 < 65536 : false)) {
                String port2 = "unexpected port: " + port2;
                throw new IllegalArgumentException(port2.toString());
            }
            var3_4.port = var1_1;
            return builder;
        }

        private final int effectivePort() {
            if (this.port != -1) {
                return this.port;
            }
            String string = this.scheme;
            Intrinsics.checkNotNull((Object)string);
            return okhttp3.HttpUrl$Companion.defaultPort(string);
        }

        public final Builder encodedQuery(String encodedQuery) {
            String string;
            Builder builder;
            Builder builder2 = builder = this;
            builder.encodedQueryNamesAndValues = encodedQuery != null && (string = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, string, 0, 0, " \"'<>#", true, false, true, false, null, 211)) != null ? okhttp3.HttpUrl$Companion.toQueryNamesAndValues$okhttp(string) : null;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder reencodeForUri$okhttp() {
            void var2_2;
            String string;
            Builder builder;
            Builder $this$reencodeForUri_u24lambda_u2428 = builder = this;
            String string2 = $this$reencodeForUri_u24lambda_u2428.host;
            if (string2 != null) {
                CharSequence charSequence = string2;
                Regex regex = new Regex("[\"<>^`{|}]");
                String string3 = "";
                string = regex.replace(charSequence, string3);
            } else {
                string = null;
            }
            builder.host = string;
            int n = $this$reencodeForUri_u24lambda_u2428.encodedPathSegments.size();
            for (int i = 0; i < n; ++i) {
                $this$reencodeForUri_u24lambda_u2428.encodedPathSegments.set(i, okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, $this$reencodeForUri_u24lambda_u2428.encodedPathSegments.get(i), 0, 0, "[]", true, true, false, false, null, 227));
            }
            List<String> encodedQueryNamesAndValues = $this$reencodeForUri_u24lambda_u2428.encodedQueryNamesAndValues;
            if (encodedQueryNamesAndValues != null) {
                int n2 = encodedQueryNamesAndValues.size();
                for (int i = 0; i < n2; ++i) {
                    String string4 = encodedQueryNamesAndValues.get(i);
                    encodedQueryNamesAndValues.set(i, string4 != null ? okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, string4, 0, 0, "\\^`{|}", true, true, true, false, null, 195) : null);
                }
            }
            String string5 = var2_2.encodedFragment;
            var2_2.encodedFragment = string5 != null ? okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, string5, 0, 0, " \"#<>\\^`{|}", true, true, false, true, null, 163) : null;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final HttpUrl build() {
            Object object;
            Object object2;
            Collection<String> collection;
            Object object3;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String string = this.scheme;
            if (string == null) {
                throw new IllegalStateException("scheme == null");
            }
            String string2 = this.host;
            if (string2 == null) {
                throw new IllegalStateException("host == null");
            }
            Object object4 = this.encodedPathSegments;
            int n = this.effectivePort();
            String string3 = string2;
            String string4 = okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, this.encodedPassword, 0, 0, false, 7);
            String string5 = okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, this.encodedUsername, 0, 0, false, 7);
            String string6 = string;
            Object object5 = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object3 = (String)object5;
                collection = destination$iv$iv;
                collection.add(okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, (String)it, 0, 0, false, 7));
            }
            collection = (List)destination$iv$iv;
            String string7 = string6;
            String string8 = string5;
            String string9 = string4;
            String string10 = string3;
            int n2 = n;
            Collection<String> collection2 = collection;
            List<String> list = this.encodedQueryNamesAndValues;
            if (list != null) {
                String $this$mapTo$iv$iv2;
                $this$map$iv = list;
                collection = collection2;
                n = n2;
                string3 = string10;
                string4 = string9;
                string5 = string8;
                string6 = string7;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                object5 = $this$mapTo$iv$iv2.iterator();
                while (object5.hasNext()) {
                    Object item$iv$iv = object5.next();
                    $this$mapTo$iv$iv2 = (String)item$iv$iv;
                    object3 = destination$iv$iv2;
                    Object object6 = object2;
                    object3.add(object6 != null ? okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, (String)object6, 0, 0, true, 3) : null);
                }
                object3 = (List)object4;
                string7 = string6;
                string8 = string5;
                string9 = string4;
                string10 = string3;
                n2 = n;
                collection2 = collection;
                object = object3;
            } else {
                object = null;
            }
            String string11 = this.encodedFragment;
            object4 = this.toString();
            object5 = string11 != null ? okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, string11, 0, 0, false, 7) : null;
            object2 = object;
            object3 = collection2;
            int n3 = n2;
            string5 = string10;
            string4 = string9;
            string3 = string8;
            String string12 = string7;
            return new HttpUrl(string12, string3, string4, string5, n3, (List<String>)object3, (List<String>)object2, (String)object5, (String)object4);
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            StringBuilder $this$toString_u24lambda_u2431;
            StringBuilder stringBuilder;
            block12: {
                void var3_3;
                block13: {
                    $this$toString_u24lambda_u2431 = stringBuilder = new StringBuilder();
                    if (this.scheme != null) {
                        $this$toString_u24lambda_u2431.append(this.scheme);
                        $this$toString_u24lambda_u2431.append("://");
                    } else {
                        $this$toString_u24lambda_u2431.append("//");
                    }
                    if (((CharSequence)this.encodedUsername).length() > 0 || ((CharSequence)this.encodedPassword).length() > 0) {
                        $this$toString_u24lambda_u2431.append(this.encodedUsername);
                        if (((CharSequence)this.encodedPassword).length() > 0) {
                            $this$toString_u24lambda_u2431.append(':');
                            $this$toString_u24lambda_u2431.append(this.encodedPassword);
                        }
                        $this$toString_u24lambda_u2431.append('@');
                    }
                    if (this.host != null) {
                        String string = this.host;
                        Intrinsics.checkNotNull((Object)string);
                        if (StringsKt.contains$default((CharSequence)string, (char)':', (boolean)false, (int)2, null)) {
                            $this$toString_u24lambda_u2431.append('[');
                            $this$toString_u24lambda_u2431.append(this.host);
                            $this$toString_u24lambda_u2431.append(']');
                        } else {
                            $this$toString_u24lambda_u2431.append(this.host);
                        }
                    }
                    if (this.port == -1 && this.scheme == null) break block12;
                    int effectivePort = this.effectivePort();
                    if (this.scheme == null) break block13;
                    String string = this.scheme;
                    Intrinsics.checkNotNull((Object)string);
                    if (effectivePort == okhttp3.HttpUrl$Companion.defaultPort(string)) break block12;
                }
                $this$toString_u24lambda_u2431.append(':');
                $this$toString_u24lambda_u2431.append((int)var3_3);
            }
            okhttp3.HttpUrl$Companion.toPathString$okhttp(this.encodedPathSegments, $this$toString_u24lambda_u2431);
            if (this.encodedQueryNamesAndValues != null) {
                $this$toString_u24lambda_u2431.append('?');
                List<String> list = this.encodedQueryNamesAndValues;
                Intrinsics.checkNotNull(list);
                okhttp3.HttpUrl$Companion.toQueryString$okhttp(list, $this$toString_u24lambda_u2431);
            }
            if (this.encodedFragment != null) {
                void var2_2;
                $this$toString_u24lambda_u2431.append('#');
                var2_2.append(this.encodedFragment);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public final Builder parse$okhttp(HttpUrl base, String input) {
            void var1_5;
            int n;
            int pathDelimiterOffset;
            int portColonOffset;
            int n2;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int pos = Util.indexOfFirstNonAsciiWhitespace$default$4abc9f13(input, 0, 0, 3);
            int limit = Util.indexOfLastNonAsciiWhitespace$default$4abc9f13(input, pos, 0, 2);
            int schemeDelimiterOffset = Companion.access$schemeDelimiterOffset(Companion, input, pos, limit);
            if (schemeDelimiterOffset != -1) {
                if (StringsKt.startsWith((String)input, (String)"https:", (int)pos, (boolean)true)) {
                    this.scheme = "https";
                    pos += 6;
                } else {
                    if (!StringsKt.startsWith((String)input, (String)"http:", (int)pos, (boolean)true)) {
                        StringBuilder stringBuilder = new StringBuilder("Expected URL scheme 'http' or 'https' but was '");
                        String string = input.substring(0, schemeDelimiterOffset);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        throw new IllegalArgumentException(stringBuilder.append(string).append('\'').toString());
                    }
                    this.scheme = "http";
                    pos += 5;
                }
            } else if (base != null) {
                this.scheme = base.scheme();
            } else {
                String truncated = input.length() > 6 ? StringsKt.take((String)input, (int)6) + "..." : input;
                throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but no scheme was found for " + truncated);
            }
            boolean hasUsername = false;
            boolean hasPassword = false;
            int slashCount = Companion.access$slashCount(Companion, input, pos, limit);
            if (slashCount < 2 && base != null && Intrinsics.areEqual((Object)base.scheme(), (Object)this.scheme)) {
                void componentDelimiterOffset2;
                this.encodedUsername = componentDelimiterOffset2.encodedUsername();
                this.encodedPassword = componentDelimiterOffset2.encodedPassword();
                this.host = componentDelimiterOffset2.host();
                this.port = componentDelimiterOffset2.port();
                this.encodedPathSegments.clear();
                this.encodedPathSegments.addAll((Collection<String>)componentDelimiterOffset2.encodedPathSegments());
                if (n2 == limit || input.charAt(n2) == '#') {
                    this.encodedQuery(componentDelimiterOffset2.encodedQuery());
                }
            } else {
                pos += slashCount;
                block4: while (true) {
                    int componentDelimiterOffset2;
                    slashCount = (componentDelimiterOffset2 = Util.delimiterOffset(input, "@/\\?#", pos, limit)) != limit ? (int)input.charAt(componentDelimiterOffset2) : -1;
                    switch (slashCount) {
                        case 64: {
                            if (!hasPassword) {
                                void var3_8;
                                int passwordColonOffset = Util.delimiterOffset(input, ':', pos, componentDelimiterOffset2);
                                String canonicalUsername = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, input, pos, passwordColonOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, null, 240);
                                Object object = this.encodedUsername = hasUsername ? this.encodedUsername + "%40" + canonicalUsername : var3_8;
                                if (passwordColonOffset != componentDelimiterOffset2) {
                                    hasPassword = true;
                                    this.encodedPassword = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, input, passwordColonOffset + 1, componentDelimiterOffset2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, null, 240);
                                }
                                hasUsername = true;
                            } else {
                                this.encodedPassword = this.encodedPassword + "%40" + okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, input, n2, componentDelimiterOffset2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, null, 240);
                            }
                            n2 = componentDelimiterOffset2 + 1;
                            continue block4;
                        }
                        case -1: 
                        case 35: 
                        case 47: 
                        case 63: 
                        case 92: {
                            portColonOffset = Companion.access$portColonOffset(Companion, input, n2, componentDelimiterOffset2);
                            if (portColonOffset + 1 < componentDelimiterOffset2) {
                                this.host = HostnamesKt.toCanonicalHost(okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, input, n2, portColonOffset, false, 4));
                                this.port = Companion.access$parsePort(Companion, input, portColonOffset + 1, componentDelimiterOffset2);
                                if (!(this.port != -1)) {
                                    StringBuilder stringBuilder = new StringBuilder("Invalid URL port: \"");
                                    String string = input.substring(portColonOffset + 1, componentDelimiterOffset2);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                    String componentDelimiterOffset2 = stringBuilder.append(string).append('\"').toString();
                                    throw new IllegalArgumentException(componentDelimiterOffset2.toString());
                                }
                            } else {
                                this.host = HostnamesKt.toCanonicalHost(okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, input, n2, portColonOffset, false, 4));
                                String string = this.scheme;
                                Intrinsics.checkNotNull((Object)string);
                                this.port = okhttp3.HttpUrl$Companion.defaultPort(string);
                            }
                            if (!(this.host != null)) {
                                StringBuilder stringBuilder = new StringBuilder("Invalid URL host: \"");
                                String string = input.substring(n2, portColonOffset);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                String componentDelimiterOffset2 = stringBuilder.append(string).append('\"').toString();
                                throw new IllegalArgumentException(componentDelimiterOffset2.toString());
                            }
                            n2 = componentDelimiterOffset2;
                            break block4;
                        }
                        default: {
                            continue block4;
                        }
                    }
                    break;
                }
            }
            portColonOffset = pathDelimiterOffset = Util.delimiterOffset(input, "?#", n2, limit);
            int n3 = n2;
            String string = input;
            Builder builder = this;
            if (n3 != portColonOffset) {
                int n4 = string.charAt(n3);
                if (n4 == 47 || n4 == 92) {
                    builder.encodedPathSegments.clear();
                    builder.encodedPathSegments.add("");
                    ++n3;
                } else {
                    builder.encodedPathSegments.set(builder.encodedPathSegments.size() - 1, "");
                }
                while (n3 < portColonOffset) {
                    n4 = Util.delimiterOffset(string, "/\\", n3, portColonOffset);
                    boolean bl = n4 < portColonOffset;
                    int n5 = n3;
                    n3 = 1;
                    boolean bl2 = bl;
                    int n6 = n4;
                    int n7 = n5;
                    String string2 = string;
                    Object object = builder;
                    string2 = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, string2, n7, n6, " \"<>^`{}|/\\?#", true, false, false, false, null, 240);
                    Object object2 = string2;
                    if (!(Intrinsics.areEqual((Object)string2, (Object)".") || StringsKt.equals((String)object2, (String)"%2e", (boolean)true))) {
                        object2 = string2;
                        if (Intrinsics.areEqual((Object)object2, (Object)"..") || StringsKt.equals((String)object2, (String)"%2e.", (boolean)true) || StringsKt.equals((String)object2, (String)".%2e", (boolean)true) || StringsKt.equals((String)object2, (String)"%2e%2e", (boolean)true)) {
                            object2 = object;
                            object = ((Builder)object2).encodedPathSegments.remove(((Builder)object2).encodedPathSegments.size() - 1);
                            if (((CharSequence)object).length() == 0 && !((Collection)((Builder)object2).encodedPathSegments).isEmpty()) {
                                ((Builder)object2).encodedPathSegments.set(((Builder)object2).encodedPathSegments.size() - 1, "");
                            } else {
                                ((Builder)object2).encodedPathSegments.add("");
                            }
                        } else {
                            if (((CharSequence)((Builder)object).encodedPathSegments.get(((Builder)object).encodedPathSegments.size() - 1)).length() == 0) {
                                ((Builder)object).encodedPathSegments.set(((Builder)object).encodedPathSegments.size() - 1, string2);
                            } else {
                                ((Builder)object).encodedPathSegments.add(string2);
                            }
                            if (bl2) {
                                ((Builder)object).encodedPathSegments.add("");
                            }
                        }
                    }
                    n3 = n4;
                    if (!bl) continue;
                    ++n3;
                }
            }
            if ((n = var1_5) < limit && input.charAt(n) == '?') {
                int queryDelimiterOffset = Util.delimiterOffset(input, '#', n, limit);
                this.encodedQueryNamesAndValues = okhttp3.HttpUrl$Companion.toQueryNamesAndValues$okhttp(okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, input, (int)(n + true), queryDelimiterOffset, " \"'<>#", true, false, true, false, null, 208));
                n = queryDelimiterOffset;
            }
            if (n < limit && input.charAt(n) == '#') {
                void var2_6;
                this.encodedFragment = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, (String)var2_6, (int)(n + true), limit, "", true, false, false, true, null, 176);
            }
            return this;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lokhttp3/HttpUrl$Builder$Companion;", "", "<init>", "()V", "", "input", "", "pos", "limit", "parsePort", "(Ljava/lang/String;II)I"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            private static int parsePort(String input, int pos, int limit) {
                int n;
                try {
                    void var2_3;
                    void var1_2;
                    input = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(HttpUrl.Companion, input, (int)var1_2, (int)var2_3, "", false, false, false, false, null, 248);
                    int i = Integer.parseInt(input);
                    n = (i > 0 ? i < 65536 : false) ? n : -1;
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                return n;
            }

            /*
             * WARNING - void declaration
             */
            public static final /* synthetic */ int access$schemeDelimiterOffset(Companion $this, String input, int pos, int limit) {
                int n;
                block5: {
                    char c;
                    void var2_3;
                    void v0 = var2_3;
                    var2_3 = c;
                    void var1_2 = v0;
                    String string = input;
                    if (var2_3 - var1_2 >= 2) {
                        c = string.charAt((int)var1_2);
                        if (!(Intrinsics.compare((int)c, (int)97) >= 0 && Intrinsics.compare((int)c, (int)122) <= 0 || Intrinsics.compare((int)c, (int)65) >= 0 && Intrinsics.compare((int)c, (int)90) <= 0)) {
                            return -1;
                        }
                        ++var1_2;
                        while (var1_2 < var2_3) {
                            c = string.charAt((int)var1_2);
                            if (!(((((('a' <= c ? c < '{' : false) ? true : ('A' <= c ? c < '[' : false)) ? true : ('0' <= c ? c < ':' : false)) ? true : c == '+') ? true : c == '-') ? true : c == '.')) {
                                if (c == ':') {
                                    n = var1_2;
                                    break block5;
                                }
                                return -1;
                            }
                            ++var1_2;
                        }
                    }
                    n = -1;
                }
                return n;
            }

            /*
             * WARNING - void declaration
             */
            public static final /* synthetic */ int access$slashCount(Companion $this, String $receiver, int pos, int limit) {
                char c;
                int n;
                void var2_3;
                void v0 = var2_3;
                var2_3 = n;
                void var1_2 = v0;
                String string = $receiver;
                n = 0;
                while (var1_2 < var2_3 && ((c = string.charAt((int)var1_2)) == '\\' || c == '/')) {
                    ++n;
                    ++var1_2;
                }
                return n;
            }

            /*
             * WARNING - void declaration
             */
            public static final /* synthetic */ int access$portColonOffset(Companion $this, String input, int pos, int limit) {
                char c;
                void var2_3;
                void v0 = var2_3;
                var2_3 = c;
                void var1_2 = v0;
                String string = input;
                while (var1_2 < var2_3) {
                    c = string.charAt((int)var1_2);
                    if (c == '[') {
                        while (++var1_2 < var2_3 && string.charAt((int)var1_2) != ']') {
                        }
                    } else if (c == ':') {
                        return (int)var1_2;
                    }
                    ++var1_2;
                }
                return (int)var2_3;
            }

            /*
             * WARNING - void declaration
             */
            public static final /* synthetic */ int access$parsePort(Companion $this, String input, int pos, int limit) {
                void var3_3;
                void var2_2;
                return okhttp3.HttpUrl$Builder$Companion.parsePort(input, (int)var2_2, (int)var3_3);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\f\u001a\u00020\u000b*\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u0011\u001a\u00020\u000e*\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u000e*\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0010J%\u0010\u001b\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020\u00040\u00142\n\u0010\u0017\u001a\u00060\u0015j\u0002`\u0016H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001b\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001c*\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ'\u0010!\u001a\u00020\u0018*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00142\n\u0010\u0017\u001a\u00060\u0015j\u0002`\u0016H\u0000\u00a2\u0006\u0004\b \u0010\u001aR\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$"}, d2={"Lokhttp3/HttpUrl$Companion;", "", "<init>", "()V", "", "scheme", "", "defaultPort", "(Ljava/lang/String;)I", "pos", "limit", "", "isPercentEncoded", "(Ljava/lang/String;II)Z", "Lokhttp3/HttpUrl;", "get", "(Ljava/lang/String;)Lokhttp3/HttpUrl;", "toHttpUrl", "parse", "toHttpUrlOrNull", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "out", "", "toPathString$okhttp", "(Ljava/util/List;Ljava/lang/StringBuilder;)V", "toPathString", "", "toQueryNamesAndValues$okhttp", "(Ljava/lang/String;)Ljava/util/List;", "toQueryNamesAndValues", "toQueryString$okhttp", "toQueryString", "", "HEX_DIGITS", "[C"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public static int defaultPort(String scheme) {
            String string;
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            if (Intrinsics.areEqual((Object)string, (Object)"http")) {
                return 80;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"https")) {
                return 443;
            }
            return -1;
        }

        public static void toPathString$okhttp(List<String> $this$toPathString, StringBuilder out) {
            Intrinsics.checkNotNullParameter($this$toPathString, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            int n = $this$toPathString.size();
            for (int i = 0; i < n; ++i) {
                out.append('/');
                out.append($this$toPathString.get(i));
            }
        }

        public static void toQueryString$okhttp(List<String> $this$toQueryString, StringBuilder out) {
            Intrinsics.checkNotNullParameter($this$toQueryString, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)$this$toQueryString.size())), (int)2);
            int i = intProgression.getFirst();
            int n = intProgression.getLast();
            int n2 = intProgression.getStep();
            if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
                while (true) {
                    String name = $this$toQueryString.get(i);
                    String value = $this$toQueryString.get(i + 1);
                    if (i > 0) {
                        out.append('&');
                    }
                    out.append(name);
                    if (value != null) {
                        out.append('=');
                        out.append(value);
                    }
                    if (i == n) break;
                    i += n2;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public static List<String> toQueryNamesAndValues$okhttp(String $this$toQueryNamesAndValues) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$toQueryNamesAndValues, (String)"<this>");
            List result = new ArrayList();
            int pos = 0;
            while (pos <= $this$toQueryNamesAndValues.length()) {
                void var3_3;
                int equalsOffset;
                int ampersandOffset = StringsKt.indexOf$default((CharSequence)$this$toQueryNamesAndValues, (char)'&', (int)pos, (boolean)false, (int)4, null);
                if (ampersandOffset == -1) {
                    ampersandOffset = $this$toQueryNamesAndValues.length();
                }
                if ((equalsOffset = StringsKt.indexOf$default((CharSequence)$this$toQueryNamesAndValues, (char)'=', (int)pos, (boolean)false, (int)4, null)) == -1 || equalsOffset > ampersandOffset) {
                    String string = $this$toQueryNamesAndValues.substring(pos, ampersandOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    result.add(string);
                    result.add(null);
                } else {
                    String string = $this$toQueryNamesAndValues.substring(pos, equalsOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    result.add(string);
                    String string2 = $this$toQueryNamesAndValues.substring(equalsOffset + 1, ampersandOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    result.add(string2);
                }
                pos = var3_3 + true;
            }
            return var1_1;
        }

        @JvmStatic
        @JvmName(name="get")
        public static HttpUrl get(String $this$toHttpUrl) {
            String string;
            Intrinsics.checkNotNullParameter((Object)$this$toHttpUrl, (String)"<this>");
            return new Builder().parse$okhttp(null, string).build();
        }

        @JvmStatic
        @JvmName(name="parse")
        public final HttpUrl parse(String $this$toHttpUrlOrNull) {
            HttpUrl httpUrl;
            Intrinsics.checkNotNullParameter((Object)$this$toHttpUrlOrNull, (String)"<this>");
            try {
                httpUrl = okhttp3.HttpUrl$Companion.get((String)((Object)httpUrl));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                httpUrl = null;
            }
            return httpUrl;
        }

        public static /* synthetic */ String percentDecode$okhttp$default$4e9e714e(Companion companion, String string, int n, int n2, boolean bl, int n3) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = string.length();
            }
            if ((n3 & 4) != 0) {
                bl = false;
            }
            Intrinsics.checkNotNullParameter((Object)string, (String)"<this>");
            for (int i = n; i < n2; ++i) {
                char c = string.charAt(i);
                n3 = c;
                if (c != '%' && (n3 != 43 || !bl)) continue;
                Buffer buffer = new Buffer();
                buffer.writeUtf8(string, n, i);
                n = i;
                Buffer buffer2 = buffer;
                int n4 = n;
                while (n4 < n2) {
                    n = string.codePointAt(n4);
                    if (n == 37 && n4 + 2 < n2) {
                        int n5 = Util.parseHexDigit(string.charAt(n4 + 1));
                        int n6 = Util.parseHexDigit(string.charAt(n4 + 2));
                        if (n5 != -1 && n6 != -1) {
                            buffer2.writeByte((n5 << 4) + n6);
                            n4 += 2;
                            n4 += Character.charCount(n);
                            continue;
                        }
                    } else if (n == 43 && bl) {
                        buffer2.writeByte(32);
                        ++n4;
                        continue;
                    }
                    buffer2.writeUtf8CodePoint(n);
                    n4 += Character.charCount(n);
                }
                return buffer.readUtf8();
            }
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string2;
        }

        /*
         * WARNING - void declaration
         */
        private static boolean isPercentEncoded(String $this$isPercentEncoded, int pos, int limit) {
            void var1_1;
            String string;
            void var2_2;
            return pos + 2 < var2_2 && $this$isPercentEncoded.charAt(pos) == '%' && Util.parseHexDigit($this$isPercentEncoded.charAt(pos + 1)) != -1 && Util.parseHexDigit(string.charAt((int)(var1_1 + 2))) != -1;
        }

        public static /* synthetic */ String canonicalize$okhttp$default$72d20940(Companion companion, String string, int n, int n2, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Charset charset, int n3) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = string.length();
            }
            if ((n3 & 8) != 0) {
                bl = false;
            }
            if ((n3 & 0x10) != 0) {
                bl2 = false;
            }
            if ((n3 & 0x20) != 0) {
                bl3 = false;
            }
            if ((n3 & 0x40) != 0) {
                bl4 = false;
            }
            charset = null;
            Intrinsics.checkNotNullParameter((Object)string, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)string2, (String)"encodeSet");
            for (int i = n; i < n2; i += Character.charCount(n3)) {
                n3 = string.codePointAt(i);
                if (!(n3 < 32 || n3 == 127 || n3 >= 128 && !bl4 || StringsKt.contains$default((CharSequence)string2, (char)((char)n3), (boolean)false, (int)2, null) || n3 == 37 && (!bl || bl2 && !okhttp3.HttpUrl$Companion.isPercentEncoded(string, i, n2))) && (n3 != 43 || !bl3)) continue;
                Buffer buffer = new Buffer();
                buffer.writeUtf8(string, n, i);
                Charset charset2 = charset;
                boolean bl5 = bl4;
                bl4 = bl3;
                bl3 = bl2;
                bl2 = bl;
                String string3 = string2;
                int n4 = n2;
                n2 = i;
                String string4 = string;
                string = buffer;
                companion = null;
                for (int j = n2; j < n4; j += Character.charCount(n2)) {
                    n2 = string4.codePointAt(j);
                    if (bl2 && (n2 == 9 || n2 == 10 || n2 == 12 || n2 == 13)) continue;
                    if (n2 == 43 && bl4) {
                        string.writeUtf8(bl2 ? "+" : "%2B");
                        continue;
                    }
                    if (n2 < 32 || n2 == 127 || n2 >= 128 && !bl5 || StringsKt.contains$default((CharSequence)string3, (char)((char)n2), (boolean)false, (int)2, null) || n2 == 37 && (!bl2 || bl3 && !okhttp3.HttpUrl$Companion.isPercentEncoded(string4, j, n4))) {
                        if (companion == null) {
                            companion = new Buffer();
                        }
                        if (charset2 == null || Intrinsics.areEqual((Object)charset2, (Object)StandardCharsets.UTF_8)) {
                            companion.writeUtf8CodePoint(n2);
                        } else {
                            int n5 = j;
                            companion.writeString(string4, n5, n5 + Character.charCount(n2), charset2);
                        }
                        while (!companion.exhausted()) {
                            int n6 = companion.readByte() & 0xFF;
                            string.writeByte(37);
                            string.writeByte((int)HEX_DIGITS[n6 >> 4 & 0xF]);
                            string.writeByte((int)HEX_DIGITS[n6 & 0xF]);
                        }
                        continue;
                    }
                    string.writeUtf8CodePoint(n2);
                }
                return buffer.readUtf8();
            }
            String string5 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string5;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

