/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocket;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.CipherSuite;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 &2\u00020\u0001:\u0002'&B9\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0013\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0019\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d8G\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001c\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010!R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b\u0003\u0010#R\u001a\u0010\u0004\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\"\u001a\u0004\b\u0004\u0010#R\u0019\u0010%\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010\u001d8G\u00a2\u0006\u0006\u001a\u0004\b%\u0010 R\u001c\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010!"}, d2={"Lokhttp3/ConnectionSpec;", "", "", "isTls", "supportsTlsExtensions", "", "", "cipherSuitesAsString", "tlsVersionsAsString", "<init>", "(ZZ[Ljava/lang/String;[Ljava/lang/String;)V", "Ljavax/net/ssl/SSLSocket;", "sslSocket", "isFallback", "", "apply$okhttp", "(Ljavax/net/ssl/SSLSocket;Z)V", "apply", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "socket", "isCompatible", "(Ljavax/net/ssl/SSLSocket;)Z", "toString", "()Ljava/lang/String;", "", "Lokhttp3/CipherSuite;", "cipherSuites", "()Ljava/util/List;", "[Ljava/lang/String;", "Z", "()Z", "Lokhttp3/TlsVersion;", "tlsVersions", "Companion", "Builder"})
@SourceDebugExtension(value={"SMAP\nConnectionSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionSpec.kt\nokhttp3/ConnectionSpec\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,350:1\n11065#2:351\n11400#2,3:352\n11065#2:355\n11400#2,3:356\n*S KotlinDebug\n*F\n+ 1 ConnectionSpec.kt\nokhttp3/ConnectionSpec\n*L\n59#1:351\n59#1:352,3\n75#1:355\n75#1:356,3\n*E\n"})
public final class ConnectionSpec {
    public static final Companion Companion = new Companion(null);
    private final boolean isTls;
    private final boolean supportsTlsExtensions;
    private final String[] cipherSuitesAsString;
    private final String[] tlsVersionsAsString;
    private static final CipherSuite[] RESTRICTED_CIPHER_SUITES;
    private static final CipherSuite[] APPROVED_CIPHER_SUITES;
    @JvmField
    public static final ConnectionSpec RESTRICTED_TLS;
    @JvmField
    public static final ConnectionSpec MODERN_TLS;
    @JvmField
    public static final ConnectionSpec COMPATIBLE_TLS;
    @JvmField
    public static final ConnectionSpec CLEARTEXT;

    /*
     * WARNING - void declaration
     */
    public ConnectionSpec(boolean isTls, boolean supportsTlsExtensions, String[] cipherSuitesAsString, String[] tlsVersionsAsString) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.isTls = var1_1;
        this.supportsTlsExtensions = var2_2;
        this.cipherSuitesAsString = var3_3;
        this.tlsVersionsAsString = tlsVersionsAsString;
    }

    @JvmName(name="isTls")
    public final boolean isTls() {
        return this.isTls;
    }

    @JvmName(name="supportsTlsExtensions")
    public final boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="cipherSuites")
    private List<CipherSuite> cipherSuites() {
        if (this.cipherSuitesAsString != null) {
            void var1_1;
            void $this$mapTo$iv$iv;
            String[] $this$map$iv = this.cipherSuitesAsString;
            String[] stringArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Collection collection = destination$iv$iv;
                collection.add(CipherSuite.Companion.forJavaName((String)it));
            }
            return CollectionsKt.toList((Iterable)((List)var1_1));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="tlsVersions")
    private List<TlsVersion> tlsVersions() {
        if (this.tlsVersionsAsString != null) {
            void var1_1;
            void $this$mapTo$iv$iv;
            String[] $this$map$iv = this.tlsVersionsAsString;
            String[] stringArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Collection collection = destination$iv$iv;
                collection.add(TlsVersion.Companion.forJavaName((String)it));
            }
            return CollectionsKt.toList((Iterable)((List)var1_1));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void apply$okhttp(SSLSocket sslSocket, boolean isFallback2) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        boolean bl = isFallback2;
        String[] stringArray4 = sslSocket;
        String[] isFallback2 = this;
        if (this.cipherSuitesAsString != null) {
            String[] stringArray5 = stringArray4.getEnabledCipherSuites();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray5, (String)"sslSocket.enabledCipherSuites");
            stringArray3 = Util.intersect(stringArray5, isFallback2.cipherSuitesAsString, CipherSuite.Companion.getORDER_BY_NAME$okhttp());
        } else {
            stringArray3 = stringArray2 = stringArray4.getEnabledCipherSuites();
        }
        if (isFallback2.tlsVersionsAsString != null) {
            String[] stringArray6 = stringArray4.getEnabledProtocols();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray6, (String)"sslSocket.enabledProtocols");
            stringArray = Util.intersect(stringArray6, isFallback2.tlsVersionsAsString, ComparisonsKt.naturalOrder());
        } else {
            stringArray = stringArray4.getEnabledProtocols();
        }
        String[] stringArray7 = stringArray;
        stringArray4 = stringArray4.getSupportedCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"supportedCipherSuites");
        int n = Util.indexOf(stringArray4, "TLS_FALLBACK_SCSV", CipherSuite.Companion.getORDER_BY_NAME$okhttp());
        if (bl && n != -1) {
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"cipherSuitesIntersection");
            String string = stringArray4[n];
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"supportedCipherSuites[indexOfFallbackScsv]");
            stringArray2 = Util.concat(stringArray2, string);
        }
        Builder builder = new Builder((ConnectionSpec)isFallback2);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"cipherSuitesIntersection");
        isFallback2 = stringArray2;
        Builder builder2 = builder.cipherSuites(Arrays.copyOf(isFallback2, isFallback2.length));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray7, (String)"tlsVersionsIntersection");
        isFallback2 = stringArray7;
        ConnectionSpec specToApply = builder2.tlsVersions(Arrays.copyOf(stringArray7, isFallback2.length)).build();
        if (specToApply.tlsVersions() != null) {
            sslSocket.setEnabledProtocols(specToApply.tlsVersionsAsString);
        }
        if (specToApply.cipherSuites() != null) {
            void var2_3;
            void var1_1;
            var1_1.setEnabledCipherSuites(var2_3.cipherSuitesAsString);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCompatible(SSLSocket socket) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        if (!this.isTls) {
            return false;
        }
        if (this.tlsVersionsAsString != null && !Util.hasIntersection(this.tlsVersionsAsString, socket.getEnabledProtocols(), ComparisonsKt.naturalOrder())) {
            return false;
        }
        if (this.cipherSuitesAsString != null) {
            void var1_1;
            if (!Util.hasIntersection(this.cipherSuitesAsString, var1_1.getEnabledCipherSuites(), CipherSuite.Companion.getORDER_BY_NAME$okhttp())) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        if (!(other instanceof ConnectionSpec)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.isTls != ((ConnectionSpec)other).isTls) {
            return false;
        }
        if (this.isTls) {
            void var1_1;
            if (!Arrays.equals(this.cipherSuitesAsString, ((ConnectionSpec)other).cipherSuitesAsString)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersionsAsString, ((ConnectionSpec)other).tlsVersionsAsString)) {
                return false;
            }
            if (this.supportsTlsExtensions != ((ConnectionSpec)var1_1).supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = 17;
        if (this.isTls) {
            result = 527 + (this.cipherSuitesAsString != null ? Arrays.hashCode(this.cipherSuitesAsString) : 0);
            result = 31 * result + (this.tlsVersionsAsString != null ? Arrays.hashCode(this.tlsVersionsAsString) : 0);
            result = 31 * result + (this.supportsTlsExtensions ? 0 : 1);
        }
        return (int)var1_1;
    }

    public final String toString() {
        if (!this.isTls) {
            return "ConnectionSpec()";
        }
        return "ConnectionSpec(cipherSuites=" + Objects.toString(this.cipherSuites(), "[all enabled]") + ", tlsVersions=" + Objects.toString(this.tlsVersions(), "[all enabled]") + ", supportsTlsExtensions=" + this.supportsTlsExtensions + ')';
    }

    static {
        CipherSuite[] cipherSuiteArray = new CipherSuite[9];
        Object[] objectArray = cipherSuiteArray;
        cipherSuiteArray[0] = CipherSuite.TLS_AES_128_GCM_SHA256;
        objectArray[1] = CipherSuite.TLS_AES_256_GCM_SHA384;
        objectArray[2] = CipherSuite.TLS_CHACHA20_POLY1305_SHA256;
        objectArray[3] = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256;
        objectArray[4] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256;
        objectArray[5] = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384;
        objectArray[6] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384;
        objectArray[7] = CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256;
        objectArray[8] = CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256;
        RESTRICTED_CIPHER_SUITES = objectArray;
        CipherSuite[] cipherSuiteArray2 = new CipherSuite[16];
        objectArray = cipherSuiteArray2;
        cipherSuiteArray2[0] = CipherSuite.TLS_AES_128_GCM_SHA256;
        objectArray[1] = CipherSuite.TLS_AES_256_GCM_SHA384;
        objectArray[2] = CipherSuite.TLS_CHACHA20_POLY1305_SHA256;
        objectArray[3] = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256;
        objectArray[4] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256;
        objectArray[5] = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384;
        objectArray[6] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384;
        objectArray[7] = CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256;
        objectArray[8] = CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256;
        objectArray[9] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA;
        objectArray[10] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA;
        objectArray[11] = CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256;
        objectArray[12] = CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384;
        objectArray[13] = CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA;
        objectArray[14] = CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA;
        objectArray[15] = CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA;
        APPROVED_CIPHER_SUITES = objectArray;
        objectArray = RESTRICTED_CIPHER_SUITES;
        Builder builder = new Builder(true).cipherSuites(Arrays.copyOf(RESTRICTED_CIPHER_SUITES, objectArray.length));
        TlsVersion[] tlsVersionArray = new TlsVersion[2];
        objectArray = tlsVersionArray;
        tlsVersionArray[0] = TlsVersion.TLS_1_3;
        objectArray[1] = TlsVersion.TLS_1_2;
        RESTRICTED_TLS = builder.tlsVersions((TlsVersion[])objectArray).supportsTlsExtensions(true).build();
        objectArray = APPROVED_CIPHER_SUITES;
        Builder builder2 = new Builder(true).cipherSuites(Arrays.copyOf(APPROVED_CIPHER_SUITES, objectArray.length));
        TlsVersion[] tlsVersionArray2 = new TlsVersion[2];
        objectArray = tlsVersionArray2;
        tlsVersionArray2[0] = TlsVersion.TLS_1_3;
        objectArray[1] = TlsVersion.TLS_1_2;
        MODERN_TLS = builder2.tlsVersions((TlsVersion[])objectArray).supportsTlsExtensions(true).build();
        objectArray = APPROVED_CIPHER_SUITES;
        Builder builder3 = new Builder(true).cipherSuites(Arrays.copyOf(APPROVED_CIPHER_SUITES, objectArray.length));
        TlsVersion[] tlsVersionArray3 = new TlsVersion[4];
        objectArray = tlsVersionArray3;
        tlsVersionArray3[0] = TlsVersion.TLS_1_3;
        objectArray[1] = TlsVersion.TLS_1_2;
        objectArray[2] = TlsVersion.TLS_1_1;
        objectArray[3] = TlsVersion.TLS_1_0;
        COMPATIBLE_TLS = builder3.tlsVersions((TlsVersion[])objectArray).supportsTlsExtensions(true).build();
        CLEARTEXT = new Builder(false).build();
    }

    @SourceDebugExtension(value={"SMAP\nConnectionSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionSpec.kt\nokhttp3/ConnectionSpec$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,350:1\n1#2:351\n11065#3:352\n11400#3,3:353\n11065#3:358\n11400#3,3:359\n37#4,2:356\n37#4,2:362\n*S KotlinDebug\n*F\n+ 1 ConnectionSpec.kt\nokhttp3/ConnectionSpec$Builder\n*L\n225#1:352\n225#1:353,3\n244#1:358\n244#1:359,3\n225#1:356,2\n244#1:362,2\n*E\n"})
    public static final class Builder {
        private boolean tls;
        private String[] cipherSuites;
        private String[] tlsVersions;
        private boolean supportsTlsExtensions;

        /*
         * WARNING - void declaration
         */
        public Builder(boolean tls) {
            void var1_1;
            this.tls = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(ConnectionSpec connectionSpec) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)connectionSpec, (String)"connectionSpec");
            this.tls = connectionSpec.isTls();
            this.cipherSuites = connectionSpec.cipherSuitesAsString;
            this.tlsVersions = connectionSpec.tlsVersionsAsString;
            this.supportsTlsExtensions = var1_1.supportsTlsExtensions();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder cipherSuites(CipherSuite ... cipherSuites) {
            void var2_2;
            void var1_1;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)cipherSuites, (String)"cipherSuites");
            Builder $this$cipherSuites_u24lambda_u244 = this;
            if (!$this$cipherSuites_u24lambda_u244.tls) {
                cipherSuites = "no cipher suites for cleartext connections";
                throw new IllegalArgumentException(cipherSuites.toString());
            }
            CipherSuite[] $this$map$iv = cipherSuites;
            Object object = cipherSuites;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Collection collection = destination$iv$iv;
                collection.add(it.javaName());
            }
            destination$iv$iv = (List)destination$iv$iv;
            object = destination$iv$iv;
            String[] strings = destination$iv$iv.toArray(new String[0]);
            void v0 = var1_1;
            return var2_2.cipherSuites((String[])Arrays.copyOf(v0, ((void)v0).length));
        }

        /*
         * WARNING - void declaration
         */
        public final Builder cipherSuites(String ... cipherSuites) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)cipherSuites, (String)"cipherSuites");
            Builder $this$cipherSuites_u24lambda_u247 = builder = this;
            if (!builder.tls) {
                cipherSuites = "no cipher suites for cleartext connections";
                throw new IllegalArgumentException(cipherSuites.toString());
            }
            if (!(!(((String[])cipherSuites).length == 0))) {
                cipherSuites = "At least one cipher suite is required";
                throw new IllegalArgumentException(cipherSuites.toString());
            }
            var3_3.cipherSuites = (String[])var1_1.clone();
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder tlsVersions(TlsVersion ... tlsVersions) {
            void var2_2;
            void var1_1;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)tlsVersions, (String)"tlsVersions");
            Builder $this$tlsVersions_u24lambda_u2412 = this;
            if (!$this$tlsVersions_u24lambda_u2412.tls) {
                tlsVersions = "no TLS versions for cleartext connections";
                throw new IllegalArgumentException(tlsVersions.toString());
            }
            TlsVersion[] $this$map$iv = tlsVersions;
            Object object = tlsVersions;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Collection collection = destination$iv$iv;
                collection.add(it.javaName());
            }
            destination$iv$iv = (List)destination$iv$iv;
            object = destination$iv$iv;
            String[] strings = destination$iv$iv.toArray(new String[0]);
            void v0 = var1_1;
            return var2_2.tlsVersions((String[])Arrays.copyOf(v0, ((void)v0).length));
        }

        /*
         * WARNING - void declaration
         */
        public final Builder tlsVersions(String ... tlsVersions) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tlsVersions, (String)"tlsVersions");
            Builder $this$tlsVersions_u24lambda_u2415 = builder = this;
            if (!builder.tls) {
                tlsVersions = "no TLS versions for cleartext connections";
                throw new IllegalArgumentException(tlsVersions.toString());
            }
            if (!(!(((String[])tlsVersions).length == 0))) {
                tlsVersions = "At least one TLS version is required";
                throw new IllegalArgumentException(tlsVersions.toString());
            }
            var3_3.tlsVersions = (String[])var1_1.clone();
            return builder;
        }

        @Deprecated(message="since OkHttp 3.13 all TLS-connections are expected to support TLS extensions.\nIn a future release setting this to true will be unnecessary and setting it to false\nwill have no effect.")
        public final Builder supportsTlsExtensions(boolean supportsTlsExtensions) {
            Object object = this;
            Builder $this$supportsTlsExtensions_u24lambda_u2417 = object;
            if (!((Builder)object).tls) {
                object = "no TLS extensions for cleartext connections";
                throw new IllegalArgumentException(object.toString());
            }
            var2_3.supportsTlsExtensions = true;
            return (Builder)object;
        }

        public final ConnectionSpec build() {
            return new ConnectionSpec(this.tls, this.supportsTlsExtensions, this.cipherSuites, this.tlsVersions);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\n"}, d2={"Lokhttp3/ConnectionSpec$Companion;", "", "<init>", "()V", "", "Lokhttp3/CipherSuite;", "APPROVED_CIPHER_SUITES", "[Lokhttp3/CipherSuite;", "Lokhttp3/ConnectionSpec;", "CLEARTEXT", "Lokhttp3/ConnectionSpec;", "COMPATIBLE_TLS", "MODERN_TLS", "RESTRICTED_CIPHER_SUITES", "RESTRICTED_TLS"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

