/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.internal.Util;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001c\u001bBs\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0002\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u0012\u0006\u0010\u000f\u001a\u00020\u0002\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0016R\u0011\u0010\u000f\u001a\u00020\u00028\u0007\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0017R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0017\u001a\u0004\b\b\u0010\u0018R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0017\u001a\u0004\b\t\u0010\u0018R\u0017\u0010\u0006\u001a\u00020\u00058\u0007\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0019\u001a\u0004\b\u0006\u0010\u001aR\u001a\u0010\u000b\u001a\u00020\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0019\u001a\u0004\b\u000b\u0010\u001aR\u001a\u0010\f\u001a\u00020\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\u0019\u001a\u0004\b\f\u0010\u001aR\u001a\u0010\n\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u0017\u001a\u0004\b\n\u0010\u0018R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0003\u0010\u0018R\u001a\u0010\u0004\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0017\u001a\u0004\b\u0004\u0010\u0018R\u0014\u0010\u000e\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0017R\u001a\u0010\r\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u0017\u001a\u0004\b\r\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00058\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019"}, d2={"Lokhttp3/CacheControl;", "", "", "noCache", "noStore", "", "maxAgeSeconds", "sMaxAgeSeconds", "isPrivate", "isPublic", "mustRevalidate", "maxStaleSeconds", "minFreshSeconds", "onlyIfCached", "noTransform", "immutable", "", "headerValue", "<init>", "(ZZIIZZZIIZZZLjava/lang/String;)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "Z", "()Z", "I", "()I", "Companion", "Builder"})
public final class CacheControl {
    public static final Companion Companion = new Companion(null);
    private final boolean noCache;
    private final boolean noStore;
    private final int maxAgeSeconds;
    public final int sMaxAgeSeconds;
    private final boolean isPrivate;
    private final boolean isPublic;
    private final boolean mustRevalidate;
    private final int maxStaleSeconds;
    private final int minFreshSeconds;
    private final boolean onlyIfCached;
    public final boolean noTransform;
    public final boolean immutable;
    private String headerValue;
    @JvmField
    public static final CacheControl FORCE_NETWORK = new Builder().noCache().build();
    @JvmField
    public static final CacheControl FORCE_CACHE = new Builder().onlyIfCached().maxStale(Integer.MAX_VALUE, TimeUnit.SECONDS).build();

    /*
     * WARNING - void declaration
     */
    private CacheControl(boolean noCache, boolean noStore, int maxAgeSeconds, int sMaxAgeSeconds, boolean isPrivate, boolean isPublic, boolean mustRevalidate, int maxStaleSeconds, int minFreshSeconds, boolean onlyIfCached, boolean noTransform, boolean immutable, String headerValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.noCache = var1_1;
        this.noStore = var2_2;
        this.maxAgeSeconds = var3_3;
        this.sMaxAgeSeconds = sMaxAgeSeconds;
        this.isPrivate = isPrivate;
        this.isPublic = isPublic;
        this.mustRevalidate = mustRevalidate;
        this.maxStaleSeconds = maxStaleSeconds;
        this.minFreshSeconds = minFreshSeconds;
        this.onlyIfCached = onlyIfCached;
        this.noTransform = noTransform;
        this.immutable = immutable;
        this.headerValue = headerValue;
    }

    @JvmName(name="noCache")
    public final boolean noCache() {
        return this.noCache;
    }

    @JvmName(name="noStore")
    public final boolean noStore() {
        return this.noStore;
    }

    @JvmName(name="maxAgeSeconds")
    public final int maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public final boolean isPrivate() {
        return this.isPrivate;
    }

    public final boolean isPublic() {
        return this.isPublic;
    }

    @JvmName(name="mustRevalidate")
    public final boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    @JvmName(name="maxStaleSeconds")
    public final int maxStaleSeconds() {
        return this.maxStaleSeconds;
    }

    @JvmName(name="minFreshSeconds")
    public final int minFreshSeconds() {
        return this.minFreshSeconds;
    }

    @JvmName(name="onlyIfCached")
    public final boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        CharSequence result = this.headerValue;
        if (result == null) {
            void var2_2;
            result = new StringBuilder();
            StringBuilder $this$toString_u24lambda_u240 = result;
            if (this.noCache) {
                $this$toString_u24lambda_u240.append("no-cache, ");
            }
            if (this.noStore) {
                $this$toString_u24lambda_u240.append("no-store, ");
            }
            if (this.maxAgeSeconds != -1) {
                $this$toString_u24lambda_u240.append("max-age=").append(this.maxAgeSeconds).append(", ");
            }
            if (this.sMaxAgeSeconds != -1) {
                $this$toString_u24lambda_u240.append("s-maxage=").append(this.sMaxAgeSeconds).append(", ");
            }
            if (this.isPrivate) {
                $this$toString_u24lambda_u240.append("private, ");
            }
            if (this.isPublic) {
                $this$toString_u24lambda_u240.append("public, ");
            }
            if (this.mustRevalidate) {
                $this$toString_u24lambda_u240.append("must-revalidate, ");
            }
            if (this.maxStaleSeconds != -1) {
                $this$toString_u24lambda_u240.append("max-stale=").append(this.maxStaleSeconds).append(", ");
            }
            if (this.minFreshSeconds != -1) {
                $this$toString_u24lambda_u240.append("min-fresh=").append(this.minFreshSeconds).append(", ");
            }
            if (this.onlyIfCached) {
                $this$toString_u24lambda_u240.append("only-if-cached, ");
            }
            if (this.noTransform) {
                $this$toString_u24lambda_u240.append("no-transform, ");
            }
            if (this.immutable) {
                $this$toString_u24lambda_u240.append("immutable, ");
            }
            if (((CharSequence)$this$toString_u24lambda_u240).length() == 0) {
                return "";
            }
            StringBuilder stringBuilder = $this$toString_u24lambda_u240;
            stringBuilder.delete(stringBuilder.length() - 2, var2_2.length());
            String string = ((StringBuilder)result).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            result = string;
            this.headerValue = result;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ CacheControl(boolean noCache, boolean noStore, int maxAgeSeconds, int sMaxAgeSeconds, boolean isPrivate, boolean isPublic, boolean mustRevalidate, int maxStaleSeconds, int minFreshSeconds, boolean onlyIfCached, boolean noTransform, boolean immutable, String headerValue, DefaultConstructorMarker $constructor_marker) {
        this((boolean)var1_1, (boolean)var2_2, (int)var3_3, sMaxAgeSeconds, isPrivate, isPublic, mustRevalidate, maxStaleSeconds, minFreshSeconds, onlyIfCached, noTransform, immutable, headerValue);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @SourceDebugExtension(value={"SMAP\nCacheControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheControl.kt\nokhttp3/CacheControl$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n1#2:417\n*E\n"})
    public static final class Builder {
        private boolean noCache;
        private boolean noStore;
        private int maxAgeSeconds = -1;
        private int maxStaleSeconds = -1;
        private int minFreshSeconds = -1;
        private boolean onlyIfCached;
        private boolean noTransform;
        private boolean immutable;

        public final Builder noCache() {
            Builder builder;
            Builder builder2 = builder = this;
            builder.noCache = true;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder maxStale(int maxStale, TimeUnit timeUnit) {
            void var2_3;
            long maxStaleSecondsLong;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            Builder $this$maxStale_u24lambda_u245 = builder = this;
            long l = maxStaleSecondsLong = var2_3.toSeconds(Integer.MAX_VALUE);
            var3_4.maxStaleSeconds = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            return builder;
        }

        public final Builder onlyIfCached() {
            Builder builder;
            Builder builder2 = builder = this;
            builder.onlyIfCached = true;
            return builder;
        }

        public final CacheControl build() {
            return new CacheControl(this.noCache, this.noStore, this.maxAgeSeconds, -1, false, false, false, this.maxStaleSeconds, this.minFreshSeconds, this.onlyIfCached, this.noTransform, this.immutable, null, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\r\u001a\u00020\u000b*\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010"}, d2={"Lokhttp3/CacheControl$Companion;", "", "<init>", "()V", "Lokhttp3/Headers;", "headers", "Lokhttp3/CacheControl;", "parse", "(Lokhttp3/Headers;)Lokhttp3/CacheControl;", "", "characters", "", "startIndex", "indexOfElement", "(Ljava/lang/String;Ljava/lang/String;I)I", "FORCE_CACHE", "Lokhttp3/CacheControl;", "FORCE_NETWORK"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final CacheControl parse(Headers headers) {
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            boolean noCache = false;
            boolean noStore = false;
            int maxAgeSeconds = -1;
            int sMaxAgeSeconds = -1;
            boolean isPrivate = false;
            boolean isPublic = false;
            boolean mustRevalidate = false;
            int maxStaleSeconds = -1;
            int minFreshSeconds = -1;
            boolean onlyIfCached = false;
            boolean noTransform = false;
            boolean immutable = false;
            boolean canUseHeaderValue = true;
            String headerValue = null;
            int n = headers.size();
            for (int i = 0; i < n; ++i) {
                String name = headers.name(i);
                String value = headers.value(i);
                if (StringsKt.equals((String)name, (String)"Cache-Control", (boolean)true)) {
                    if (headerValue != null) {
                        canUseHeaderValue = false;
                    } else {
                        headerValue = value;
                    }
                } else {
                    if (!StringsKt.equals((String)name, (String)"Pragma", (boolean)true)) continue;
                    canUseHeaderValue = false;
                }
                int pos = 0;
                while (pos < value.length()) {
                    String string;
                    int tokenStart = pos;
                    pos = okhttp3.CacheControl$Companion.indexOfElement(value, "=,;", pos);
                    String string2 = value.substring(tokenStart, pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String directive = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    if (pos == value.length() || value.charAt(pos) == ',' || value.charAt(pos) == ';') {
                        ++pos;
                        Object parameter = null;
                    } else {
                        ++pos;
                        if ((pos = Util.indexOfNonWhitespace(value, pos)) < value.length() && value.charAt(pos) == '\"') {
                            int parameterStart = ++pos;
                            pos = StringsKt.indexOf$default((CharSequence)value, (char)'\"', (int)pos, (boolean)false, (int)4, null);
                            Intrinsics.checkNotNullExpressionValue((Object)value.substring(parameterStart, pos), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            ++pos;
                        } else {
                            int parameterStart = pos;
                            pos = okhttp3.CacheControl$Companion.indexOfElement(value, ",;", pos);
                            String string3 = value.substring(parameterStart, pos);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                        }
                    }
                    if (StringsKt.equals((String)"no-cache", (String)directive, (boolean)true)) {
                        noCache = true;
                        continue;
                    }
                    if (StringsKt.equals((String)"no-store", (String)directive, (boolean)true)) {
                        noStore = true;
                        continue;
                    }
                    if (StringsKt.equals((String)"max-age", (String)directive, (boolean)true)) {
                        maxAgeSeconds = Util.toNonNegativeInt(string, -1);
                        continue;
                    }
                    if (StringsKt.equals((String)"s-maxage", (String)directive, (boolean)true)) {
                        sMaxAgeSeconds = Util.toNonNegativeInt(string, -1);
                        continue;
                    }
                    if (StringsKt.equals((String)"private", (String)directive, (boolean)true)) {
                        isPrivate = true;
                        continue;
                    }
                    if (StringsKt.equals((String)"public", (String)directive, (boolean)true)) {
                        isPublic = true;
                        continue;
                    }
                    if (StringsKt.equals((String)"must-revalidate", (String)directive, (boolean)true)) {
                        mustRevalidate = true;
                        continue;
                    }
                    if (StringsKt.equals((String)"max-stale", (String)directive, (boolean)true)) {
                        maxStaleSeconds = Util.toNonNegativeInt(string, Integer.MAX_VALUE);
                        continue;
                    }
                    if (StringsKt.equals((String)"min-fresh", (String)directive, (boolean)true)) {
                        minFreshSeconds = Util.toNonNegativeInt(string, -1);
                        continue;
                    }
                    if (StringsKt.equals((String)"only-if-cached", (String)directive, (boolean)true)) {
                        onlyIfCached = true;
                        continue;
                    }
                    if (StringsKt.equals((String)"no-transform", (String)directive, (boolean)true)) {
                        noTransform = true;
                        continue;
                    }
                    if (!StringsKt.equals((String)"immutable", (String)directive, (boolean)true)) continue;
                    immutable = true;
                }
            }
            if (!canUseHeaderValue) {
                headerValue = null;
            }
            return new CacheControl((boolean)var2_2, (boolean)var3_3, maxAgeSeconds, sMaxAgeSeconds, isPrivate, isPublic, mustRevalidate, maxStaleSeconds, minFreshSeconds, onlyIfCached, noTransform, immutable, headerValue, null);
        }

        private static int indexOfElement(String $this$indexOfElement, String characters, int startIndex) {
            String string;
            int n = $this$indexOfElement.length();
            for (int i = startIndex; i < n; ++i) {
                if (!StringsKt.contains$default((CharSequence)characters, (char)$this$indexOfElement.charAt(i), (boolean)false, (int)2, null)) continue;
                return i;
            }
            return string.length();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

