/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.util.AttributeKey;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.websocket.Frame;
import io.ktor.websocket.WebSocketDeflateExtensionKt;
import io.ktor.websocket.WebSocketExtension;
import io.ktor.websocket.WebSocketExtensionFactory;
import io.ktor.websocket.WebSocketExtensionHeader;
import io.ktor.websocket.internals.DeflaterUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002/.B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0014R.\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u00158\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\"\u0010$\u001a\u00020\t8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\"\u0010*\u001a\u00020\t8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010%\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u0016\u0010-\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010%"}, d2={"Lio/ktor/websocket/WebSocketDeflateExtension;", "Lio/ktor/websocket/WebSocketExtension;", "Lio/ktor/websocket/WebSocketDeflateExtension$Config;", "config", "<init>", "(Lio/ktor/websocket/WebSocketDeflateExtension$Config;)V", "", "Lio/ktor/websocket/WebSocketExtensionHeader;", "negotiatedProtocols", "", "clientNegotiation", "(Ljava/util/List;)Z", "requestedProtocols", "serverNegotiation", "(Ljava/util/List;)Ljava/util/List;", "Lio/ktor/websocket/Frame;", "frame", "processOutgoingFrame", "(Lio/ktor/websocket/Frame;)Lio/ktor/websocket/Frame;", "processIncomingFrame", "Lio/ktor/websocket/WebSocketDeflateExtension$Config;", "Lio/ktor/websocket/WebSocketExtensionFactory;", "factory", "Lio/ktor/websocket/WebSocketExtensionFactory;", "getFactory", "()Lio/ktor/websocket/WebSocketExtensionFactory;", "protocols", "Ljava/util/List;", "getProtocols", "()Ljava/util/List;", "Ljava/util/zip/Inflater;", "inflater", "Ljava/util/zip/Inflater;", "Ljava/util/zip/Deflater;", "deflater", "Ljava/util/zip/Deflater;", "outgoingNoContextTakeover", "Z", "getOutgoingNoContextTakeover$ktor_websockets", "()Z", "setOutgoingNoContextTakeover$ktor_websockets", "(Z)V", "incomingNoContextTakeover", "getIncomingNoContextTakeover$ktor_websockets", "setIncomingNoContextTakeover$ktor_websockets", "decompressIncoming", "Companion", "Config"})
@SourceDebugExtension(value={"SMAP\nWebSocketDeflateExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketDeflateExtension.kt\nio/ktor/websocket/WebSocketDeflateExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Attributes.kt\nio/ktor/util/AttributesKt\n+ 4 Type.kt\nio/ktor/util/reflect/TypeKt\n*L\n1#1,240:1\n1#2:241\n18#3:242\n58#4,16:243\n*S KotlinDebug\n*F\n+ 1 WebSocketDeflateExtension.kt\nio/ktor/websocket/WebSocketDeflateExtension\n*L\n229#1:242\n229#1:243,16\n*E\n"})
public final class WebSocketDeflateExtension
implements WebSocketExtension<Config> {
    public static final Companion Companion;
    private final Config config;
    private final WebSocketExtensionFactory<Config, ? extends WebSocketExtension<Config>> factory;
    private final List<WebSocketExtensionHeader> protocols;
    private final Inflater inflater;
    private final Deflater deflater;
    private boolean outgoingNoContextTakeover;
    private boolean incomingNoContextTakeover;
    private boolean decompressIncoming;
    private static final AttributeKey<WebSocketDeflateExtension> key;
    private static final boolean rsv1;
    private static final boolean rsv2;
    private static final boolean rsv3;

    /*
     * WARNING - void declaration
     */
    public WebSocketDeflateExtension(Config config) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = var1_1;
        this.factory = Companion;
        this.protocols = this.config.build$ktor_websockets();
        this.inflater = new Inflater(true);
        this.deflater = new Deflater(this.config.getCompressionLevel(), true);
    }

    @Override
    public final WebSocketExtensionFactory<Config, ? extends WebSocketExtension<Config>> getFactory() {
        return this.factory;
    }

    @Override
    public final List<WebSocketExtensionHeader> getProtocols() {
        return this.protocols;
    }

    public final boolean getOutgoingNoContextTakeover$ktor_websockets() {
        return this.outgoingNoContextTakeover;
    }

    /*
     * WARNING - void declaration
     */
    public final void setOutgoingNoContextTakeover$ktor_websockets(boolean bl) {
        void var1_1;
        this.outgoingNoContextTakeover = var1_1;
    }

    public final boolean getIncomingNoContextTakeover$ktor_websockets() {
        return this.incomingNoContextTakeover;
    }

    /*
     * WARNING - void declaration
     */
    public final void setIncomingNoContextTakeover$ktor_websockets(boolean bl) {
        void var1_1;
        this.incomingNoContextTakeover = var1_1;
    }

    @Override
    public final boolean clientNegotiation(List<WebSocketExtensionHeader> negotiatedProtocols) {
        Object object;
        Iterable iterable;
        Iterable iterable22;
        block21: {
            Intrinsics.checkNotNullParameter(negotiatedProtocols, (String)"negotiatedProtocols");
            iterable22 = (Iterable)negotiatedProtocols;
            for (Iterable iterable22 : iterable22) {
                negotiatedProtocols = (WebSocketExtensionHeader)((Object)iterable22);
                if (!Intrinsics.areEqual((Object)((WebSocketExtensionHeader)negotiatedProtocols).getName(), (Object)"permessage-deflate")) continue;
                iterable = iterable22;
                break block21;
            }
            iterable = null;
        }
        WebSocketExtensionHeader webSocketExtensionHeader = (WebSocketExtensionHeader)((Object)iterable);
        if (webSocketExtensionHeader == null) {
            return false;
        }
        WebSocketExtensionHeader protocol = webSocketExtensionHeader;
        this.incomingNoContextTakeover = this.config.getServerNoContextTakeOver();
        this.outgoingNoContextTakeover = this.config.getClientNoContextTakeOver();
        object = ((WebSocketExtensionHeader)object).parseParameters().iterator();
        while (object.hasNext()) {
            Pair pair = (Pair)object.next();
            String key = (String)pair.component1();
            String value = (String)pair.component2();
            int n = -1;
            switch (((String)((Object)iterable22)).hashCode()) {
                case 646404390: {
                    if (((String)((Object)iterable22)).equals("client_max_window_bits")) {
                        n = 1;
                    }
                    break;
                }
                case -708713803: {
                    if (((String)((Object)iterable22)).equals("client_no_context_takeover")) {
                        n = 2;
                    }
                    break;
                }
                case 1266201133: {
                    if (((String)((Object)iterable22)).equals("server_no_context_takeover")) {
                        n = 3;
                    }
                    break;
                }
                case 2034279582: {
                    if (((String)((Object)iterable22)).equals("server_max_window_bits")) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 4: {
                    break;
                }
                case 1: {
                    if (StringsKt.isBlank((CharSequence)value) || Integer.parseInt(value) == 15) break;
                    object = "Only 15 window size is supported.";
                    throw new IllegalStateException(object.toString());
                }
                case 3: {
                    if (!StringsKt.isBlank((CharSequence)value)) {
                        object = "WebSocket permessage-deflate extension parameter server_no_context_takeover shouldn't have a value. Current: " + value;
                        throw new IllegalStateException(object.toString());
                    }
                    this.incomingNoContextTakeover = true;
                    break;
                }
                case 2: {
                    if (!StringsKt.isBlank((CharSequence)value)) {
                        object = "WebSocket permessage-deflate extension parameter client_no_context_takeover shouldn't have a value. Current: " + (String)pair;
                        throw new IllegalStateException(object.toString());
                    }
                    this.outgoingNoContextTakeover = true;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final List<WebSocketExtensionHeader> serverNegotiation(List<WebSocketExtensionHeader> requestedProtocols) {
        void var2_10;
        Object object;
        Object v0;
        Object object2;
        block12: {
            Intrinsics.checkNotNullParameter(requestedProtocols, (String)"requestedProtocols");
            Iterable iterable = requestedProtocols;
            for (Object t : iterable) {
                object2 = (WebSocketExtensionHeader)t;
                if (!Intrinsics.areEqual((Object)((WebSocketExtensionHeader)object2).getName(), (Object)"permessage-deflate")) continue;
                v0 = t;
                break block12;
            }
            v0 = null;
        }
        WebSocketExtensionHeader webSocketExtensionHeader = v0;
        if (webSocketExtensionHeader == null) {
            return CollectionsKt.emptyList();
        }
        WebSocketExtensionHeader protocol = webSocketExtensionHeader;
        List parameters = new ArrayList();
        object = ((WebSocketExtensionHeader)object).parseParameters().iterator();
        block7: while (object.hasNext()) {
            String string;
            String key;
            block13: {
                Pair pair = (Pair)object.next();
                key = (String)pair.component1();
                string = (String)pair.component2();
                object2 = key;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string2 = ((String)object2).toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                object2 = string2;
                switch (string2.hashCode()) {
                    case 646404390: {
                        if (((String)object2).equals("client_max_window_bits")) continue block7;
                        throw new IllegalStateException(("Unsupported extension parameter: (" + key + ", " + string + ')').toString());
                    }
                    case -708713803: {
                        if (!((String)object2).equals("client_no_context_takeover")) {
                            throw new IllegalStateException(("Unsupported extension parameter: (" + key + ", " + string + ')').toString());
                        }
                        break block13;
                    }
                    case 1266201133: {
                        if (((String)object2).equals("server_no_context_takeover")) break;
                        throw new IllegalStateException(("Unsupported extension parameter: (" + key + ", " + string + ')').toString());
                    }
                    case 2034279582: {
                        if (!((String)object2).equals("server_max_window_bits")) throw new IllegalStateException(("Unsupported extension parameter: (" + key + ", " + string + ')').toString());
                        if (Integer.parseInt(string) == 15) continue block7;
                        object = "Only 15 window size is supported";
                        throw new IllegalStateException(object.toString());
                    }
                }
                if (!StringsKt.isBlank((CharSequence)string)) {
                    object = "Check failed.";
                    throw new IllegalStateException(object.toString());
                }
                this.outgoingNoContextTakeover = true;
                parameters.add("server_no_context_takeover");
                continue;
            }
            if (!StringsKt.isBlank((CharSequence)string)) {
                object = "Check failed.";
                throw new IllegalStateException(object.toString());
            }
            this.incomingNoContextTakeover = true;
            parameters.add("client_no_context_takeover");
            continue;
            throw new IllegalStateException(("Unsupported extension parameter: (" + key + ", " + string + ')').toString());
        }
        return CollectionsKt.listOf((Object)new WebSocketExtensionHeader("permessage-deflate", (List<String>)var2_10));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Frame processOutgoingFrame(Frame frame) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (!(frame instanceof Frame.Text) && !(frame instanceof Frame.Binary)) {
            return frame;
        }
        if (!((Boolean)this.config.getCompressCondition$ktor_websockets().invoke((Object)frame)).booleanValue()) {
            return frame;
        }
        byte[] deflated = DeflaterUtilsKt.deflateFully(this.deflater, frame.getData());
        if (this.outgoingNoContextTakeover) {
            this.deflater.reset();
        }
        return Frame.Companion.byType(frame.getFin(), frame.getFrameType(), (byte[])var2_2, rsv1, frame.getRsv2(), var1_1.getRsv3());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Frame processIncomingFrame(Frame frame) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (!WebSocketDeflateExtensionKt.access$isCompressed(frame) && !this.decompressIncoming) {
            return frame;
        }
        this.decompressIncoming = true;
        byte[] inflated = DeflaterUtilsKt.inflateFully(this.inflater, frame.getData());
        if (this.incomingNoContextTakeover) {
            this.inflater.reset();
        }
        if (frame.getFin()) {
            this.decompressIncoming = false;
        }
        return Frame.Companion.byType(frame.getFin(), frame.getFrameType(), (byte[])var2_2, !rsv1, frame.getRsv2(), var1_1.getRsv3());
    }

    static {
        KType kType;
        Companion = new Companion(null);
        String string = "WebsocketDeflateExtension";
        string = "WebsocketDeflateExtension";
        Object object = Reflection.getOrCreateKotlinClass(WebSocketDeflateExtension.class);
        try {
            kType = Reflection.typeOf(WebSocketDeflateExtension.class);
        }
        catch (Throwable throwable) {
            kType = null;
        }
        KClass kClass = object;
        object = kType;
        kType = kClass;
        string = new TypeInfo((KClass)kType, (KType)object);
        object = string;
        key = new AttributeKey((String)object, (TypeInfo)string);
        rsv1 = true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\n\u001a\u00020\u00032\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\b\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\f8\u0016X\u0097\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\u00118\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u00118\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0018\u001a\u00020\u00118\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0019\u0010\u0015"}, d2={"Lio/ktor/websocket/WebSocketDeflateExtension$Companion;", "Lio/ktor/websocket/WebSocketExtensionFactory;", "Lio/ktor/websocket/WebSocketDeflateExtension$Config;", "Lio/ktor/websocket/WebSocketDeflateExtension;", "<init>", "()V", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "config", "install", "(Lkotlin/jvm/functions/Function1;)Lio/ktor/websocket/WebSocketDeflateExtension;", "Lio/ktor/util/AttributeKey;", "key", "Lio/ktor/util/AttributeKey;", "getKey", "()Lio/ktor/util/AttributeKey;", "", "rsv1", "Z", "getRsv1", "()Z", "rsv2", "getRsv2", "rsv3", "getRsv3"})
    public static final class Companion
    implements WebSocketExtensionFactory<Config, WebSocketDeflateExtension> {
        private Companion() {
        }

        @Override
        public final AttributeKey<WebSocketDeflateExtension> getKey() {
            return key;
        }

        @Override
        public final boolean getRsv1() {
            return rsv1;
        }

        @Override
        public final boolean getRsv2() {
            return rsv2;
        }

        @Override
        public final boolean getRsv3() {
            return rsv3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final WebSocketDeflateExtension install(Function1<? super Config, Unit> config) {
            void var1_1;
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Config config2 = new Config();
            var1_1.invoke((Object)config2);
            return new WebSocketDeflateExtension(config2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0019\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\f\u001a\u00020\n2'\u0010\u000b\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\u0004\b\f\u0010\rJ0\u0010\u0011\u001a\u00020\n2!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0004\u00a2\u0006\u0004\b\u0011\u0010\rJ\u0015\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018R\"\u0010\u001a\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010\u001b\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\"\u0010#\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010\u0015R4\u0010(\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\n0\u00048\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010\rR.\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100\u00048\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010)\u001a\u0004\b.\u0010+\"\u0004\b/\u0010\r"}, d2={"Lio/ktor/websocket/WebSocketDeflateExtension$Config;", "", "<init>", "()V", "Lkotlin/Function1;", "", "Lio/ktor/websocket/WebSocketExtensionHeader;", "Lkotlin/ParameterName;", "name", "protocols", "", "block", "configureProtocols", "(Lkotlin/jvm/functions/Function1;)V", "Lio/ktor/websocket/Frame;", "frame", "", "compressIf", "", "bytes", "compressIfBiggerThan", "(I)V", "", "build$ktor_websockets", "()Ljava/util/List;", "build", "clientNoContextTakeOver", "Z", "getClientNoContextTakeOver", "()Z", "setClientNoContextTakeOver", "(Z)V", "serverNoContextTakeOver", "getServerNoContextTakeOver", "setServerNoContextTakeOver", "compressionLevel", "I", "getCompressionLevel", "()I", "setCompressionLevel", "manualConfig", "Lkotlin/jvm/functions/Function1;", "getManualConfig$ktor_websockets", "()Lkotlin/jvm/functions/Function1;", "setManualConfig$ktor_websockets", "compressCondition", "getCompressCondition$ktor_websockets", "setCompressCondition$ktor_websockets"})
    public static final class Config {
        private boolean clientNoContextTakeOver;
        private boolean serverNoContextTakeOver;
        private int compressionLevel = -1;
        private Function1<? super List<WebSocketExtensionHeader>, Unit> manualConfig = Config::manualConfig$lambda$0;
        private Function1<? super Frame, Boolean> compressCondition = Config::compressCondition$lambda$1;

        public final boolean getClientNoContextTakeOver() {
            return this.clientNoContextTakeOver;
        }

        /*
         * WARNING - void declaration
         */
        public final void setClientNoContextTakeOver(boolean bl) {
            void var1_1;
            this.clientNoContextTakeOver = var1_1;
        }

        public final boolean getServerNoContextTakeOver() {
            return this.serverNoContextTakeOver;
        }

        /*
         * WARNING - void declaration
         */
        public final void setServerNoContextTakeOver(boolean bl) {
            void var1_1;
            this.serverNoContextTakeOver = var1_1;
        }

        public final int getCompressionLevel() {
            return this.compressionLevel;
        }

        /*
         * WARNING - void declaration
         */
        public final void setCompressionLevel(int n) {
            void var1_1;
            this.compressionLevel = var1_1;
        }

        public final Function1<List<WebSocketExtensionHeader>, Unit> getManualConfig$ktor_websockets() {
            return this.manualConfig;
        }

        /*
         * WARNING - void declaration
         */
        public final void setManualConfig$ktor_websockets(Function1<? super List<WebSocketExtensionHeader>, Unit> function1) {
            void var1_1;
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.manualConfig = var1_1;
        }

        public final Function1<Frame, Boolean> getCompressCondition$ktor_websockets() {
            return this.compressCondition;
        }

        /*
         * WARNING - void declaration
         */
        public final void setCompressCondition$ktor_websockets(Function1<? super Frame, Boolean> function1) {
            void var1_1;
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.compressCondition = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void configureProtocols(Function1<? super List<WebSocketExtensionHeader>, Unit> block) {
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Function1<? super List<WebSocketExtensionHeader>, Unit> old = this.manualConfig;
            this.manualConfig = arg_0 -> Config.configureProtocols$lambda$2((Function1)var2_2, (Function1)var1_1, arg_0);
        }

        /*
         * WARNING - void declaration
         */
        public final void compressIf(Function1<? super Frame, Boolean> block) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Function1<? super Frame, Boolean> old = this.compressCondition;
            this.compressCondition = arg_0 -> Config.compressIf$lambda$3((Function1)var1_1, (Function1)var2_2, arg_0);
        }

        /*
         * WARNING - void declaration
         */
        public final void compressIfBiggerThan(int bytes) {
            void var1_1;
            this.compressIf((Function1<? super Frame, Boolean>)((Function1)arg_0 -> Config.compressIfBiggerThan$lambda$4((int)var1_1, arg_0)));
        }

        /*
         * WARNING - void declaration
         */
        public final List<WebSocketExtensionHeader> build$ktor_websockets() {
            void var1_1;
            void var2_2;
            List result = new ArrayList();
            List parameters = new ArrayList();
            if (this.clientNoContextTakeOver) {
                ((Collection)parameters).add("client_no_context_takeover");
            }
            if (this.serverNoContextTakeOver) {
                ((Collection)parameters).add("server_no_context_takeover");
            }
            ((Collection)result).add(new WebSocketExtensionHeader("permessage-deflate", (List<String>)var2_2));
            this.manualConfig.invoke((Object)result);
            return var1_1;
        }

        private static final Unit manualConfig$lambda$0(List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final boolean compressCondition$lambda$1(Frame it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit configureProtocols$lambda$2(Function1 $old, Function1 $block, List it) {
            void var2_2;
            void var1_1;
            Function1 function1;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            function1.invoke((Object)it);
            var1_1.invoke((Object)var2_2);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean compressIf$lambda$3(Function1 $block, Function1 $old, Frame it) {
            void var2_2;
            void var1_1;
            Function1 function1;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Boolean)function1.invoke((Object)it) != false && (Boolean)var1_1.invoke((Object)var2_2) != false;
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean compressIfBiggerThan$lambda$4(int $bytes, Frame frame) {
            int n;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            return var1_1.getData().length > n;
        }
    }
}

