/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.modules.SerializersModuleCollector;

public final class PolymorphismValidator
implements SerializersModuleCollector {
    private final boolean useArrayPolymorphism;
    private final String discriminator;

    /*
     * WARNING - void declaration
     */
    public PolymorphismValidator(boolean useArrayPolymorphism, String discriminator) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)discriminator, (String)"discriminator");
        this.useArrayPolymorphism = var1_1;
        this.discriminator = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final <Base, Sub extends Base> void polymorphic(KClass<Base> baseClass, KClass<Sub> actualClass, KSerializer<Sub> actualSerializer) {
        PolymorphismValidator polymorphismValidator;
        Intrinsics.checkNotNullParameter(baseClass, (String)"baseClass");
        Intrinsics.checkNotNullParameter(actualClass, (String)"actualClass");
        Intrinsics.checkNotNullParameter(actualSerializer, (String)"actualSerializer");
        SerialDescriptor descriptor = polymorphismValidator.getDescriptor();
        KClass<Sub> kClass = actualClass;
        SerialDescriptor serialDescriptor = descriptor;
        polymorphismValidator = this;
        SerialKind serialKind = serialDescriptor.getKind();
        if (serialKind instanceof PolymorphicKind || Intrinsics.areEqual((Object)serialKind, (Object)SerialKind.CONTEXTUAL.INSTANCE)) {
            throw new IllegalArgumentException("Serializer for " + kClass.getSimpleName() + " can't be registered as a subclass for polymorphic serialization because its kind " + serialKind + " is not concrete. To work with multiple hierarchies, register it as a base class.");
        }
        if (!polymorphismValidator.useArrayPolymorphism && (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE) || serialKind instanceof PrimitiveKind || serialKind instanceof SerialKind.ENUM)) {
            throw new IllegalArgumentException("Serializer for " + kClass.getSimpleName() + " of kind " + serialKind + " cannot be serialized polymorphically with class discriminator.");
        }
        if (!this.useArrayPolymorphism) {
            void var1_1;
            String string;
            kClass = string;
            serialDescriptor = var1_1;
            polymorphismValidator = this;
            int n = serialDescriptor.getElementsCount();
            for (int i = 0; i < n; ++i) {
                string = serialDescriptor.getElementName(i);
                if (!Intrinsics.areEqual((Object)string, (Object)polymorphismValidator.discriminator)) continue;
                throw new IllegalArgumentException("Polymorphic serializer for " + kClass + " has property '" + string + "' that conflicts with JSON class discriminator. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <Base> void polymorphicDefaultSerializer(KClass<Base> baseClass, Function1<? super Base, ? extends SerializationStrategy<? super Base>> defaultSerializerProvider) {
        void var2_2;
        Intrinsics.checkNotNullParameter(baseClass, (String)"baseClass");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"defaultSerializerProvider");
    }

    /*
     * WARNING - void declaration
     */
    public final <Base> void polymorphicDefaultDeserializer(KClass<Base> baseClass, Function1<? super String, ? extends DeserializationStrategy<? extends Base>> defaultDeserializerProvider) {
        void var2_2;
        Intrinsics.checkNotNullParameter(baseClass, (String)"baseClass");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"defaultDeserializerProvider");
    }
}

