/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.internal.ByteArrayPool8k;

public final class CharsetReader {
    private final InputStream inputStream;
    private final Charset charset;
    private final CharsetDecoder decoder;
    private final ByteBuffer byteBuffer;
    private boolean hasLeftoverPotentiallySurrogateChar;
    private char leftoverChar;

    /*
     * WARNING - void declaration
     */
    public CharsetReader(InputStream inputStream, Charset charset) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.inputStream = var1_1;
        this.charset = var2_2;
        this.decoder = this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.byteBuffer = ByteBuffer.wrap(ByteArrayPool8k.INSTANCE.take());
        this.byteBuffer.flip();
    }

    /*
     * WARNING - void declaration
     */
    public final int read(char[] array, int offset, int length22) {
        void var1_1;
        boolean bl;
        void var3_5;
        int length22;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (length22 == 0) {
            return 0;
        }
        if (!((offset >= 0 ? offset < array.length : false) && length22 >= 0 && offset + length22 <= array.length)) {
            String length22 = "Unexpected arguments: " + offset + ", " + length22 + ", " + array.length;
            throw new IllegalArgumentException(length22.toString());
        }
        int bytesRead = 0;
        if (this.hasLeftoverPotentiallySurrogateChar) {
            array[offset] = this.leftoverChar;
            ++offset;
            this.hasLeftoverPotentiallySurrogateChar = false;
            bytesRead = 1;
            if (--length22 == 0) {
                return 1;
            }
        }
        if (length22 == 1) {
            void var3_8;
            int n;
            CharsetReader length3 = this;
            if (length3.hasLeftoverPotentiallySurrogateChar) {
                length3.hasLeftoverPotentiallySurrogateChar = false;
                n = length3.leftoverChar;
            } else {
                char[] cArray = new char[2];
                int n2 = length3.read(cArray, 0, 2);
                switch (n2) {
                    case -1: {
                        n = -1;
                        break;
                    }
                    case 1: {
                        n = cArray[0];
                        break;
                    }
                    case 2: {
                        length3.leftoverChar = cArray[1];
                        length3.hasLeftoverPotentiallySurrogateChar = true;
                        n = cArray[0];
                        break;
                    }
                    default: {
                        throw new IllegalStateException(("Unreachable state: " + n2).toString());
                    }
                }
            }
            int c = n;
            if (n == -1) {
                if (bytesRead == 0) {
                    return -1;
                }
                return 1;
            }
            array[offset] = (char)var3_8;
            return bytesRead + 1;
        }
        void var1_2 = var3_5;
        void var6_17 = bl;
        void var5_12 = var1_1;
        CharsetReader charsetReader = this;
        CharSequence charSequence = CharBuffer.wrap((char[])var5_12, (int)var6_17, (int)var1_2);
        if (charSequence.position() != 0) {
            charSequence = charSequence.slice();
        }
        bl = false;
        while (true) {
            CoderResult coderResult;
            if ((coderResult = charsetReader.decoder.decode(charsetReader.byteBuffer, (CharBuffer)charSequence, bl)).isUnderflow()) {
                if (bl || !charSequence.hasRemaining()) break;
                int n = charsetReader.fillByteBuffer();
                if (n >= 0) continue;
                bl = true;
                if (charSequence.position() == 0 && !charsetReader.byteBuffer.hasRemaining()) break;
                charsetReader.decoder.reset();
                continue;
            }
            if (coderResult.isOverflow()) {
                boolean bl2;
                boolean bl3 = bl2 = charSequence.position() > 0;
                if (!_Assertions.ENABLED || bl2) break;
                charSequence = "Assertion failed";
                throw new AssertionError(charSequence);
            }
            coderResult.throwException();
        }
        if (bl) {
            charsetReader.decoder.reset();
        }
        return (charSequence.position() == 0 ? -1 : charSequence.position()) + bytesRead;
    }

    /*
     * WARNING - void declaration
     */
    private final int fillByteBuffer() {
        this.byteBuffer.compact();
        try {
            void var1_1;
            void var2_2;
            int limit = this.byteBuffer.limit();
            int position = this.byteBuffer.position();
            int remaining = position <= limit ? limit - position : 0;
            int bytesRead = this.inputStream.read(this.byteBuffer.array(), this.byteBuffer.arrayOffset() + position, remaining);
            if (bytesRead < 0) {
                return bytesRead;
            }
            ByteBuffer byteBuffer = this.byteBuffer;
            Intrinsics.checkNotNull((Object)byteBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)byteBuffer).position((int)(var2_2 + var1_1));
        }
        finally {
            this.byteBuffer.flip();
        }
        return this.byteBuffer.remaining();
    }

    public final void release() {
        byte[] byArray = this.byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        ByteArrayPool8k.INSTANCE.release(byArray);
    }
}

