/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.CharMappings;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonPath;

@SourceDebugExtension(value={"SMAP\nAbstractJsonLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,747:1\n739#1,5:748\n1#2:753\n*S KotlinDebug\n*F\n+ 1 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n*L\n216#1:748,5\n*E\n"})
public abstract class AbstractJsonLexer {
    @JvmField
    public int currentPosition;
    @JvmField
    public final JsonPath path = new JsonPath();
    private String peekedString;
    private StringBuilder escapedString = new StringBuilder();

    protected abstract CharSequence getSource();

    public void ensureHaveChars() {
    }

    public final boolean isNotEof() {
        return this.peekNextToken() != 10;
    }

    public abstract int prefetchOrEof(int var1);

    public abstract boolean canConsumeValue();

    public abstract byte consumeNextToken();

    /*
     * WARNING - void declaration
     */
    public final boolean tryConsumeComma() {
        void var1_1;
        void var2_2;
        CharSequence source;
        int current = this.skipWhitespaces();
        if (current >= (source = this.getSource()).length() || current == -1) {
            return false;
        }
        if (var2_2.charAt((int)var1_1) == ',') {
            ++this.currentPosition;
            return true;
        }
        return false;
    }

    protected static boolean isValidValueStart(char c) {
        switch (c) {
            case ',': 
            case ':': 
            case ']': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    public final void expectEof() {
        byte by = this.consumeNextToken();
        if (by != 10) {
            AbstractJsonLexer.fail$default(this, "Expected EOF after parsing, but had " + this.getSource().charAt(this.currentPosition - 1) + " instead", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
    }

    protected final StringBuilder getEscapedString() {
        return this.escapedString;
    }

    /*
     * WARNING - void declaration
     */
    public final byte consumeNextToken(byte expected) {
        void var2_5;
        byte token = this.consumeNextToken();
        if (token != expected) {
            void var1_1;
            Object var1_2 = null;
            int n = 2;
            n = 0;
            token = var1_1;
            AbstractJsonLexer abstractJsonLexer = this;
            abstractJsonLexer.fail$kotlinx_serialization_json(token, true);
            throw new KotlinNothingValueException();
        }
        return (byte)var2_5;
    }

    public abstract void consumeNextToken(char var1);

    /*
     * WARNING - void declaration
     */
    protected final void unexpectedToken(char expected) {
        void var1_1;
        if (this.currentPosition > 0 && expected == '\"') {
            String string;
            AbstractJsonLexer this_$iv = this;
            int snapshot$iv = this_$iv.currentPosition;
            try {
                int n = this.currentPosition;
                this.currentPosition = n + -1;
                string = this.consumeStringLenient();
                this_$iv.currentPosition = snapshot$iv;
            }
            catch (Throwable throwable) {
                void var3_7;
                ((AbstractJsonLexer)((Object)string2)).currentPosition = var3_7;
                throw throwable;
            }
            String string2 = string;
            if (Intrinsics.areEqual((Object)string2, (Object)"null")) {
                this.fail("Expected string literal but 'null' literal was found", this.currentPosition - 1, "Use 'coerceInputValues = true' in 'Json {}' builder to coerce nulls if property has a default value.");
                throw new KotlinNothingValueException();
            }
        }
        Object var1_2 = null;
        int n = 2;
        n = 0;
        byte by = AbstractJsonLexerKt.charToTokenClass((char)var1_1);
        AbstractJsonLexer abstractJsonLexer = this;
        abstractJsonLexer.fail$kotlinx_serialization_json(by, true);
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    public final Void fail$kotlinx_serialization_json(byte expectedToken, boolean wasConsumed) {
        void var2_3;
        void var3_4;
        void var1_2;
        String expected = AbstractJsonLexerKt.tokenDescription(expectedToken);
        int position = wasConsumed ? this.currentPosition - 1 : this.currentPosition;
        String s = this.currentPosition == this.getSource().length() || position < 0 ? "EOF" : String.valueOf(this.getSource().charAt(position));
        AbstractJsonLexer.fail$default(this, "Expected " + (String)var1_2 + ", but had '" + (String)var3_4 + "' instead", (int)var2_3, null, 4, null);
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Void fail$kotlinx_serialization_json$default(AbstractJsonLexer abstractJsonLexer, byte by, boolean bl, int n, Object object) {
        return abstractJsonLexer.fail$kotlinx_serialization_json(by, true);
    }

    /*
     * WARNING - void declaration
     */
    public byte peekNextToken() {
        void var2_2;
        CharSequence source = this.getSource();
        int cpos = this.currentPosition;
        block3: while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            void var3_3;
            char ch = source.charAt(cpos);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++cpos;
                    continue block3;
                }
            }
            this.currentPosition = cpos;
            return AbstractJsonLexerKt.charToTokenClass((char)var3_3);
        }
        this.currentPosition = var2_2;
        return 10;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryConsumeNull(boolean doConsume) {
        void var1_1;
        void var3_3;
        int current = this.skipWhitespaces();
        current = this.prefetchOrEof(current);
        int len = this.getSource().length() - current;
        if (len < 4 || current == -1) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if ("null".charAt(i) == this.getSource().charAt(current + i)) continue;
            return false;
        }
        if (var3_3 > 4 && AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current + 4)) == 0) {
            return false;
        }
        if (var1_1 != false) {
            void var2_2;
            this.currentPosition = var2_2 + 4;
        }
        return true;
    }

    public static /* synthetic */ boolean tryConsumeNull$default(AbstractJsonLexer abstractJsonLexer, boolean bl, int n, Object object) {
        return abstractJsonLexer.tryConsumeNull(true);
    }

    public abstract int skipWhitespaces();

    public abstract String peekLeadingMatchingValue(String var1, boolean var2);

    /*
     * WARNING - void declaration
     */
    public final String peekString(boolean isLenient) {
        void var1_2;
        String string;
        String string2;
        byte token = this.peekNextToken();
        if (isLenient) {
            if (token != 1 && token != 0) {
                return null;
            }
            string2 = this.consumeStringLenient();
        } else {
            void var2_3;
            if (var2_3 != true) {
                return null;
            }
            string2 = this.consumeString();
        }
        this.peekedString = string = string2;
        return var1_2;
    }

    public final void discardPeeked() {
        this.peekedString = null;
    }

    /*
     * WARNING - void declaration
     */
    public String substring(int startPos, int endPos) {
        void var2_2;
        void var1_1;
        return ((Object)this.getSource().subSequence((int)var1_1, (int)var2_2)).toString();
    }

    public abstract String consumeKeyString();

    public final String consumeString() {
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        return this.consumeKeyString();
    }

    /*
     * WARNING - void declaration
     */
    protected final String consumeString(CharSequence source, int startPosition, int current) {
        void var1_1;
        void var3_4;
        void var2_2;
        int lastPosition342;
        char c;
        int currentPosition;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        char c2 = source.charAt(currentPosition);
        boolean usedAppend = false;
        while (c != '\"') {
            if (c == '\\') {
                int n;
                usedAppend = true;
                AbstractJsonLexer abstractJsonLexer = this;
                c = currentPosition;
                currentPosition = lastPosition342;
                AbstractJsonLexer lastPosition342 = abstractJsonLexer;
                abstractJsonLexer.appendRange(currentPosition, c);
                currentPosition = c + '\u0001';
                currentPosition = lastPosition342.prefetchOrEof(currentPosition);
                if (currentPosition == -1) {
                    AbstractJsonLexer.fail$default(lastPosition342, "Expected escape sequence to continue, got EOF", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                c = lastPosition342.getSource().charAt(currentPosition++);
                if (c == 'u') {
                    AbstractJsonLexer abstractJsonLexer2 = lastPosition342;
                    n = abstractJsonLexer2.appendHex(abstractJsonLexer2.getSource(), currentPosition);
                } else {
                    char c3 = c;
                    c3 = c3 < 'u' ? CharMappings.ESCAPE_2_CHAR[c3] : (char)'\u0000';
                    if (c3 == '\u0000') {
                        AbstractJsonLexer.fail$default(lastPosition342, "Invalid escaped char '" + c + '\'', 0, null, 6, null);
                        throw new KotlinNothingValueException();
                    }
                    lastPosition342.escapedString.append(c3);
                    n = currentPosition;
                }
                currentPosition = abstractJsonLexer.prefetchOrEof(n);
                if (currentPosition == -1) {
                    AbstractJsonLexer.fail$default(this, "Unexpected EOF", currentPosition, null, 4, null);
                    throw new KotlinNothingValueException();
                }
                lastPosition342 = currentPosition;
            } else if (++currentPosition >= source.length()) {
                usedAppend = true;
                this.appendRange(lastPosition342, currentPosition);
                currentPosition = this.prefetchOrEof(currentPosition);
                if (currentPosition == -1) {
                    AbstractJsonLexer.fail$default(this, "Unexpected EOF", currentPosition, null, 4, null);
                    throw new KotlinNothingValueException();
                }
                lastPosition342 = currentPosition;
            }
            c = source.charAt(currentPosition);
        }
        String string = !usedAppend ? this.substring(lastPosition342, currentPosition) : this.decodedString((int)var2_2, currentPosition);
        this.currentPosition = var3_4 + true;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final String decodedString(int lastPosition, int currentPosition) {
        void var1_2;
        void var2_3;
        this.appendRange(lastPosition, (int)var2_3);
        String string = this.escapedString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String result = string;
        this.escapedString.setLength(0);
        return var1_2;
    }

    private final String takePeeked() {
        String string = this.peekedString;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        this.peekedString = null;
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public final String consumeStringLenientNotNull() {
        void var1_1;
        AbstractJsonLexer abstractJsonLexer;
        String result = this.consumeStringLenient();
        if (Intrinsics.areEqual((Object)result, (Object)"null") && (abstractJsonLexer = this).getSource().charAt(abstractJsonLexer.currentPosition - 1) != '\"') {
            AbstractJsonLexer.fail$default(this, "Unexpected 'null' value instead of string literal", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String consumeStringLenient() {
        void var3_4;
        void var1_1;
        String string;
        void var2_2;
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", current, null, 4, null);
            throw new KotlinNothingValueException();
        }
        byte token = AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current));
        if (token == 1) {
            return this.consumeString();
        }
        if (token != 0) {
            AbstractJsonLexer.fail$default(this, "Expected beginning of the string, but got " + this.getSource().charAt(current), 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        boolean usedAppend = false;
        while (AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current)) == 0) {
            if (++current < this.getSource().length()) continue;
            usedAppend = true;
            AbstractJsonLexer abstractJsonLexer = this;
            abstractJsonLexer.appendRange(abstractJsonLexer.currentPosition, current);
            int eof = this.prefetchOrEof(current);
            if (eof == -1) {
                this.currentPosition = current;
                return this.decodedString(0, 0);
            }
            current = eof;
        }
        if (var2_2 == false) {
            AbstractJsonLexer abstractJsonLexer = this;
            string = abstractJsonLexer.substring(abstractJsonLexer.currentPosition, current);
        } else {
            AbstractJsonLexer abstractJsonLexer = this;
            string = abstractJsonLexer.decodedString(abstractJsonLexer.currentPosition, current);
        }
        String result = string;
        this.currentPosition = var1_1;
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    protected void appendRange(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        this.escapedString.append(this.getSource(), (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final int appendHex(CharSequence source, int startPos) {
        void var2_2;
        void var1_1;
        while (startPos + 4 >= source.length()) {
            this.currentPosition = startPos;
            this.ensureHaveChars();
            if (this.currentPosition + 4 >= source.length()) {
                AbstractJsonLexer.fail$default(this, "Unexpected EOF during unicode escape", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            startPos = this.currentPosition;
        }
        this.escapedString.append((char)((this.fromHexChar(source, startPos) << 12) + (this.fromHexChar(source, startPos + 1) << 8) + (this.fromHexChar(source, startPos + 2) << 4) + this.fromHexChar((CharSequence)var1_1, startPos + 3)));
        return (int)(var2_2 + 4);
    }

    /*
     * WARNING - void declaration
     */
    private final int fromHexChar(CharSequence source, int currentPosition) {
        void var1_2;
        void var2_3;
        char character = source.charAt((int)var2_3);
        boolean bl = '0' <= character ? character < ':' : false;
        if (bl) {
            return character - 48;
        }
        boolean bl2 = 'a' <= character ? character < 'g' : false;
        if (bl2) {
            return character - 97 + 10;
        }
        boolean bl3 = 'A' <= character ? character < 'G' : false;
        if (bl3) {
            return character - 65 + 10;
        }
        AbstractJsonLexer.fail$default(this, "Invalid toHexChar char '" + (char)var1_2 + "' in unicode escape", 0, null, 6, null);
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    public final void skipElement(boolean allowLenientStrings) {
        List tokenStack = new ArrayList();
        byte lastToken = this.peekNextToken();
        if (lastToken != 8 && lastToken != 6) {
            this.consumeStringLenient();
            return;
        }
        while (true) {
            if ((lastToken = this.peekNextToken()) == 1) {
                if (allowLenientStrings) {
                    this.consumeStringLenient();
                    continue;
                }
                this.consumeKeyString();
                continue;
            }
            byte by = lastToken;
            if (by == 8 || by == 6) {
                void var3_3;
                tokenStack.add((byte)var3_3);
            } else if (by == 9) {
                if (((Number)CollectionsKt.last((List)tokenStack)).byteValue() != 8) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found ] instead of } at path: " + this.path, this.getSource());
                }
                CollectionsKt.removeLast((List)tokenStack);
            } else if (by == 7) {
                if (((Number)CollectionsKt.last((List)tokenStack)).byteValue() != 6) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found } instead of ] at path: " + this.path, this.getSource());
                }
                CollectionsKt.removeLast((List)tokenStack);
            } else if (by == 10) {
                AbstractJsonLexer.fail$default(this, "Unexpected end of input due to malformed JSON during ignoring unknown keys", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            this.consumeNextToken();
            if (tokenStack.size() == 0) break;
        }
    }

    public String toString() {
        return "JsonReader(source='" + this.getSource() + "', currentPosition=" + this.currentPosition + ')';
    }

    /*
     * WARNING - void declaration
     */
    public final void failOnUnknownKey(String key) {
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.substring(0, this.currentPosition);
        int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)string, (String)key, (int)0, (boolean)false, (int)6, null);
        this.fail("Encountered an unknown key '" + (String)var1_1 + '\'', (int)var2_3, "Use 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.");
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    public final Void fail(String message, int position, String hint) {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        String hintMessage = ((CharSequence)hint).length() == 0 ? "" : "\n" + hint;
        throw JsonExceptionsKt.JsonDecodingException((int)var2_2, (String)var1_1 + " at path: " + this.path.getPath() + (String)var3_3, this.getSource());
    }

    public static /* synthetic */ Void fail$default(AbstractJsonLexer abstractJsonLexer, String string, int n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = abstractJsonLexer.currentPosition;
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        return abstractJsonLexer.fail(string, n, string2);
    }

    /*
     * WARNING - void declaration
     */
    public final long consumeNumericLiteral() {
        boolean bl;
        void var2_2;
        boolean hasChars;
        boolean bl2;
        int current = this.skipWhitespaces();
        if ((current = this.prefetchOrEof(current)) >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        if (this.getSource().charAt(current) == '\"') {
            if (++current == this.getSource().length()) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            bl2 = true;
        } else {
            bl2 = false;
        }
        boolean hasQuotation = bl2;
        long accumulator = 0L;
        long exponentAccumulator = 0L;
        boolean isNegative = false;
        boolean isExponentPositive = false;
        boolean hasExponent = false;
        int start = current;
        while (current != this.getSource().length()) {
            char ch = this.getSource().charAt(current);
            if (!(ch != 'e' && ch != 'E' || hasExponent)) {
                if (current == start) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol " + ch + " in numeric literal", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                isExponentPositive = true;
                hasExponent = true;
                ++current;
                continue;
            }
            if (ch == '-' && hasExponent) {
                if (current == start) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol '-' in numeric literal", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                isExponentPositive = false;
                ++current;
                continue;
            }
            if (ch == '+' && hasExponent) {
                if (current == start) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol '+' in numeric literal", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                isExponentPositive = true;
                ++current;
                continue;
            }
            if (ch == '-') {
                if (current != start) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol '-' in numeric literal", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                isNegative = true;
                ++current;
                continue;
            }
            byte by = AbstractJsonLexerKt.charToTokenClass(ch);
            if (by != 0) break;
            ++current;
            int digit = ch - 48;
            if (!(digit >= 0 ? digit < 10 : false)) {
                AbstractJsonLexer.fail$default(this, "Unexpected symbol '" + ch + "' in numeric literal", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (hasExponent) {
                exponentAccumulator = exponentAccumulator * 10L + (long)digit;
                continue;
            }
            if ((accumulator = accumulator * 10L - (long)digit) <= 0L) continue;
            AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        boolean bl3 = hasChars = current != start;
        if (start == current || isNegative && start == current - 1) {
            AbstractJsonLexer.fail$default(this, "Expected numeric literal", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        if (var2_2 != false) {
            if (!hasChars) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (this.getSource().charAt(current) != '\"') {
                AbstractJsonLexer.fail$default(this, "Expected closing quotation mark", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            ++current;
        }
        this.currentPosition = bl;
        if (hasExponent) {
            double d;
            double d2 = accumulator;
            bl = isExponentPositive;
            long l = exponentAccumulator;
            if (!bl) {
                d = Math.pow(10.0, -((double)l));
            } else if (bl) {
                d = Math.pow(10.0, l);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            double doubleAccumulator = d2 * d;
            if (doubleAccumulator > 9.223372036854776E18 || doubleAccumulator < -9.223372036854776E18) {
                AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (!(Math.floor(doubleAccumulator) == doubleAccumulator)) {
                AbstractJsonLexer.fail$default(this, "Can't convert " + doubleAccumulator + " to Long", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            accumulator = (long)doubleAccumulator;
        }
        if (isNegative) {
            return accumulator;
        }
        if (accumulator != Long.MIN_VALUE) {
            void var3_3;
            return (long)(-var3_3);
        }
        AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, null, 6, null);
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean consumeBooleanLenient() {
        void var1_3;
        void var2_4;
        boolean bl;
        boolean bl2;
        int current22 = this.skipWhitespaces();
        if (current22 == this.getSource().length()) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        if (this.getSource().charAt(current22) == '\"') {
            ++current22;
            bl2 = true;
        } else {
            bl2 = false;
        }
        boolean hasQuotation = bl2;
        int n = current22;
        AbstractJsonLexer current22 = this;
        n = current22.prefetchOrEof(n);
        if (n >= current22.getSource().length() || n == -1) {
            AbstractJsonLexer.fail$default(current22, "EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        switch (current22.getSource().charAt(n++) | 0x20) {
            case 116: {
                current22.consumeBooleanLiteral("rue", n);
                bl = true;
                break;
            }
            case 102: {
                current22.consumeBooleanLiteral("alse", n);
                bl = false;
                break;
            }
            default: {
                AbstractJsonLexer.fail$default(current22, "Expected valid boolean literal prefix, but had '" + current22.consumeStringLenient() + '\'', 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
        }
        boolean result = bl;
        if (var2_4 != false) {
            if (this.currentPosition == this.getSource().length()) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (this.getSource().charAt(this.currentPosition) != '\"') {
                AbstractJsonLexer.fail$default(this, "Expected closing quotation mark", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            ++this.currentPosition;
        }
        return (boolean)var1_3;
    }

    /*
     * WARNING - void declaration
     */
    private final void consumeBooleanLiteral(String literalSuffix, int current) {
        void var1_1;
        void var2_2;
        if (this.getSource().length() - current < literalSuffix.length()) {
            AbstractJsonLexer.fail$default(this, "Unexpected end of boolean literal", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        int n = ((CharSequence)literalSuffix).length();
        for (int i = 0; i < n; ++i) {
            char actual;
            char expected = literalSuffix.charAt(i);
            if (expected == ((actual = this.getSource().charAt(current + i)) | 0x20)) continue;
            AbstractJsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        this.currentPosition = var2_2 + var1_1.length();
    }
}

