/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.twoslices;

import com.sshtools.twoslices.Toaster;
import com.sshtools.twoslices.ToasterService;
import com.sshtools.twoslices.ToasterSettings;
import com.sshtools.twoslices.impl.AWTToaster;
import java.util.Objects;
import java.util.ServiceLoader;

public abstract class ToasterFactory {
    private static ToasterSettings settings = new ToasterSettings();
    private static ToasterFactory instance;
    private static Object lock;

    public static ToasterFactory getFactory() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new ServicesToasterFactory();
            }
            return instance;
        }
    }

    public static void setFactory(ToasterFactory factory) {
        Object object = lock;
        synchronized (object) {
            ToasterFactory toasterFactory;
            instance = toasterFactory;
            return;
        }
    }

    public static void setSettings(ToasterSettings settings) {
        ToasterFactory.settings = settings;
    }

    public static ToasterSettings getSettings() {
        return settings;
    }

    protected ToasterFactory() {
        if (instance != null) {
            throw new IllegalStateException("You can only construct one instance of a ToasterFactory.");
        }
        instance = this;
    }

    public abstract Toaster toaster();

    static {
        lock = new Object();
    }

    public static final class ServicesToasterFactory
    extends ToasterFactory {
        private Toaster instance;
        private Object lock = new Object();
        private String lastPreferred;

        /*
         * WARNING - void declaration
         */
        @Override
        public final Toaster toaster() {
            Object object = this.lock;
            synchronized (object) {
                String preferred = ServicesToasterFactory.getSettings().getPreferredToasterClassName();
                if (this.instance == null || !Objects.equals(preferred, this.lastPreferred)) {
                    this.lastPreferred = preferred;
                    AWTToaster first = null;
                    for (ToasterService toaster : ServiceLoader.load(ToasterService.class)) {
                        try {
                            AWTToaster t = toaster.create$24925e4(settings);
                            if (first == null) {
                                first = t;
                            }
                            if (preferred == null) {
                                this.instance = t;
                                break;
                            }
                            if (!preferred.equals(t.getClass().getName())) continue;
                            this.instance = t;
                            break;
                        }
                        catch (Exception | ExceptionInInitializerError | NoClassDefFoundError | NoSuchMethodError throwable) {
                        }
                    }
                    if (this.instance == null) {
                        void var3_4;
                        this.instance = var3_4;
                    }
                    if (this.instance == null) {
                        throw new UnsupportedOperationException("No toasters available.");
                    }
                }
                return this.instance;
            }
        }
    }
}

