/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.output.NullOutputStream;

public final class ThresholdingOutputStream
extends OutputStream {
    private static final IOFunction<ThresholdingOutputStream, OutputStream> NOOP_OS_GETTER = os -> NullOutputStream.INSTANCE;
    private final int threshold = Integer.MAX_VALUE;
    private final IOConsumer<ThresholdingOutputStream> thresholdConsumer;
    private final IOFunction<ThresholdingOutputStream, OutputStream> outputStreamGetter;
    private long written;
    private boolean thresholdExceeded;

    /*
     * WARNING - void declaration
     */
    public ThresholdingOutputStream(int threshold, IOConsumer<ThresholdingOutputStream> thresholdConsumer, IOFunction<ThresholdingOutputStream, OutputStream> outputStreamGetter) {
        void var3_3;
        void var2_2;
        this.thresholdConsumer = thresholdConsumer == null ? IOConsumer.noop() : var2_2;
        this.outputStreamGetter = outputStreamGetter == null ? NOOP_OS_GETTER : var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private void checkThreshold(int count) throws IOException {
        void var1_1;
        if (!this.thresholdExceeded && this.written + (long)var1_1 > (long)this.threshold) {
            this.thresholdExceeded = true;
            ThresholdingOutputStream thresholdingOutputStream = this;
            thresholdingOutputStream.thresholdConsumer.accept(thresholdingOutputStream);
        }
    }

    @Override
    public final void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {}
        ThresholdingOutputStream thresholdingOutputStream = this;
        thresholdingOutputStream.getOutputStream().close();
    }

    @Override
    public final void flush() throws IOException {
        ThresholdingOutputStream thresholdingOutputStream = this;
        thresholdingOutputStream.getOutputStream().flush();
    }

    private OutputStream getOutputStream() throws IOException {
        return this.outputStreamGetter.apply(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(byte[] b) throws IOException {
        void var1_1;
        this.checkThreshold(b.length);
        ThresholdingOutputStream thresholdingOutputStream = this;
        thresholdingOutputStream.getOutputStream().write(b);
        this.written += (long)((void)var1_1).length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkThreshold(len);
        ThresholdingOutputStream thresholdingOutputStream = this;
        thresholdingOutputStream.getOutputStream().write((byte[])var1_1, (int)var2_2, len);
        this.written += (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(int b) throws IOException {
        void var1_1;
        this.checkThreshold(1);
        ThresholdingOutputStream thresholdingOutputStream = this;
        thresholdingOutputStream.getOutputStream().write((int)var1_1);
        ++this.written;
    }
}

