/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.RandomAccessFiles;
import org.apache.commons.io.build.AbstractSupplier;

public abstract class AbstractOrigin<T, B extends AbstractOrigin<T, B>>
extends AbstractSupplier<T, B> {
    final T origin;

    /*
     * WARNING - void declaration
     */
    protected AbstractOrigin(T origin) {
        void var1_1;
        this.origin = Objects.requireNonNull(var1_1, "origin");
    }

    public byte[] getByteArray() throws IOException {
        return Files.readAllBytes(this.getPath());
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getByteArray(long position, int length) throws IOException {
        void var3_3;
        void var1_2;
        byte[] bytes = this.getByteArray();
        int start = Math.toIntExact(position);
        if (start < 0 || length < 0 || start + length < 0 || start + length > bytes.length) {
            throw new IllegalArgumentException("Couldn't read array (start: " + start + ", length: " + length + ", data length: " + bytes.length + ").");
        }
        void v0 = var1_2;
        return Arrays.copyOfRange(bytes, (int)v0, (int)(v0 + var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getInputStream(OpenOption ... options) throws IOException {
        void var1_1;
        return Files.newInputStream(this.getPath(), (OpenOption[])var1_1);
    }

    public Path getPath() {
        Object[] objectArray = new Object[3];
        AbstractOrigin abstractOrigin = this;
        objectArray[0] = abstractOrigin.getClass().getSimpleName();
        objectArray[1] = this.origin.getClass().getSimpleName();
        objectArray[2] = this.origin;
        throw new UnsupportedOperationException(String.format("%s#getPath() for %s origin %s", objectArray));
    }

    public long size() throws IOException {
        return Files.size(this.getPath());
    }

    public String toString() {
        AbstractOrigin abstractOrigin = this;
        return abstractOrigin.getClass().getSimpleName() + "[" + this.origin.toString() + "]";
    }

    public static final class InputStreamOrigin
    extends AbstractOrigin<InputStream, InputStreamOrigin> {
        /*
         * WARNING - void declaration
         */
        public InputStreamOrigin(InputStream origin) {
            super(var1_1);
            void var1_1;
        }

        @Override
        public final byte[] getByteArray() throws IOException {
            return IOUtils.toByteArray((InputStream)this.origin);
        }

        @Override
        public final InputStream getInputStream(OpenOption ... options) {
            InputStreamOrigin inputStreamOrigin = this;
            return (InputStream)inputStreamOrigin.origin;
        }
    }

    public static final class FileOrigin
    extends AbstractOrigin<File, FileOrigin> {
        /*
         * WARNING - void declaration
         */
        public FileOrigin(File origin) {
            super(var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] getByteArray(long position, int length) throws IOException {
            try (RandomAccessFile raf = RandomAccessFileMode.READ_ONLY.create((File)this.origin);){
                void var3_4;
                void var1_1;
                byte[] byArray = RandomAccessFiles.read(raf, (long)var1_1, (int)var3_4);
                return byArray;
            }
        }

        @Override
        public final Path getPath() {
            FileOrigin fileOrigin = this;
            return ((File)fileOrigin.origin).toPath();
        }
    }

    public static final class ByteArrayOrigin
    extends AbstractOrigin<byte[], ByteArrayOrigin> {
        /*
         * WARNING - void declaration
         */
        public ByteArrayOrigin(byte[] origin) {
            super(var1_1);
            void var1_1;
        }

        @Override
        public final byte[] getByteArray() {
            ByteArrayOrigin byteArrayOrigin = this;
            return (byte[])byteArrayOrigin.origin;
        }

        @Override
        public final InputStream getInputStream(OpenOption ... options) throws IOException {
            return new ByteArrayInputStream((byte[])this.origin);
        }

        @Override
        public final long size() throws IOException {
            return ((byte[])this.origin).length;
        }
    }
}

