/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.io.StandardLineSeparator;
import org.apache.commons.io.function.IOTriFunction;
import org.apache.commons.io.output.AbstractByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;

public final class IOUtils {
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @Deprecated
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String LINE_SEPARATOR_UNIX = StandardLineSeparator.LF.getString();
    public static final String LINE_SEPARATOR_WINDOWS = StandardLineSeparator.CRLF.getString();
    private static final ThreadLocal<byte[]> SCRATCH_BYTE_BUFFER_RW = ThreadLocal.withInitial(IOUtils::byteArray);
    private static final byte[] SCRATCH_BYTE_BUFFER_WO = IOUtils.byteArray();
    private static final ThreadLocal<char[]> SCRATCH_CHAR_BUFFER_RW = ThreadLocal.withInitial(IOUtils::charArray);
    private static final char[] SCRATCH_CHAR_BUFFER_WO = IOUtils.charArray();

    public static byte[] byteArray() {
        int n = 8192;
        return new byte[8192];
    }

    public static byte[] byteArray(int size) {
        return new byte[size];
    }

    private static char[] charArray() {
        int n = 8192;
        return new char[8192];
    }

    public static void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            Closeable closeable2;
            closeable2.close();
        }
    }

    public static long consume(InputStream input) throws IOException {
        return IOUtils.copyLarge(input, NullOutputStream.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private static long copy(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        int n;
        void var1_3;
        int n2 = 8192;
        byte[] byArray = new byte[8192];
        InputStream inputStream2 = inputStream;
        Objects.requireNonNull(inputStream2, "inputStream");
        Objects.requireNonNull(var1_3, "outputStream");
        long l = 0L;
        while (-1 != (n = inputStream2.read(byArray))) {
            var1_3.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        void var1_1;
        return IOUtils.copy(inputStream, (OutputStream)var1_1, 8192);
    }

    static byte[] getScratchByteArrayWriteOnly() {
        byte[] byArray = SCRATCH_BYTE_BUFFER_WO;
        Arrays.fill(SCRATCH_BYTE_BUFFER_WO, (byte)0);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static long skip(InputStream input, long toSkip) throws IOException {
        byte[] byArray;
        void var7_4;
        long l;
        void var1_1;
        Supplier<byte[]> supplier = IOUtils::getScratchByteArrayWriteOnly;
        void var4_3 = var1_1;
        InputStream inputStream = input;
        if (var4_3 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + (long)var4_3);
        }
        for (var7_4 = var4_3; var7_4 > 0L && (l = (long)inputStream.read(byArray = supplier.get(), 0, (int)Math.min((long)var7_4, (long)byArray.length))) >= 0L; var7_4 -= l) {
        }
        return (long)(var4_3 - var7_4);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        Object object;
        UnsynchronizedByteArrayOutputStream ubaOutput = UnsynchronizedByteArrayOutputStream.builder().get();
        ThresholdingOutputStream thresholdOutput = new ThresholdingOutputStream(Integer.MAX_VALUE, os -> {
            throw new IllegalArgumentException(String.format("Cannot read more than %,d into a byte array", Integer.MAX_VALUE));
        }, os -> ubaOutput);
        ThresholdingOutputStream thresholdingOutputStream = thresholdOutput;
        long l = IOUtils.copyLarge((InputStream)object, thresholdingOutputStream);
        int n = l > Integer.MAX_VALUE ? -1 : (int)l;
        object = ((AbstractByteArrayOutputStream)ubaOutput).toByteArray();
        thresholdOutput.close();
        ubaOutput.close();
        return object;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        void var2_4;
                        var2_4.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    try {
                        void var1_3;
                        var1_3.close();
                    }
                    catch (Throwable throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toByteArray(InputStream input, int size) throws IOException {
        void var1_1;
        InputStream inputStream;
        if (size == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return IOUtils.toByteArray(Objects.requireNonNull(inputStream, "input")::read, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static byte[] toByteArray(IOTriFunction<byte[], Integer, Integer, Integer> input, int size) throws IOException {
        void var2_3;
        int offset;
        int read;
        if (size < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + size);
        }
        if (size == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        int n = size;
        byte[] data = new byte[n];
        for (offset = 0; offset < size && (read = input.apply(data, offset, size - offset).intValue()) != -1; offset += read) {
        }
        if (offset != size) {
            void var1_1;
            void var3_4;
            throw new IOException("Unexpected read size, current: " + (int)var3_4 + ", expected: " + (int)var1_1);
        }
        return var2_3;
    }
}

