/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.RenderTargetsKt;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingOffscreenDrawer;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0082 \u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\rH\u0082 \u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0082 \u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\rH\u0082 \u00a2\u0006\u0004\b\u0019\u0010\u0015J\u001f\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0018\u0010!\u001a\u00020\n2\u0006\u0010 \u001a\u00020\rH\u0082 \u00a2\u0006\u0004\b!\u0010\"J0\u0010$\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0082 \u00a2\u0006\u0004\b$\u0010%J\u0010\u0010&\u001a\u00020\rH\u0082 \u00a2\u0006\u0004\b&\u0010'J/\u0010)\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010(\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b)\u0010*J \u0010+\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0082 \u00a2\u0006\u0004\b+\u0010,J\u0018\u0010-\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\rH\u0082 \u00a2\u0006\u0004\b-\u0010\u0015R\u0016\u0010/\u001a\u00020.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0016\u00101\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00103\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00102R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00104R\u0014\u00106\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0014\u00109\u001a\u0002088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:"}, d2={"Lorg/jetbrains/skiko/swing/LinuxOpenGLSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "swingLayerProperties", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "renderDelegate", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "analytics", "<init>", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "", "width", "height", "", "createAndBindTexture", "(II)J", "", "dispose", "()V", "bufferPtr", "disposeOffScreenBuffer", "(J)V", "contextPtr", "disposeOffScreenContext", "(J)J", "finishRendering", "Lorg/jetbrains/skia/Surface;", "surface", "Ljava/awt/Graphics2D;", "g", "flush", "(Lorg/jetbrains/skia/Surface;Ljava/awt/Graphics2D;)V", "texturePtr", "getFboId", "(J)I", "oldBufferPtr", "makeOffScreenBuffer", "(JJII)J", "makeOffScreenContext", "()J", "nanoTime", "onRender", "(Ljava/awt/Graphics2D;IIJ)V", "startRendering", "(JJ)V", "unbindAndDisposeTexture", "", "bytesToDraw", "[B", "offScreenBufferPtr", "J", "offScreenContextPtr", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "Lorg/jetbrains/skia/Bitmap;", "storage", "Lorg/jetbrains/skia/Bitmap;", "Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "swingOffscreenDrawer", "Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;"})
public final class LinuxOpenGLSwingRedrawer
extends SwingRedrawerBase {
    private final SkikoRenderDelegate renderDelegate;
    private final SwingOffscreenDrawer swingOffscreenDrawer;
    private final long offScreenContextPtr;
    private long offScreenBufferPtr;
    private final Bitmap storage;
    private byte[] bytesToDraw;

    /*
     * WARNING - void declaration
     */
    public LinuxOpenGLSwingRedrawer(SwingLayerProperties swingLayerProperties2, SkikoRenderDelegate renderDelegate, SkiaLayerAnalytics analytics) {
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"swingLayerProperties");
        Intrinsics.checkNotNullParameter((Object)renderDelegate, (String)"renderDelegate");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        super(swingLayerProperties2, (SkiaLayerAnalytics)var3_3, GraphicsApi.OPENGL);
        this.renderDelegate = var2_2;
        this.onDeviceChosen("OpenGL OffScreen");
        this.swingOffscreenDrawer = new SwingOffscreenDrawer((SwingLayerProperties)((Object)linuxOpenGLSwingRedrawer));
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer2 = this;
        long l = linuxOpenGLSwingRedrawer2.makeOffScreenContext();
        linuxOpenGLSwingRedrawer = linuxOpenGLSwingRedrawer2;
        if (l == 0L) {
            throw new RenderException("Cannot create OpenGL context", null, 2, null);
        }
        linuxOpenGLSwingRedrawer.offScreenContextPtr = l;
        this.storage = new Bitmap();
        this.bytesToDraw = new byte[0];
        this.onContextInit();
    }

    @Override
    public final void dispose() {
        this.bytesToDraw = new byte[0];
        this.storage.close();
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer = this;
        linuxOpenGLSwingRedrawer.disposeOffScreenBuffer(linuxOpenGLSwingRedrawer.offScreenBufferPtr);
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer2 = this;
        linuxOpenGLSwingRedrawer2.disposeOffScreenContext(linuxOpenGLSwingRedrawer2.offScreenContextPtr);
        super.dispose();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void onRender(Graphics2D g, int width2, int height2, long nanoTime) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.offScreenBufferPtr = this.makeOffScreenBuffer(this.offScreenContextPtr, this.offScreenBufferPtr, width2, height2);
        if (this.offScreenBufferPtr == 0L) {
            throw new RenderException("Cannot create offScreen OpenGL buffer", null, 2, null);
        }
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer = this;
        linuxOpenGLSwingRedrawer.startRendering(linuxOpenGLSwingRedrawer.offScreenContextPtr, this.offScreenBufferPtr);
        try {
            void var1_1;
            void var3_4;
            void var2_3;
            ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new Function1<CloseScope, Unit>(this, (int)var2_3, (int)var3_4, nanoTime, (Graphics2D)var1_1){
                final /* synthetic */ LinuxOpenGLSwingRedrawer this$0;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ long $nanoTime;
                final /* synthetic */ Graphics2D $g;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.$width = var2_2;
                    this.$height = var3_3;
                    this.$nanoTime = $nanoTime;
                    this.$g = $g;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(CloseScope $this$autoCloseScope) {
                    void var2_2;
                    void var1_1;
                    Intrinsics.checkNotNullParameter((Object)$this$autoCloseScope, (String)"$this$autoCloseScope");
                    long texturePtr = LinuxOpenGLSwingRedrawer.access$createAndBindTexture(this.this$0, this.$width, this.$height);
                    if (texturePtr == 0L) {
                        throw new RenderException("Cannot create offScreen OpenGL texture", null, 2, null);
                    }
                    int fbId = LinuxOpenGLSwingRedrawer.access$getFboId(this.this$0, texturePtr);
                    Managed renderTarget = (BackendRenderTarget)$this$autoCloseScope.autoClose((AutoCloseable)RenderTargetsKt.makeGLRenderTarget(this.$width, this.$height, 0, 8, fbId, 32856));
                    DirectContext directContext = (DirectContext)$this$autoCloseScope.autoClose((AutoCloseable)RenderTargetsKt.makeGLContext());
                    renderTarget = Surface.Companion.makeFromBackendRenderTarget(directContext, (BackendRenderTarget)renderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
                    if (renderTarget == null || ($this$autoCloseScope = (Surface)$this$autoCloseScope.autoClose((AutoCloseable)renderTarget)) == null) {
                        throw new RenderException("Cannot create surface", null, 2, null);
                    }
                    Object surface = $this$autoCloseScope;
                    Canvas canvas = ((Surface)surface).getCanvas();
                    canvas.clear(0);
                    LinuxOpenGLSwingRedrawer.access$getRenderDelegate$p(this.this$0).onRender(canvas, this.$width, this.$height, this.$nanoTime);
                    LinuxOpenGLSwingRedrawer.access$flush(this.this$0, (Surface)var1_1, this.$g);
                    LinuxOpenGLSwingRedrawer.access$unbindAndDisposeTexture(this.this$0, (long)var2_2);
                }
            }));
            LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer2 = this;
            linuxOpenGLSwingRedrawer2.finishRendering(linuxOpenGLSwingRedrawer2.offScreenContextPtr);
            return;
        }
        catch (Throwable throwable) {
            LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer3 = this;
            linuxOpenGLSwingRedrawer3.finishRendering(linuxOpenGLSwingRedrawer3.offScreenContextPtr);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void flush(Surface surface, Graphics2D g) {
        void var1_1;
        surface.flushAndSubmit(true);
        int width2 = surface.getWidth();
        int height2 = surface.getHeight();
        int dstRowBytes = width2 * 4;
        if (this.storage.getWidth() != width2 || this.storage.getHeight() != height2) {
            this.storage.allocPixelsFlags(ImageInfo.Companion.makeS32(width2, height2, ColorAlphaType.PREMUL), false);
            this.bytesToDraw = new byte[Bitmap.getReadPixelsArraySize$skiko$default(this.storage, null, dstRowBytes, 0, 5, null)];
        }
        var1_1.readPixels(this.storage, 0, 0);
        boolean bl = Bitmap.readPixels$skiko$default(this.storage, this.bytesToDraw, null, dstRowBytes, 0, 0, 26, null);
        if (bl) {
            void var3_4;
            void var2_3;
            this.swingOffscreenDrawer.draw((Graphics2D)var2_3, this.bytesToDraw, (int)var3_4, height2);
        }
    }

    private final native long makeOffScreenContext();

    private final native long disposeOffScreenContext(long var1);

    private final native long makeOffScreenBuffer(long var1, long var3, int var5, int var6);

    private final native void disposeOffScreenBuffer(long var1);

    private final native void startRendering(long var1, long var3);

    private final native void finishRendering(long var1);

    private final native long createAndBindTexture(int var1, int var2);

    private final native int getFboId(long var1);

    private final native void unbindAndDisposeTexture(long var1);

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long access$createAndBindTexture(LinuxOpenGLSwingRedrawer $this, int width2, int height2) {
        void var2_2;
        void var1_1;
        return $this.createAndBindTexture((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int access$getFboId(LinuxOpenGLSwingRedrawer $this, long texturePtr) {
        void var1_1;
        return $this.getFboId((long)var1_1);
    }

    public static final /* synthetic */ SkikoRenderDelegate access$getRenderDelegate$p(LinuxOpenGLSwingRedrawer $this) {
        return $this.renderDelegate;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$flush(LinuxOpenGLSwingRedrawer $this, Surface surface, Graphics2D g) {
        void var2_2;
        void var1_1;
        $this.flush((Surface)var1_1, (Graphics2D)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$unbindAndDisposeTexture(LinuxOpenGLSwingRedrawer $this, long texturePtr) {
        void var1_1;
        $this.unbindAndDisposeTexture((long)var1_1);
    }
}

