/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.JvmContextHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\r\u0010\fR\u001a\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u0004\u0018\u00010\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\"\u0010!\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b!\u0010\f\"\u0004\b#\u0010$R$\u0010&\u001a\u0004\u0018\u00010%8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0017\u0010-\u001a\u00020,8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100"}, d2={"Lorg/jetbrains/skiko/context/SoftwareContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "Lorg/jetbrains/skiko/SkiaLayer;", "layer", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "", "flush", "()V", "initCanvas", "", "initContext", "()Z", "isTransparentBackground", "Ljava/awt/image/ComponentColorModel;", "colorModel", "Ljava/awt/image/ComponentColorModel;", "getColorModel", "()Ljava/awt/image/ComponentColorModel;", "Ljava/awt/image/BufferedImage;", "image", "Ljava/awt/image/BufferedImage;", "getImage", "()Ljava/awt/image/BufferedImage;", "setImage", "(Ljava/awt/image/BufferedImage;)V", "", "imageData", "[B", "getImageData", "()[B", "setImageData", "([B)V", "isInited", "Z", "setInited", "(Z)V", "Ljava/awt/image/WritableRaster;", "raster", "Ljava/awt/image/WritableRaster;", "getRaster", "()Ljava/awt/image/WritableRaster;", "setRaster", "(Ljava/awt/image/WritableRaster;)V", "Lorg/jetbrains/skia/Bitmap;", "storage", "Lorg/jetbrains/skia/Bitmap;", "getStorage", "()Lorg/jetbrains/skia/Bitmap;"})
@SourceDebugExtension(value={"SMAP\nSoftwareContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoftwareContextHandler.kt\norg/jetbrains/skiko/context/SoftwareContextHandler\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,84:1\n124#2,4:85\n*S KotlinDebug\n*F\n+ 1 SoftwareContextHandler.kt\norg/jetbrains/skiko/context/SoftwareContextHandler\n*L\n36#1:85,4\n*E\n"})
public final class SoftwareContextHandler
extends JvmContextHandler {
    private final ComponentColorModel colorModel;
    private final Bitmap storage;
    private BufferedImage image;
    private byte[] imageData;
    private WritableRaster raster;
    private boolean isInited;

    /*
     * WARNING - void declaration
     */
    public SoftwareContextHandler(SkiaLayer layer) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super((SkiaLayer)var1_1);
        this.colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        this.storage = new Bitmap();
    }

    @Override
    protected final boolean isTransparentBackground() {
        return OsArch_jvmKt.getHostOs() == OS.MacOS && this.getLayer().getTransparency();
    }

    public final ComponentColorModel getColorModel() {
        return this.colorModel;
    }

    public final Bitmap getStorage() {
        return this.storage;
    }

    public final BufferedImage getImage() {
        return this.image;
    }

    /*
     * WARNING - void declaration
     */
    public final void setImage(BufferedImage bufferedImage) {
        void var1_1;
        this.image = var1_1;
    }

    public final byte[] getImageData() {
        return this.imageData;
    }

    /*
     * WARNING - void declaration
     */
    public final void setImageData(byte[] byArray) {
        void var1_1;
        this.imageData = var1_1;
    }

    public final WritableRaster getRaster() {
        return this.raster;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRaster(WritableRaster writableRaster) {
        void var1_1;
        this.raster = var1_1;
    }

    public final boolean isInited() {
        return this.isInited;
    }

    /*
     * WARNING - void declaration
     */
    public final void setInited(boolean bl) {
        void var1_1;
        this.isInited = var1_1;
    }

    @Override
    protected final boolean initContext() {
        if (!this.isInited) {
            Logger this_$iv;
            if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && (this_$iv = Logger.INSTANCE).getLoggerImpl().isInfoEnabled()) {
                SkikoLoggerInterface skikoLoggerInterface;
                skikoLoggerInterface = ((Logger)((Object)skikoLoggerInterface)).getLoggerImpl();
                skikoLoggerInterface.info("Renderer info:\n " + this.rendererInfo());
            }
            this.isInited = true;
        }
        return this.isInited;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void initCanvas() {
        this.disposeCanvas();
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        int h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0);
        if (this.storage.getWidth() != w || this.storage.getHeight() != h) {
            void var1_2;
            void var2_3;
            this.storage.allocPixelsFlags(ImageInfo.Companion.makeS32((int)var2_3, (int)var1_2, ColorAlphaType.PREMUL), false);
        }
        this.setCanvas(new Canvas(this.storage, new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void flush() {
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        int h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0);
        byte[] bytes = this.storage.readPixels(this.storage.getImageInfo(), w * 4, 0, 0);
        if (bytes != null) {
            void var3_4;
            Object buffer = new DataBufferByte(bytes, bytes.length);
            DataBuffer dataBuffer = (DataBuffer)buffer;
            int[] nArray = new int[4];
            buffer = nArray;
            nArray[0] = 2;
            buffer[1] = true;
            buffer[2] = false;
            buffer[3] = 3;
            this.raster = Raster.createInterleavedRaster(dataBuffer, w, h, w * 4, 4, (int[])buffer, null);
            ColorModel colorModel = this.colorModel;
            WritableRaster writableRaster = this.raster;
            Intrinsics.checkNotNull((Object)writableRaster);
            this.image = new BufferedImage(colorModel, writableRaster, false, null);
            Graphics graphics = this.getLayer().getBackedLayer$skiko().getGraphics();
            if (!this.getLayer().getFullscreen() && this.getLayer().getTransparency() && OsArch_jvmKt.getHostOs() == OS.MacOS) {
                Graphics graphics2 = graphics;
                if (graphics2 != null) {
                    graphics2.setColor(new Color(0, 0, 0, 0));
                }
                Graphics graphics3 = graphics;
                if (graphics3 != null) {
                    void var1_2;
                    void var2_3;
                    graphics3.clearRect(0, 0, (int)var2_3, (int)var1_2);
                }
            }
            void v6 = var3_4;
            if (v6 != null) {
                BufferedImage bufferedImage = this.image;
                Intrinsics.checkNotNull((Object)bufferedImage);
                v6.drawImage(bufferedImage, 0, 0, this.getLayer().getWidth(), this.getLayer().getHeight(), null);
                return;
            }
        }
    }
}

