/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import java.lang.ref.Reference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.ContextHandler;
import org.jetbrains.skiko.context.JvmContextHandler;
import org.jetbrains.skiko.redrawer.Direct3DRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\t\u0010\bJ \u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0082 \u00a2\u0006\u0004\b\t\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u000e\u0010\bJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0011J\u000f\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00128\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001cR\u0014\u0010\"\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&"}, d2={"Lorg/jetbrains/skiko/context/Direct3DContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "Lorg/jetbrains/skiko/SkiaLayer;", "layer", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "", "disposeCanvas", "()V", "flush", "", "context", "surface", "(JJ)V", "initCanvas", "", "initContext", "()Z", "", "width", "height", "isSizeChanged", "(II)Z", "isSurfacesNull", "", "rendererInfo", "()Ljava/lang/String;", "bufferCount", "I", "currentHeight", "currentWidth", "Lorg/jetbrains/skiko/redrawer/Direct3DRedrawer;", "getDirectXRedrawer", "()Lorg/jetbrains/skiko/redrawer/Direct3DRedrawer;", "directXRedrawer", "", "Lorg/jetbrains/skia/Surface;", "surfaces", "[Lorg/jetbrains/skia/Surface;"})
@SourceDebugExtension(value={"SMAP\nDirect3DContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Direct3DContextHandler.kt\norg/jetbrains/skiko/context/Direct3DContextHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,108:1\n12271#2,2:109\n124#3,4:111\n159#3,4:115\n*S KotlinDebug\n*F\n+ 1 Direct3DContextHandler.kt\norg/jetbrains/skiko/context/Direct3DContextHandler\n*L\n14#1:109,2\n24#1:111,4\n28#1:115,4\n*E\n"})
public final class Direct3DContextHandler
extends JvmContextHandler {
    private final int bufferCount;
    private Surface[] surfaces;
    private int currentWidth;
    private int currentHeight;

    /*
     * WARNING - void declaration
     */
    public Direct3DContextHandler(SkiaLayer layer) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super((SkiaLayer)var1_1);
        this.bufferCount = 2;
        this.surfaces = new Surface[this.bufferCount];
    }

    private final boolean isSurfacesNull() {
        for (Surface surface : this.surfaces) {
            Surface surface2 = surface;
            surface2 = surface;
            if (surface == null) continue;
            return false;
        }
        return true;
    }

    private final Direct3DRedrawer getDirectXRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (Direct3DRedrawer)redrawer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean initContext() {
        try {
            if (this.getContext() == null) {
                Object this_$iv;
                Direct3DContextHandler direct3DContextHandler = this;
                direct3DContextHandler.setContext(direct3DContextHandler.getDirectXRedrawer().makeContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && ((Logger)(this_$iv = Logger.INSTANCE)).getLoggerImpl().isInfoEnabled()) {
                    this_$iv = ((Logger)this_$iv).getLoggerImpl();
                    this_$iv.info("Renderer info:\n " + ((ContextHandler)this).rendererInfo());
                }
            }
        }
        catch (Exception e) {
            Logger this_$iv = Logger.INSTANCE;
            if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                void var1_2;
                Throwable throwable;
                SkikoLoggerInterface skikoLoggerInterface = ((Logger)((Object)throwable)).getLoggerImpl();
                throwable = (Throwable)var1_2;
                SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                String string = "Failed to create Skia Direct3D context!";
                skikoLoggerInterface2.warn(throwable, string);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSizeChanged(int width2, int height2) {
        if (width2 != this.currentWidth || height2 != this.currentHeight) {
            void var2_2;
            void var1_1;
            this.currentWidth = var1_1;
            this.currentHeight = var2_2;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void initCanvas() {
        block5: {
            int height2;
            DirectContext directContext = this.getContext();
            if (directContext == null) {
                return;
            }
            DirectContext context = directContext;
            float scale = this.getLayer().getContentScale();
            int width2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)1);
            if (!this.isSizeChanged(width2, height2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)1)) && !this.isSurfacesNull()) break block5;
            this.disposeCanvas();
            context.flush();
            boolean justInitialized = this.getDirectXRedrawer().changeSize(width2, height2);
            try {
                SurfaceProps surfaceProps = new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null);
                int n = this.bufferCount;
                for (int bufferIndex = 0; bufferIndex < n; ++bufferIndex) {
                    this.surfaces[bufferIndex] = this.getDirectXRedrawer().makeSurface(NativeKt.getPtr(context), width2, height2, surfaceProps, bufferIndex);
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                Reference.reachabilityFence(var1_1);
                throw throwable;
            }
            Reference.reachabilityFence(context);
            if (justInitialized) {
                this.getDirectXRedrawer().initFence();
            }
        }
        Direct3DContextHandler direct3DContextHandler = this;
        direct3DContextHandler.setSurface(direct3DContextHandler.surfaces[this.getDirectXRedrawer().getBufferIndex()]);
        Direct3DContextHandler direct3DContextHandler2 = this;
        Surface surface = direct3DContextHandler2.getSurface();
        Intrinsics.checkNotNull((Object)surface);
        direct3DContextHandler2.setCanvas(surface.getCanvas());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void flush() {
        DirectContext directContext = this.getContext();
        if (directContext == null) {
            return;
        }
        DirectContext context = directContext;
        Surface surface = this.getSurface();
        if (surface == null) {
            return;
        }
        Surface surface2 = surface;
        try {
            this.flush(NativeKt.getPtr(context), NativeKt.getPtr(surface2));
        }
        catch (Throwable throwable) {
            void var2_2;
            void var1_1;
            Reference.reachabilityFence(var1_1);
            Reference.reachabilityFence(var2_2);
            throw throwable;
        }
        Reference.reachabilityFence(context);
        Reference.reachabilityFence(surface2);
    }

    @Override
    protected final void disposeCanvas() {
        int n = this.bufferCount;
        for (int bufferIndex = 0; bufferIndex < n; ++bufferIndex) {
            Surface surface = this.surfaces[bufferIndex];
            if (surface == null) continue;
            surface.close();
        }
    }

    @Override
    public final String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.getDirectXRedrawer().getAdapterName() + "\nTotal VRAM: " + this.getDirectXRedrawer().getAdapterMemorySize() / 1024L / 1024L + " MB\n";
    }

    private final native void flush(long var1, long var3);
}

