/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001B(\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\r\u0010\fJ\r\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\fJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u000f\u0010\fJ\u000f\u0010\u0010\u001a\u00020\u0006H$\u00a2\u0006\u0004\b\u0010\u0010\fJ\u000f\u0010\u0012\u001a\u00020\u0011H$\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u0004\u0018\u00010\u00058\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001f\u001a\u0004\u0018\u00010\u001e8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R%\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010%R\u001a\u0010\u0003\u001a\u00020\u00028\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010(R$\u0010*\u001a\u0004\u0018\u00010)8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R$\u00101\u001a\u0004\u0018\u0001008\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106"}, d2={"Lorg/jetbrains/skiko/context/ContextHandler;", "", "Lorg/jetbrains/skiko/SkiaLayer;", "layer", "Lkotlin/Function1;", "Lorg/jetbrains/skia/Canvas;", "", "Lkotlin/ExtensionFunctionType;", "drawContent", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;Lkotlin/jvm/functions/Function1;)V", "dispose", "()V", "disposeCanvas", "draw", "flush", "initCanvas", "", "initContext", "()Z", "isTransparentBackground", "", "rendererInfo", "()Ljava/lang/String;", "canvas", "Lorg/jetbrains/skia/Canvas;", "getCanvas", "()Lorg/jetbrains/skia/Canvas;", "setCanvas", "(Lorg/jetbrains/skia/Canvas;)V", "Lorg/jetbrains/skia/DirectContext;", "context", "Lorg/jetbrains/skia/DirectContext;", "getContext", "()Lorg/jetbrains/skia/DirectContext;", "setContext", "(Lorg/jetbrains/skia/DirectContext;)V", "Lkotlin/jvm/functions/Function1;", "Lorg/jetbrains/skiko/SkiaLayer;", "getLayer", "()Lorg/jetbrains/skiko/SkiaLayer;", "Lorg/jetbrains/skia/BackendRenderTarget;", "renderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "getRenderTarget", "()Lorg/jetbrains/skia/BackendRenderTarget;", "setRenderTarget", "(Lorg/jetbrains/skia/BackendRenderTarget;)V", "Lorg/jetbrains/skia/Surface;", "surface", "Lorg/jetbrains/skia/Surface;", "getSurface", "()Lorg/jetbrains/skia/Surface;", "setSurface", "(Lorg/jetbrains/skia/Surface;)V"})
public abstract class ContextHandler {
    private final SkiaLayer layer;
    private final Function1<Canvas, Unit> drawContent;
    private DirectContext context;
    private BackendRenderTarget renderTarget;
    private Surface surface;
    private Canvas canvas;

    /*
     * WARNING - void declaration
     */
    public ContextHandler(SkiaLayer layer, Function1<? super Canvas, Unit> drawContent) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter(drawContent, (String)"drawContent");
        this.layer = var1_1;
        this.drawContent = var2_2;
    }

    protected final SkiaLayer getLayer() {
        return this.layer;
    }

    protected final DirectContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    protected final void setContext(DirectContext directContext) {
        void var1_1;
        this.context = var1_1;
    }

    protected final BackendRenderTarget getRenderTarget() {
        return this.renderTarget;
    }

    /*
     * WARNING - void declaration
     */
    protected final void setRenderTarget(BackendRenderTarget backendRenderTarget) {
        void var1_1;
        this.renderTarget = var1_1;
    }

    protected final Surface getSurface() {
        return this.surface;
    }

    /*
     * WARNING - void declaration
     */
    protected final void setSurface(Surface surface) {
        void var1_1;
        this.surface = var1_1;
    }

    protected final Canvas getCanvas() {
        return this.canvas;
    }

    /*
     * WARNING - void declaration
     */
    protected final void setCanvas(Canvas canvas) {
        void var1_1;
        this.canvas = var1_1;
    }

    protected abstract boolean initContext();

    protected abstract void initCanvas();

    protected void flush() {
        DirectContext directContext = this.context;
        if (directContext != null) {
            directContext.flush();
            return;
        }
    }

    public void dispose() {
        this.disposeCanvas();
        DirectContext directContext = this.context;
        if (directContext != null) {
            directContext.close();
            return;
        }
    }

    protected void disposeCanvas() {
        Surface surface = this.surface;
        if (surface != null) {
            surface.close();
        }
        BackendRenderTarget backendRenderTarget = this.renderTarget;
        if (backendRenderTarget != null) {
            backendRenderTarget.close();
            return;
        }
    }

    public String rendererInfo() {
        return "GraphicsApi: " + (Object)((Object)this.layer.getRenderApi()) + "\nOS: " + OsArch_jvmKt.getHostOs().getId() + ' ' + OsArch_jvmKt.getHostArch().getId() + '\n';
    }

    public final void draw() {
        if (!this.initContext()) {
            throw new RenderException("Cannot init graphic context", null, 2, null);
        }
        this.initCanvas();
        Canvas canvas = this.canvas;
        if (canvas != null) {
            Canvas canvas2 = canvas;
            Canvas $this$draw_u24lambda_u240 = canvas;
            canvas.clear(this.isTransparentBackground() ? 0 : -1);
            this.drawContent.invoke((Object)canvas2);
        }
        this.flush();
    }

    protected boolean isTransparentBackground() {
        if (OsArch_jvmKt.getHostOs() == OS.MacOS) {
            return true;
        }
        if (this.layer.getFullscreen()) {
            return false;
        }
        return this.layer.getTransparency();
    }
}

