/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.collection.MutableIntObjectMap;
import androidx.compose.ui.graphics.colorspace.Adaptation;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.Connector;
import androidx.compose.ui.graphics.colorspace.ConnectorKt;
import androidx.compose.ui.graphics.colorspace.Rgb;
import androidx.compose.ui.graphics.colorspace.WhitePoint;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nColorSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpaceKt\n+ 2 Connector.kt\nandroidx/compose/ui/graphics/colorspace/ConnectorKt\n+ 3 IntObjectMap.kt\nandroidx/collection/MutableIntObjectMap\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,802:1\n347#2:803\n728#3:804\n1#4:805\n*S KotlinDebug\n*F\n+ 1 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpaceKt\n*L\n460#1:803\n460#1:804\n460#1:805\n*E\n"})
public final class ColorSpaceKt {
    /*
     * WARNING - void declaration
     */
    private static final Connector createConnector-YBCOT_4(ColorSpace source, ColorSpace destination, int intent) {
        void var2_2;
        void var1_1;
        ColorSpace colorSpace;
        if (source == destination) {
            return Connector.Companion.identity$ui_graphics(source);
        }
        if (ColorModel.equals-impl0(source.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw())) {
            if (ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw())) {
                Intrinsics.checkNotNull((Object)source, (String)"null cannot be cast to non-null type androidx.compose.ui.graphics.colorspace.Rgb");
                Rgb rgb = (Rgb)source;
                Intrinsics.checkNotNull((Object)destination, (String)"null cannot be cast to non-null type androidx.compose.ui.graphics.colorspace.Rgb");
                return new Connector.RgbConnector(rgb, (Rgb)destination, intent, null);
            }
        }
        return new Connector(colorSpace, (ColorSpace)var1_1, (int)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final Connector connect-YBCOT_4(ColorSpace $this$connect_u2dYBCOT_4, ColorSpace destination, int intent) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$connect_u2dYBCOT_4, (String)"$this$connect");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        int srcId = $this$connect_u2dYBCOT_4.getId$ui_graphics();
        int dstId = destination.getId$ui_graphics();
        if ((srcId | dstId) < 0) {
            return ColorSpaceKt.createConnector-YBCOT_4($this$connect_u2dYBCOT_4, destination, intent);
        }
        MutableIntObjectMap<Connector> mutableIntObjectMap = ConnectorKt.getConnectors();
        int key$iv = srcId | dstId << 6 | intent << 12;
        Object object = this_$iv.get(key$iv);
        if (object == null) {
            void var1_1;
            void var3_3;
            void var2_2;
            Connector connector;
            connector = ColorSpaceKt.createConnector-YBCOT_4((ColorSpace)((Object)connector), destination, (int)var2_2);
            Connector it$iv = connector;
            this_$iv.set((int)var3_3, (Object)var1_1);
            object = connector;
        }
        return (Connector)object;
    }

    public static /* synthetic */ ColorSpace adapt$default$1056e238(ColorSpace object, WhitePoint whitePoint, Adaptation adaptation, int n) {
        Rgb rgb;
        adaptation = Adaptation.Companion.getBradford();
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)adaptation, (String)"adaptation");
        if (ColorModel.equals-impl0(((ColorSpace)object).getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) && !ColorSpaceKt.compare((rgb = (Rgb)object).getWhitePoint(), whitePoint)) {
            object = whitePoint.toXyz$ui_graphics();
            float[] fArray = ColorSpaceKt.chromaticAdaptation(adaptation.getTransform$ui_graphics(), rgb.getWhitePoint().toXyz$ui_graphics(), (float[])object);
            object = fArray;
            object = ColorSpaceKt.mul3x3(fArray, rgb.getTransform$ui_graphics());
            return new Rgb(rgb, (float[])object, whitePoint);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static final double rcpResponse(double x, double a, double b, double c, double d, double g) {
        double d2;
        if (x >= d * c) {
            void var2_2;
            return (Math.pow(x, 1.0 / g) - b) / var2_2;
        }
        return d2 / c;
    }

    /*
     * WARNING - void declaration
     */
    public static final double response(double x, double a, double b, double c, double d, double g) {
        double d2;
        if (x >= d) {
            void var2_2;
            return Math.pow((double)(var2_2 * x + b), g);
        }
        return c * d2;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean compare(WhitePoint a, WhitePoint b) {
        void var1_1;
        WhitePoint whitePoint;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a == b) {
            return true;
        }
        return Math.abs(a.getX() - b.getX()) < 0.001f && Math.abs(whitePoint.getY() - var1_1.getY()) < 0.001f;
    }

    /*
     * WARNING - void declaration
     */
    public static final float[] inverse3x3(float[] m) {
        float[] fArray;
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        float a = m[0];
        float b = m[3];
        float c = m[6];
        float d = m[1];
        float e = m[4];
        float f = m[7];
        float g = m[2];
        float h = m[5];
        float i = m[8];
        float xA = e * i - f * h;
        float xB = f * g - d * i;
        float xC = d * h - e * g;
        float det = a * xA + b * xB + c * xC;
        float[] fArray2 = new float[m.length];
        float[] inverted = fArray2;
        fArray2[0] = xA / det;
        inverted[1] = xB / det;
        inverted[2] = xC / det;
        inverted[3] = (c * h - b * i) / det;
        inverted[4] = (a * i - c * g) / det;
        inverted[5] = (b * g - a * h) / det;
        inverted[6] = (b * f - c * e) / det;
        inverted[7] = (var3_3 * d - a * f) / det;
        inverted[8] = (var1_1 * e - var2_2 * d) / det;
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public static final float[] mul3x3(float[] lhs, float[] rhs) {
        void var2_2;
        void var1_1;
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        float[] fArray2 = new float[9];
        float[] r = fArray2;
        fArray2[0] = lhs[0] * rhs[0] + lhs[3] * rhs[1] + lhs[6] * rhs[2];
        r[1] = lhs[1] * rhs[0] + lhs[4] * rhs[1] + lhs[7] * rhs[2];
        r[2] = lhs[2] * rhs[0] + lhs[5] * rhs[1] + lhs[8] * rhs[2];
        r[3] = lhs[0] * rhs[3] + lhs[3] * rhs[4] + lhs[6] * rhs[5];
        r[4] = lhs[1] * rhs[3] + lhs[4] * rhs[4] + lhs[7] * rhs[5];
        r[5] = lhs[2] * rhs[3] + lhs[5] * rhs[4] + lhs[8] * rhs[5];
        r[6] = lhs[0] * rhs[6] + lhs[3] * rhs[7] + lhs[6] * rhs[8];
        r[7] = lhs[1] * rhs[6] + lhs[4] * rhs[7] + lhs[7] * rhs[8];
        r[8] = lhs[2] * rhs[6] + lhs[5] * rhs[7] + fArray[8] * var1_1[8];
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final float[] mul3x3Float3(float[] lhs, float[] rhs) {
        void var1_1;
        float[] fArray;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        float r0 = rhs[0];
        float r1 = rhs[1];
        float r2 = rhs[2];
        rhs[0] = lhs[0] * r0 + lhs[3] * r1 + lhs[6] * r2;
        rhs[1] = lhs[1] * r0 + lhs[4] * r1 + lhs[7] * r2;
        rhs[2] = lhs[2] * var2_2 + lhs[5] * var3_3 + fArray[8] * r2;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final float[] mul3x3Diag(float[] lhs, float[] rhs) {
        void var1_1;
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        float[] fArray2 = new float[9];
        float[] fArray3 = fArray2;
        fArray2[0] = lhs[0] * rhs[0];
        fArray3[1] = lhs[1] * rhs[1];
        fArray3[2] = lhs[2] * rhs[2];
        fArray3[3] = lhs[0] * rhs[3];
        fArray3[4] = lhs[1] * rhs[4];
        fArray3[5] = lhs[2] * rhs[5];
        fArray3[6] = lhs[0] * rhs[6];
        fArray3[7] = lhs[1] * rhs[7];
        fArray3[8] = fArray[2] * var1_1[8];
        return fArray3;
    }

    /*
     * WARNING - void declaration
     */
    public static final float[] chromaticAdaptation(float[] matrix, float[] srcWhitePoint, float[] dstWhitePoint) {
        float[] fArray;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)srcWhitePoint, (String)"srcWhitePoint");
        Intrinsics.checkNotNullParameter((Object)dstWhitePoint, (String)"dstWhitePoint");
        float[] srcLMS = ColorSpaceKt.mul3x3Float3(matrix, srcWhitePoint);
        float[] dstLMS = ColorSpaceKt.mul3x3Float3(matrix, dstWhitePoint);
        float[] fArray2 = new float[3];
        float[] fArray3 = fArray2;
        fArray2[0] = dstLMS[0] / srcLMS[0];
        fArray3[1] = dstLMS[1] / srcLMS[1];
        fArray3[2] = var2_2[2] / srcLMS[2];
        float[] LMS = fArray3;
        return ColorSpaceKt.mul3x3(ColorSpaceKt.inverse3x3(matrix), ColorSpaceKt.mul3x3Diag((float[])var1_1, fArray));
    }
}

