/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\t\u0010\nJ+\u0010\f\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\f\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0013\u0010\u001a\u001a\u00020\u0004*\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u0013\u0010\u001b\u001a\u00020\u0004*\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0018R\u0016\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001cR\u0016\u0010\f\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\u001cR\u0017\u0010\u001e\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010#\u001a\u00020\"8\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u0016\u0010\u000e\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u001cR\u0016\u0010\r\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001c"}, d2={"Lokio/Throttler;", "", "<init>", "()V", "", "allocatedUntil", "(J)V", "now", "byteCount", "byteCountOrWaitNanos$okio", "(JJ)J", "byteCountOrWaitNanos", "bytesPerSecond", "waitByteCount", "maxByteCount", "", "(JJJ)V", "Lokio/Sink;", "sink", "(Lokio/Sink;)Lokio/Sink;", "Lokio/Source;", "source", "(Lokio/Source;)Lokio/Source;", "take$okio", "(J)J", "take", "bytesToNanos", "nanosToBytes", "J", "Ljava/util/concurrent/locks/Condition;", "condition", "Ljava/util/concurrent/locks/Condition;", "getCondition", "()Ljava/util/concurrent/locks/Condition;", "Ljava/util/concurrent/locks/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;"})
public final class Throttler {
    private long allocatedUntil;
    private long bytesPerSecond;
    private long waitByteCount;
    private long maxByteCount;
    private final ReentrantLock lock;
    private final Condition condition;

    /*
     * WARNING - void declaration
     */
    public Throttler(long allocatedUntil) {
        void var1_1;
        this.allocatedUntil = var1_1;
        this.waitByteCount = 8192L;
        this.maxByteCount = 262144L;
        this.lock = new ReentrantLock();
        Condition condition = this.lock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"newCondition(...)");
        this.condition = condition;
    }

    public final ReentrantLock getLock() {
        return this.lock;
    }

    public final Condition getCondition() {
        return this.condition;
    }

    public Throttler() {
        this(System.nanoTime());
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void bytesPerSecond(long bytesPerSecond2, long waitByteCount, long maxByteCount) {
        Lock lock = this.lock;
        lock.lock();
        try {
            void var3_6;
            void var1_1;
            if (!(bytesPerSecond2 >= 0L)) {
                String bytesPerSecond2 = "Failed requirement.";
                throw new IllegalArgumentException(bytesPerSecond2.toString());
            }
            if (!(waitByteCount > 0L)) {
                String bytesPerSecond2 = "Failed requirement.";
                throw new IllegalArgumentException(bytesPerSecond2.toString());
            }
            if (!(maxByteCount >= waitByteCount)) {
                String bytesPerSecond2 = "Failed requirement.";
                throw new IllegalArgumentException(bytesPerSecond2.toString());
            }
            this.bytesPerSecond = var1_1;
            this.waitByteCount = var3_6;
            this.maxByteCount = maxByteCount;
            this.condition.signalAll();
            return;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ void bytesPerSecond$default(Throttler throttler, long l, long l2, long l3, int n, Object object) {
        if ((n & 2) != 0) {
            l2 = throttler.waitByteCount;
        }
        if ((n & 4) != 0) {
            l3 = throttler.maxByteCount;
        }
        throttler.bytesPerSecond(l, l2, l3);
    }

    public final long take$okio(long byteCount2) {
        if (!(byteCount2 > 0L)) {
            String byteCount2 = "Failed requirement.";
            throw new IllegalArgumentException(byteCount2.toString());
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            while (true) {
                long byteCount2;
                long now;
                long byteCountOrWaitNanos;
                if ((byteCountOrWaitNanos = this.byteCountOrWaitNanos$okio(now = System.nanoTime(), byteCount2)) >= 0L) {
                    return byteCountOrWaitNanos;
                }
                this.condition.awaitNanos(-byteCountOrWaitNanos);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final long byteCountOrWaitNanos$okio(long now, long byteCount) {
        void var3_2;
        if (this.bytesPerSecond == 0L) {
            return byteCount;
        }
        long idleInNanos = Math.max(this.allocatedUntil - now, 0L);
        long immediateBytes = this.maxByteCount - this.nanosToBytes(idleInNanos);
        if (immediateBytes >= byteCount) {
            this.allocatedUntil = now + idleInNanos + this.bytesToNanos(byteCount);
            return byteCount;
        }
        if (immediateBytes >= this.waitByteCount) {
            Throttler throttler = this;
            this.allocatedUntil = now + throttler.bytesToNanos(throttler.maxByteCount);
            return immediateBytes;
        }
        long minByteCount = Math.min(this.waitByteCount, (long)var3_2);
        long minWaitNanos = idleInNanos + this.bytesToNanos(minByteCount - this.maxByteCount);
        if (minWaitNanos == 0L) {
            void var1_1;
            Throttler throttler = this;
            this.allocatedUntil = var1_1 + throttler.bytesToNanos(throttler.maxByteCount);
            return minByteCount;
        }
        return -minWaitNanos;
    }

    private final long nanosToBytes(long $this$nanosToBytes) {
        return $this$nanosToBytes * this.bytesPerSecond / 1000000000L;
    }

    private final long bytesToNanos(long $this$bytesToNanos) {
        return $this$bytesToNanos * 1000000000L / this.bytesPerSecond;
    }

    /*
     * WARNING - void declaration
     */
    public final Source source(Source source2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        return new ForwardingSource((Source)var1_1, this){
            final /* synthetic */ Throttler this$0;
            {
                void var1_1;
                void var2_2;
                this.this$0 = var2_2;
                super((Source)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final long read(Buffer sink2, long byteCount) {
                Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
                try {
                    void var1_1;
                    void var2_2;
                    long toRead = this.this$0.take$okio((long)var2_2);
                    return super.read((Buffer)var1_1, toRead);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("interrupted");
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final Sink sink(Sink sink2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        return new ForwardingSink((Sink)var1_1, this){
            final /* synthetic */ Throttler this$0;
            {
                void var1_1;
                void var2_2;
                this.this$0 = var2_2;
                super((Sink)var1_1);
            }

            public final void write(Buffer source2, long byteCount) throws IOException {
                Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
                try {
                    long toWrite;
                    for (void remaining = var2_2; remaining > 0L; remaining -= toWrite) {
                        toWrite = this.this$0.take$okio((long)remaining);
                        super.write(source2, toWrite);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("interrupted");
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void bytesPerSecond(long bytesPerSecond, long waitByteCount) {
        void var3_2;
        void var1_1;
        Throttler.bytesPerSecond$default(this, (long)var1_1, (long)var3_2, 0L, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void bytesPerSecond(long bytesPerSecond) {
        void var1_1;
        Throttler.bytesPerSecond$default(this, (long)var1_1, 0L, 0L, 6, null);
    }
}

