/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.NioFileSystemFileHandle;
import okio.NioSystemFileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0011J\u001f\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001fJ\u001f\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b \u0010\u001dJ\u0019\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b%\u0010&J'\u0010'\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010)\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b)\u0010\fJ\u0017\u0010\r\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010+J\u000f\u0010-\u001a\u00020,H\u0016\u00a2\u0006\u0004\b-\u0010.J\u0013\u00100\u001a\u00020/*\u00020\u0006H\u0002\u00a2\u0006\u0004\b0\u00101R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00102"}, d2={"Lokio/NioFileSystemWrappingFileSystem;", "Lokio/NioSystemFileSystem;", "Ljava/nio/file/FileSystem;", "nioFileSystem", "<init>", "(Ljava/nio/file/FileSystem;)V", "Lokio/Path;", "file", "", "mustExist", "Lokio/Sink;", "appendingSink", "(Lokio/Path;Z)Lokio/Sink;", "source", "target", "", "atomicMove", "(Lokio/Path;Lokio/Path;)V", "path", "canonicalize", "(Lokio/Path;)Lokio/Path;", "dir", "mustCreate", "createDirectory", "(Lokio/Path;Z)V", "createSymlink", "delete", "", "list", "(Lokio/Path;)Ljava/util/List;", "throwOnFailure", "(Lokio/Path;Z)Ljava/util/List;", "listOrNull", "Lokio/FileMetadata;", "metadataOrNull", "(Lokio/Path;)Lokio/FileMetadata;", "Lokio/FileHandle;", "openReadOnly", "(Lokio/Path;)Lokio/FileHandle;", "openReadWrite", "(Lokio/Path;ZZ)Lokio/FileHandle;", "sink", "Lokio/Source;", "(Lokio/Path;)Lokio/Source;", "", "toString", "()Ljava/lang/String;", "Ljava/nio/file/Path;", "resolve", "(Lokio/Path;)Ljava/nio/file/Path;", "Ljava/nio/file/FileSystem;"})
@SourceDebugExtension(value={"SMAP\nNioFileSystemWrappingFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NioFileSystemWrappingFileSystem.kt\nokio/NioFileSystemWrappingFileSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,192:1\n1620#2,3:193\n1#3:196\n37#4,2:197\n37#4,2:199\n37#4,2:201\n*S KotlinDebug\n*F\n+ 1 NioFileSystemWrappingFileSystem.kt\nokio/NioFileSystemWrappingFileSystem\n*L\n77#1:193,3\n104#1:197,2\n125#1:199,2\n138#1:201,2\n*E\n"})
public final class NioFileSystemWrappingFileSystem
extends NioSystemFileSystem {
    private final java.nio.file.FileSystem nioFileSystem;

    /*
     * WARNING - void declaration
     */
    public NioFileSystemWrappingFileSystem(java.nio.file.FileSystem nioFileSystem) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)nioFileSystem, (String)"nioFileSystem");
        this.nioFileSystem = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final java.nio.file.Path resolve(Path $this$resolve) {
        void var1_1;
        java.nio.file.Path path = this.nioFileSystem.getPath(var1_1.toString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Path canonicalize(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            java.nio.file.Path path2 = this.resolve(path).toRealPath(new LinkOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toRealPath(...)");
            return Path.Companion.get$default(Path.Companion, path2, false, 1, null);
        }
        catch (NoSuchFileException noSuchFileException) {
            void var1_1;
            throw new FileNotFoundException("no such file: " + var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final FileMetadata metadataOrNull(Path path) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        NioFileSystemWrappingFileSystem nioFileSystemWrappingFileSystem = this;
        return nioFileSystemWrappingFileSystem.metadataOrNull(nioFileSystemWrappingFileSystem.resolve((Path)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Path> list(Path dir) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        List<Path> list = this.list((Path)var1_1, true);
        Intrinsics.checkNotNull(list);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Path> listOrNull(Path dir) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.list((Path)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> list(Path dir, boolean throwOnFailure) {
        void var2_3;
        Iterator iterator;
        Collection<Path> collection;
        java.nio.file.Path nioDir = this.resolve((Path)dir);
        try {
            collection = PathsKt.listDirectoryEntries$default((java.nio.file.Path)nioDir, null, (int)1, null);
        }
        catch (Exception exception) {
            if (throwOnFailure) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(nioDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    throw new FileNotFoundException("no such file: " + dir);
                }
                throw new IOException("failed to list " + dir);
            }
            return null;
        }
        dir = collection;
        dir = (Iterable)dir;
        Collection destination$iv = new ArrayList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            Object item$iv = iterator.next();
            item$iv = (java.nio.file.Path)item$iv;
            collection = destination$iv;
            collection.add(Path.Companion.get$default(Path.Companion, (java.nio.file.Path)var3_4, false, 1, null));
        }
        List result = (List)var2_3;
        CollectionsKt.sort((List)result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final FileHandle openReadOnly(Path file) {
        void var1_1;
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            OpenOption[] openOptionArray = new OpenOption[1];
            object = openOptionArray;
            openOptionArray[0] = StandardOpenOption.READ;
            object = FileChannel.open(this.resolve(file), object);
        }
        catch (NoSuchFileException noSuchFileException) {
            throw new FileNotFoundException("no such file: " + file);
        }
        Object channel = object;
        Intrinsics.checkNotNull((Object)channel);
        return new NioFileSystemFileHandle(false, (FileChannel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final FileHandle openReadWrite(Path file, boolean mustCreate, boolean mustExist) {
        Object object;
        void var3_4;
        List list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(!mustCreate || !mustExist)) {
            String string = "Cannot require mustCreate and mustExist at the same time.";
            throw new IllegalArgumentException(string.toString());
        }
        List $this$openReadWrite_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        list.add(StandardOpenOption.READ);
        $this$openReadWrite_u24lambda_u242.add(StandardOpenOption.WRITE);
        if (mustCreate) {
            $this$openReadWrite_u24lambda_u242.add(StandardOpenOption.CREATE_NEW);
        } else if (var3_4 == false) {
            $this$openReadWrite_u24lambda_u242.add(StandardOpenOption.CREATE);
        }
        List openOptions = CollectionsKt.build((List)list);
        try {
            Collection collection;
            Collection collection2 = collection;
            collection = collection2;
            collection = collection2;
            object = collection2.toArray(new StandardOpenOption[0]);
            object = FileChannel.open(this.resolve(file), Arrays.copyOf(object, ((StandardOpenOption[])object).length));
        }
        catch (NoSuchFileException noSuchFileException) {
            void var1_1;
            throw new FileNotFoundException("no such file: " + var1_1);
        }
        Object channel = object;
        Intrinsics.checkNotNull((Object)channel);
        return new NioFileSystemFileHandle(true, (FileChannel)channel);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Source source(Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream2 = Files.newInputStream(this.resolve(file), Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"newInputStream(...)");
            return Okio.source(inputStream2);
        }
        catch (NoSuchFileException noSuchFileException) {
            void var1_1;
            throw new FileNotFoundException("no such file: " + var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Sink sink(Path file, boolean mustCreate) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List $this$sink_u24lambda_u243 = iterable = CollectionsKt.createListBuilder();
        if (mustCreate) {
            $this$sink_u24lambda_u243.add(StandardOpenOption.CREATE_NEW);
        }
        List openOptions = CollectionsKt.build((List)iterable);
        try {
            Collection collection;
            iterable = this.resolve(file);
            Collection collection2 = collection;
            collection = collection2;
            collection = collection2;
            OpenOption[] openOptionArray = collection2.toArray(new StandardOpenOption[0]);
            openOptionArray = Arrays.copyOf(openOptionArray, openOptionArray.length);
            OutputStream outputStream2 = Files.newOutputStream((java.nio.file.Path)iterable, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"newOutputStream(...)");
            return Okio.sink(outputStream2);
        }
        catch (NoSuchFileException noSuchFileException) {
            void var1_1;
            throw new FileNotFoundException("no such file: " + var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Sink appendingSink(Path file, boolean mustExist) {
        void var2_3;
        Collection collection;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List $this$appendingSink_u24lambda_u244 = iterable = CollectionsKt.createListBuilder();
        iterable.add(StandardOpenOption.APPEND);
        if (!mustExist) {
            $this$appendingSink_u24lambda_u244.add(StandardOpenOption.CREATE);
        }
        List openOptions = CollectionsKt.build((List)iterable);
        iterable = this.resolve((Path)((Object)collection));
        Collection collection2 = (Collection)var2_3;
        collection = collection2;
        collection = collection2;
        OpenOption[] openOptionArray = collection2.toArray(new StandardOpenOption[0]);
        openOptionArray = Arrays.copyOf(openOptionArray, openOptionArray.length);
        OutputStream outputStream2 = Files.newOutputStream((java.nio.file.Path)iterable, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"newOutputStream(...)");
        return Okio.sink(outputStream2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void createDirectory(Path dir, boolean mustCreate) {
        boolean alreadyExist;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        FileMetadata fileMetadata = ((FileSystem)this).metadataOrNull(dir);
        boolean bl = fileMetadata != null ? fileMetadata.isDirectory() : (alreadyExist = false);
        if (bl && mustCreate) {
            throw new IOException(dir + " already exists.");
        }
        try {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectory(this.resolve(dir), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectory(...)");
            return;
        }
        catch (IOException e) {
            void var2_3;
            void var1_1;
            void var3_4;
            if (var3_4 != false) {
                return;
            }
            throw new IOException("failed to create directory: " + var1_1, (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void atomicMove(Path source2, Path target) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        try {
            java.nio.file.Path path;
            source2 = this.resolve((Path)source2);
            path = this.resolve((Path)((Object)path));
            CopyOption[] copyOptionArray = new CopyOption[2];
            CopyOption[] copyOptionArray2 = copyOptionArray;
            copyOptionArray[0] = StandardCopyOption.ATOMIC_MOVE;
            copyOptionArray2[1] = StandardCopyOption.REPLACE_EXISTING;
            Intrinsics.checkNotNullExpressionValue((Object)Files.move((java.nio.file.Path)source2, path, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"move(...)");
            return;
        }
        catch (NoSuchFileException e) {
            void var1_2;
            throw new FileNotFoundException(var1_2.getMessage());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new IOException("atomic move not supported");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void delete(Path path, boolean mustExist) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (Thread.interrupted()) {
                throw new InterruptedIOException("interrupted");
            }
            java.nio.file.Path nioPath = this.resolve(path);
            try {
                Files.delete(nioPath);
                return;
            }
            catch (NoSuchFileException noSuchFileException) {
                void var2_2;
                if (var2_2 != false) {
                    throw new FileNotFoundException("no such file: " + path);
                }
            }
            catch (IOException iOException) {
                void var1_1;
                void var3_3;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists((java.nio.file.Path)var3_3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block5;
                throw new IOException("failed to delete " + var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void createSymlink(Path source2, Path target) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createSymbolicLink(this.resolve((Path)var1_1), this.resolve((Path)var2_2), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createSymbolicLink(...)");
    }

    @Override
    public final String toString() {
        String string = Reflection.getOrCreateKotlinClass(this.nioFileSystem.getClass()).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }
}

