/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.InflaterSource;
import okio.RealBufferedSource;
import okio.Segment;
import okio.Source;
import okio.Timeout;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u001f\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J'\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0018\u0010 \u001a\u00060\u001ej\u0002`\u001f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0018\u0010$\u001a\u00060\"j\u0002`#8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0014\u0010'\u001a\u00020&8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010*\u001a\u00020)8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010\u0002\u001a\u00020,8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010-"}, d2={"Lokio/GzipSource;", "Lokio/Source;", "source", "<init>", "(Lokio/Source;)V", "", "name", "", "expected", "actual", "", "checkEqual", "(Ljava/lang/String;II)V", "close", "()V", "consumeHeader", "consumeTrailer", "Lokio/Buffer;", "sink", "", "byteCount", "read", "(Lokio/Buffer;J)J", "Lokio/Timeout;", "timeout", "()Lokio/Timeout;", "buffer", "offset", "updateCrc", "(Lokio/Buffer;JJ)V", "Ljava/util/zip/CRC32;", "Lokio/internal/CRC32;", "crc", "Ljava/util/zip/CRC32;", "Ljava/util/zip/Inflater;", "Lokio/Inflater;", "inflater", "Ljava/util/zip/Inflater;", "Lokio/InflaterSource;", "inflaterSource", "Lokio/InflaterSource;", "", "section", "B", "Lokio/RealBufferedSource;", "Lokio/RealBufferedSource;"})
@SourceDebugExtension(value={"SMAP\nGzipSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GzipSource.kt\nokio/GzipSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 RealBufferedSource.kt\nokio/RealBufferedSource\n+ 4 GzipSource.kt\nokio/-GzipSourceExtensions\n+ 5 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,222:1\n1#2:223\n62#3:224\n62#3:226\n62#3:228\n62#3:229\n62#3:230\n62#3:232\n62#3:234\n204#4:225\n204#4:227\n204#4:231\n204#4:233\n89#5:235\n*S KotlinDebug\n*F\n+ 1 GzipSource.kt\nokio/GzipSource\n*L\n103#1:224\n105#1:226\n117#1:228\n118#1:229\n120#1:230\n131#1:232\n142#1:234\n104#1:225\n115#1:227\n128#1:231\n139#1:233\n185#1:235\n*E\n"})
public final class GzipSource
implements Source {
    private byte section;
    private final RealBufferedSource source;
    private final Inflater inflater;
    private final InflaterSource inflaterSource;
    private final CRC32 crc;

    /*
     * WARNING - void declaration
     */
    public GzipSource(Source source2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        this.source = new RealBufferedSource((Source)var1_1);
        this.inflater = new Inflater(true);
        this.inflaterSource = new InflaterSource(this.source, this.inflater);
        this.crc = new CRC32();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long read(Buffer sink2, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        if (!(byteCount >= 0L)) {
            String string = "byteCount < 0: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        if (byteCount == 0L) {
            return 0L;
        }
        if (this.section == 0) {
            this.consumeHeader();
            this.section = 1;
        }
        if (this.section == 1) {
            void var2_2;
            long offset = sink2.size();
            long result = this.inflaterSource.read(sink2, (long)var2_2);
            if (result != -1L) {
                void var1_1;
                this.updateCrc((Buffer)var1_1, offset, result);
                return result;
            }
            this.section = (byte)2;
        }
        if (this.section == 2) {
            this.consumeTrailer();
            this.section = (byte)3;
            if (!this.source.exhausted()) {
                throw new IOException("gzip finished without exhausting source");
            }
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    private final void consumeHeader() throws IOException {
        void var2_2;
        void var1_3;
        long index;
        void var3_5;
        this.source.require(10L);
        RealBufferedSource realBufferedSource = this.source;
        byte flags = realBufferedSource.bufferField.getByte(3L);
        boolean fhcrc = (flags >> 1 & 1) == 1;
        if (fhcrc) {
            GzipSource gzipSource = this;
            RealBufferedSource realBufferedSource2 = gzipSource.source;
            gzipSource.updateCrc(realBufferedSource2.bufferField, 0L, 10L);
        }
        short id1id2 = this.source.readShort();
        this.checkEqual("ID1ID2", 8075, (int)var3_5);
        this.source.skip(8L);
        if ((flags >> 2 & 1) == 1) {
            this.source.require(2L);
            if (fhcrc) {
                GzipSource gzipSource = this;
                RealBufferedSource realBufferedSource3 = gzipSource.source;
                gzipSource.updateCrc(realBufferedSource3.bufferField, 0L, 2L);
            }
            RealBufferedSource realBufferedSource4 = this.source;
            long xlen = realBufferedSource4.bufferField.readShortLe() & 0xFFFF;
            this.source.require(xlen);
            if (fhcrc) {
                GzipSource gzipSource = this;
                realBufferedSource4 = gzipSource.source;
                gzipSource.updateCrc(realBufferedSource4.bufferField, 0L, xlen);
            }
            this.source.skip(xlen);
        }
        if ((flags >> 3 & 1) == 1) {
            index = this.source.indexOf((byte)0);
            if (index == -1L) {
                throw new EOFException();
            }
            if (fhcrc) {
                GzipSource gzipSource = this;
                RealBufferedSource realBufferedSource5 = gzipSource.source;
                gzipSource.updateCrc(realBufferedSource5.bufferField, 0L, index + 1L);
            }
            this.source.skip(index + 1L);
        }
        if ((var1_3 >> 4 & 1) == 1) {
            index = this.source.indexOf((byte)0);
            if (index == -1L) {
                throw new EOFException();
            }
            if (fhcrc) {
                GzipSource gzipSource = this;
                RealBufferedSource realBufferedSource6 = gzipSource.source;
                gzipSource.updateCrc(realBufferedSource6.bufferField, 0L, index + 1L);
            }
            this.source.skip(index + 1L);
        }
        if (var2_2 != false) {
            this.checkEqual("FHCRC", this.source.readShortLe(), (short)this.crc.getValue());
            this.crc.reset();
        }
    }

    private final void consumeTrailer() throws IOException {
        this.checkEqual("CRC", this.source.readIntLe(), (int)this.crc.getValue());
        this.checkEqual("ISIZE", this.source.readIntLe(), (int)this.inflater.getBytesWritten());
    }

    @Override
    public final Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public final void close() throws IOException {
        this.inflaterSource.close();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateCrc(Buffer buffer, long offset, long byteCount) {
        long offset2;
        long byteCount2 = byteCount;
        Segment segment = buffer.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment s = segment;
        for (offset2 = offset; offset2 >= (long)(s.limit - s.pos); offset2 -= (long)(s.limit - s.pos)) {
            Intrinsics.checkNotNull((Object)s.next);
        }
        while (byteCount2 > 0L) {
            void var2_3;
            int pos = (int)((long)s.pos + offset2);
            int n = s.limit - pos;
            int toUpdate = (int)Math.min((long)n, byteCount2);
            this.crc.update(s.data, (int)var2_3, toUpdate);
            byteCount2 -= (long)n;
            offset2 = 0L;
            Intrinsics.checkNotNull((Object)s.next);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEqual(String name, int expected, int actual) {
        if (actual != expected) {
            void var2_2;
            void var3_3;
            void var1_1;
            throw new IOException((String)var1_1 + ": actual 0x" + StringsKt.padStart((String)-SegmentedByteString.toHexString((int)var3_3), (int)8, (char)'0') + " != expected 0x" + StringsKt.padStart((String)-SegmentedByteString.toHexString((int)var2_2), (int)8, (char)'0'));
        }
    }
}

