/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi.internal;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;

public final class OSInfo {
    private static final HashMap<String, String> archMapping = new HashMap<String, String>();

    public static String getNativeLibFolderPathForCurrentOS() {
        return OSInfo.getOSName() + "/" + OSInfo.getArchName();
    }

    public static String getOSName() {
        return OSInfo.translateOSNameToFolderName(System.getProperty("os.name"));
    }

    private static boolean isAndroid() {
        return System.getProperty("java.runtime.name", "").toLowerCase().contains("android");
    }

    /*
     * WARNING - void declaration
     */
    private static String getHardwareName() {
        Object object;
        Process p = Runtime.getRuntime().exec("uname -m");
        p.waitFor();
        InputStream in = p.getInputStream();
        try {
            int n;
            object = in;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[32];
            while ((n = ((InputStream)object).read(byArray, 0, byArray.length)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            object = byteArrayOutputStream.toString();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Throwable e) {
                void var0_1;
                System.err.println("Error while running uname -m: " + var0_1.getMessage());
                return "unknown";
            }
        }
        in.close();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static String resolveArmArchType() {
        if (System.getProperty("os.name").contains("Linux")) {
            void var0;
            String armType = OSInfo.getHardwareName();
            if (armType.startsWith("armv6")) {
                return "armv6";
            }
            if (armType.startsWith("armv7")) {
                return "armv7";
            }
            if (armType.startsWith("armv5")) {
                return "arm";
            }
            if (armType.equals("aarch64")) {
                return "arm64";
            }
            String abi = System.getProperty("sun.arch.abi");
            if (abi != null && var0.startsWith("gnueabihf")) {
                return "armv7";
            }
        }
        return "arm";
    }

    /*
     * WARNING - void declaration
     */
    public static String getArchName() {
        void var0;
        String osArch = System.getProperty("os.arch");
        if (OSInfo.isAndroid()) {
            return "android-arm";
        }
        if (osArch.startsWith("arm")) {
            osArch = OSInfo.resolveArmArchType();
        } else {
            String lc = osArch.toLowerCase(Locale.US);
            if (archMapping.containsKey(lc)) {
                void var1_1;
                return archMapping.get(var1_1);
            }
        }
        return OSInfo.translateArchNameToFolderName((String)var0);
    }

    private static String translateOSNameToFolderName(String osName) {
        String string;
        if (osName.contains("Windows")) {
            return "Windows";
        }
        if (osName.contains("Mac") || osName.contains("Darwin")) {
            return "Mac";
        }
        if (osName.contains("Linux")) {
            return "Linux";
        }
        if (osName.contains("AIX")) {
            return "AIX";
        }
        return string.replaceAll("\\W", "");
    }

    private static String translateArchNameToFolderName(String archName) {
        return archName.replaceAll("\\W", "");
    }

    static {
        archMapping.put("x86", "x86");
        archMapping.put("i386", "x86");
        archMapping.put("i486", "x86");
        archMapping.put("i586", "x86");
        archMapping.put("i686", "x86");
        archMapping.put("pentium", "x86");
        archMapping.put("x86_64", "x86_64");
        archMapping.put("amd64", "x86_64");
        archMapping.put("em64t", "x86_64");
        archMapping.put("universal", "x86_64");
        archMapping.put("ia64", "ia64");
        archMapping.put("ia64w", "ia64");
        archMapping.put("ia64_32", "ia64_32");
        archMapping.put("ia64n", "ia64_32");
        archMapping.put("ppc", "ppc");
        archMapping.put("power", "ppc");
        archMapping.put("powerpc", "ppc");
        archMapping.put("power_pc", "ppc");
        archMapping.put("power_rs", "ppc");
        archMapping.put("ppc64", "ppc64");
        archMapping.put("power64", "ppc64");
        archMapping.put("powerpc64", "ppc64");
        archMapping.put("power_pc64", "ppc64");
        archMapping.put("power_rs64", "ppc64");
        archMapping.put("aarch64", "arm64");
    }
}

