/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.AbstractIterator;
import kotlin.io.AccessDeniedException;
import kotlin.io.FileWalkDirection;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u000f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003$%&B\u008b\u0001\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006\u00128\u0010\u0011\u001a4\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015B\u001b\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0096\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J!\u0010\b\u001a\u00020\u00002\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\u001bJ!\u0010\n\u001a\u00020\u00002\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0004\b\n\u0010\u001bJ'\u0010\u0011\u001a\u00020\u00002\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0004\b\u0011\u0010\u001cJ\u0015\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u001eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010 R\"\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010!R\"\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010!RF\u0010\u0011\u001a4\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\"R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010#"}, d2={"Lkotlin/io/FileTreeWalk;", "Lkotlin/sequences/Sequence;", "Ljava/io/File;", "start", "Lkotlin/io/FileWalkDirection;", "direction", "Lkotlin/Function1;", "", "onEnter", "", "onLeave", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "f", "Ljava/io/IOException;", "e", "onFail", "", "maxDepth", "<init>", "(Ljava/io/File;Lkotlin/io/FileWalkDirection;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;I)V", "(Ljava/io/File;Lkotlin/io/FileWalkDirection;)V", "", "iterator", "()Ljava/util/Iterator;", "function", "(Lkotlin/jvm/functions/Function1;)Lkotlin/io/FileTreeWalk;", "(Lkotlin/jvm/functions/Function2;)Lkotlin/io/FileTreeWalk;", "depth", "(I)Lkotlin/io/FileTreeWalk;", "Ljava/io/File;", "Lkotlin/io/FileWalkDirection;", "Lkotlin/jvm/functions/Function1;", "Lkotlin/jvm/functions/Function2;", "I", "WalkState", "DirectoryState", "FileTreeWalkIterator"})
public final class FileTreeWalk
implements Sequence<File> {
    private final File start;
    private final FileWalkDirection direction;
    private final Function1<File, Boolean> onEnter;
    private final Function1<File, Unit> onLeave;
    private final Function2<File, IOException, Unit> onFail;
    private final int maxDepth;

    /*
     * WARNING - void declaration
     */
    private FileTreeWalk(File start, FileWalkDirection direction, Function1<? super File, Boolean> onEnter, Function1<? super File, Unit> onLeave, Function2<? super File, ? super IOException, Unit> onFail, int maxDepth) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.start = var1_1;
        this.direction = var2_2;
        this.onEnter = var3_3;
        this.onLeave = onLeave;
        this.onFail = onFail;
        this.maxDepth = maxDepth;
    }

    /* synthetic */ FileTreeWalk(File file, FileWalkDirection fileWalkDirection, Function1 function1, Function1 function12, Function2 function2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            fileWalkDirection = FileWalkDirection.TOP_DOWN;
        }
        if ((n2 & 0x20) != 0) {
            n = Integer.MAX_VALUE;
        }
        this(file, fileWalkDirection, function1, function12, function2, n);
    }

    /*
     * WARNING - void declaration
     */
    public FileTreeWalk(File start, FileWalkDirection direction) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        this((File)var1_1, (FileWalkDirection)var2_2, null, null, null, 0, 32, null);
    }

    public /* synthetic */ FileTreeWalk(File file, FileWalkDirection fileWalkDirection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            fileWalkDirection = FileWalkDirection.TOP_DOWN;
        }
        this(file, fileWalkDirection);
    }

    @Override
    public final Iterator<File> iterator() {
        return new FileTreeWalkIterator(this);
    }

    /*
     * WARNING - void declaration
     */
    public final FileTreeWalk onEnter(Function1<? super File, Boolean> function) {
        void var1_1;
        Intrinsics.checkNotNullParameter(function, "function");
        return new FileTreeWalk(this.start, this.direction, (Function1<? super File, Boolean>)var1_1, this.onLeave, this.onFail, this.maxDepth);
    }

    /*
     * WARNING - void declaration
     */
    public final FileTreeWalk onLeave(Function1<? super File, Unit> function) {
        void var1_1;
        Intrinsics.checkNotNullParameter(function, "function");
        return new FileTreeWalk(this.start, this.direction, this.onEnter, (Function1<? super File, Unit>)var1_1, this.onFail, this.maxDepth);
    }

    /*
     * WARNING - void declaration
     */
    public final FileTreeWalk onFail(Function2<? super File, ? super IOException, Unit> function) {
        void var1_1;
        Intrinsics.checkNotNullParameter(function, "function");
        return new FileTreeWalk(this.start, this.direction, this.onEnter, this.onLeave, (Function2<? super File, ? super IOException, Unit>)var1_1, this.maxDepth);
    }

    /*
     * WARNING - void declaration
     */
    public final FileTreeWalk maxDepth(int depth) {
        void var1_1;
        if (depth <= 0) {
            throw new IllegalArgumentException("depth must be positive, but was " + depth + '.');
        }
        return new FileTreeWalk(this.start, this.direction, this.onEnter, this.onLeave, this.onFail, (int)var1_1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b#\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005"}, d2={"Lkotlin/io/FileTreeWalk$DirectoryState;", "Lkotlin/io/FileTreeWalk$WalkState;", "Ljava/io/File;", "rootDir", "<init>", "(Ljava/io/File;)V"})
    @SourceDebugExtension(value={"SMAP\nFileTreeWalk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileTreeWalk.kt\nkotlin/io/FileTreeWalk$DirectoryState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1#2:274\n*E\n"})
    private static abstract class DirectoryState
    extends WalkState {
        /*
         * WARNING - void declaration
         */
        public DirectoryState(File rootDir) {
            Intrinsics.checkNotNullParameter(rootDir, "rootDir");
            super(rootDir);
            if (_Assertions.ENABLED) {
                void var1_1;
                boolean bl = var1_1.isDirectory();
                if (_Assertions.ENABLED && !bl) {
                    String string = "rootDir must be verified to be directory beforehand.";
                    throw new AssertionError((Object)string);
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0012\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0082\u0010\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011"}, d2={"Lkotlin/io/FileTreeWalk$FileTreeWalkIterator;", "Lkotlin/collections/AbstractIterator;", "Ljava/io/File;", "<init>", "(Lkotlin/io/FileTreeWalk;)V", "", "computeNext", "()V", "root", "Lkotlin/io/FileTreeWalk$DirectoryState;", "directoryState", "(Ljava/io/File;)Lkotlin/io/FileTreeWalk$DirectoryState;", "gotoNext", "()Ljava/io/File;", "Ljava/util/ArrayDeque;", "Lkotlin/io/FileTreeWalk$WalkState;", "state", "Ljava/util/ArrayDeque;", "BottomUpDirectoryState", "TopDownDirectoryState", "SingleFileState"})
    private final class FileTreeWalkIterator
    extends AbstractIterator<File> {
        private final ArrayDeque<WalkState> state = new ArrayDeque();
        final /* synthetic */ FileTreeWalk this$0;

        /*
         * WARNING - void declaration
         */
        public FileTreeWalkIterator(FileTreeWalk this$0) {
            void var1_1;
            this.this$0 = var1_1;
            if (this.this$0.start.isDirectory()) {
                FileTreeWalkIterator fileTreeWalkIterator = this;
                this.state.push(fileTreeWalkIterator.directoryState(fileTreeWalkIterator.this$0.start));
                return;
            }
            if (this.this$0.start.isFile()) {
                FileTreeWalkIterator fileTreeWalkIterator = this;
                this.state.push(new SingleFileState(fileTreeWalkIterator, fileTreeWalkIterator.this$0.start));
                return;
            }
            this.done();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void computeNext() {
            File nextFile = this.gotoNext();
            if (nextFile != null) {
                void var1_1;
                this.setNext(var1_1);
                return;
            }
            this.done();
        }

        /*
         * WARNING - void declaration
         */
        private final DirectoryState directoryState(File root) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.this$0.direction.ordinal()]) {
                case 1: {
                    return new TopDownDirectoryState(this, root);
                }
                case 2: {
                    void var1_1;
                    return new BottomUpDirectoryState(this, (File)var1_1);
                }
            }
            throw new NoWhenBranchMatchedException();
        }

        /*
         * WARNING - void declaration
         */
        private final File gotoNext() {
            FileTreeWalkIterator fileTreeWalkIterator = this;
            while (fileTreeWalkIterator.state.peek() != null) {
                void var3_3;
                void var2_2;
                WalkState topState;
                File file = topState.step();
                if (file == null) {
                    fileTreeWalkIterator.state.pop();
                    continue;
                }
                if (Intrinsics.areEqual(file, var2_2.getRoot()) || !file.isDirectory() || fileTreeWalkIterator.state.size() >= this.this$0.maxDepth) {
                    return file;
                }
                fileTreeWalkIterator.state.push(fileTreeWalkIterator.directoryState((File)var3_3));
            }
            return null;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0016\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0016\u0010\u000f\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\n"}, d2={"Lkotlin/io/FileTreeWalk$FileTreeWalkIterator$BottomUpDirectoryState;", "Lkotlin/io/FileTreeWalk$DirectoryState;", "Ljava/io/File;", "rootDir", "<init>", "(Lkotlin/io/FileTreeWalk$FileTreeWalkIterator;Ljava/io/File;)V", "step", "()Ljava/io/File;", "", "rootVisited", "Z", "", "fileList", "[Ljava/io/File;", "", "fileIndex", "I", "failed"})
        private final class BottomUpDirectoryState
        extends DirectoryState {
            private boolean rootVisited;
            private File[] fileList;
            private int fileIndex;
            private boolean failed;
            final /* synthetic */ FileTreeWalkIterator this$0;

            /*
             * WARNING - void declaration
             */
            public BottomUpDirectoryState(FileTreeWalkIterator this$0, File rootDir) {
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter(rootDir, "rootDir");
                this.this$0 = var1_1;
                super((File)var2_2);
            }

            @Override
            public final File step() {
                block7: {
                    if (!this.failed && this.fileList == null) {
                        Function1 function1 = this.this$0.this$0.onEnter;
                        boolean bl = function1 != null ? !((Boolean)function1.invoke(this.getRoot())).booleanValue() : false;
                        if (bl) {
                            return null;
                        }
                        this.fileList = this.getRoot().listFiles();
                        if (this.fileList == null) {
                            Function2 function2 = this.this$0.this$0.onFail;
                            if (function2 != null) {
                                function2.invoke(this.getRoot(), new AccessDeniedException(this.getRoot(), null, "Cannot list files in a directory", 2, null));
                            }
                            this.failed = true;
                        }
                    }
                    if (this.fileList != null) {
                        Intrinsics.checkNotNull(this.fileList);
                        if (this.fileIndex < this.fileList.length) {
                            Intrinsics.checkNotNull(this.fileList);
                            int n = this.fileIndex;
                            this.fileIndex = n + 1;
                            return this.fileList[n];
                        }
                    }
                    if (!this.rootVisited) {
                        this.rootVisited = true;
                        return this.getRoot();
                    }
                    Function1 function1 = this.this$0.this$0.onLeave;
                    if (function1 == null) break block7;
                    function1.invoke(this.getRoot());
                }
                return null;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0083\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0016\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\n"}, d2={"Lkotlin/io/FileTreeWalk$FileTreeWalkIterator$SingleFileState;", "Lkotlin/io/FileTreeWalk$WalkState;", "Ljava/io/File;", "rootFile", "<init>", "(Lkotlin/io/FileTreeWalk$FileTreeWalkIterator;Ljava/io/File;)V", "step", "()Ljava/io/File;", "", "visited", "Z"})
        @SourceDebugExtension(value={"SMAP\nFileTreeWalk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileTreeWalk.kt\nkotlin/io/FileTreeWalk$FileTreeWalkIterator$SingleFileState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1#2:274\n*E\n"})
        private final class SingleFileState
        extends WalkState {
            private boolean visited;
            final /* synthetic */ FileTreeWalkIterator this$0;

            /*
             * WARNING - void declaration
             */
            public SingleFileState(FileTreeWalkIterator this$0, File rootFile) {
                void var1_1;
                Intrinsics.checkNotNullParameter(rootFile, "rootFile");
                this.this$0 = var1_1;
                super(rootFile);
                if (_Assertions.ENABLED) {
                    void var2_4;
                    boolean bl = var2_4.isFile();
                    if (_Assertions.ENABLED && !bl) {
                        String string = "rootFile must be verified to be file beforehand.";
                        throw new AssertionError((Object)string);
                    }
                }
            }

            @Override
            public final File step() {
                if (this.visited) {
                    return null;
                }
                this.visited = true;
                return this.getRoot();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0016\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0016\u0010\u000f\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010"}, d2={"Lkotlin/io/FileTreeWalk$FileTreeWalkIterator$TopDownDirectoryState;", "Lkotlin/io/FileTreeWalk$DirectoryState;", "Ljava/io/File;", "rootDir", "<init>", "(Lkotlin/io/FileTreeWalk$FileTreeWalkIterator;Ljava/io/File;)V", "step", "()Ljava/io/File;", "", "rootVisited", "Z", "", "fileList", "[Ljava/io/File;", "", "fileIndex", "I"})
        private final class TopDownDirectoryState
        extends DirectoryState {
            private boolean rootVisited;
            private File[] fileList;
            private int fileIndex;
            final /* synthetic */ FileTreeWalkIterator this$0;

            /*
             * WARNING - void declaration
             */
            public TopDownDirectoryState(FileTreeWalkIterator this$0, File rootDir) {
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter(rootDir, "rootDir");
                this.this$0 = var1_1;
                super((File)var2_2);
            }

            @Override
            public final File step() {
                block12: {
                    block9: {
                        block10: {
                            block11: {
                                block8: {
                                    if (!this.rootVisited) {
                                        Function1 function1 = this.this$0.this$0.onEnter;
                                        boolean bl = function1 != null ? !((Boolean)function1.invoke(this.getRoot())).booleanValue() : false;
                                        if (bl) {
                                            return null;
                                        }
                                        this.rootVisited = true;
                                        return this.getRoot();
                                    }
                                    if (this.fileList == null) break block8;
                                    Intrinsics.checkNotNull(this.fileList);
                                    if (this.fileIndex >= this.fileList.length) break block9;
                                }
                                if (this.fileList != null) break block10;
                                this.fileList = this.getRoot().listFiles();
                                if (this.fileList == null) {
                                    Function2 function2 = this.this$0.this$0.onFail;
                                    if (function2 != null) {
                                        function2.invoke(this.getRoot(), new AccessDeniedException(this.getRoot(), null, "Cannot list files in a directory", 2, null));
                                    }
                                }
                                if (this.fileList == null) break block11;
                                Intrinsics.checkNotNull(this.fileList);
                                if (this.fileList.length != 0) break block10;
                            }
                            Function1 function1 = this.this$0.this$0.onLeave;
                            if (function1 != null) {
                                function1.invoke(this.getRoot());
                            }
                            return null;
                        }
                        Intrinsics.checkNotNull(this.fileList);
                        int n = this.fileIndex;
                        this.fileIndex = n + 1;
                        return this.fileList[n];
                    }
                    Function1 function1 = this.this$0.this$0.onLeave;
                    if (function1 == null) break block12;
                    function1.invoke(this.getRoot());
                }
                return null;
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FileWalkDirection.values().length];
                try {
                    nArray[FileWalkDirection.TOP_DOWN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[FileWalkDirection.BOTTOM_UP.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\"\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u0004\u0018\u00010\u0002H&\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\u0007"}, d2={"Lkotlin/io/FileTreeWalk$WalkState;", "", "Ljava/io/File;", "root", "<init>", "(Ljava/io/File;)V", "step", "()Ljava/io/File;", "Ljava/io/File;", "getRoot"})
    private static abstract class WalkState {
        private final File root;

        /*
         * WARNING - void declaration
         */
        public WalkState(File root) {
            void var1_1;
            Intrinsics.checkNotNullParameter(root, "root");
            this.root = var1_1;
        }

        public final File getRoot() {
            return this.root;
        }

        public abstract File step();
    }
}

