/*
 * Decompiled with CFR 0.152.
 */
package io.kamel.core.cache.disk;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.IOException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.Sink;
import okio.Timeout;

@StabilityInferred(parameters=0)
public final class FaultHidingSink
implements Sink {
    private final Sink delegate;
    private final Function1<IOException, Unit> onException;
    private boolean hasErrors;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public FaultHidingSink(Sink delegate, Function1<? super IOException, Unit> onException) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(onException, (String)"onException");
        this.delegate = var1_1;
        this.onException = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void write(Buffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.hasErrors) {
            source.skip(byteCount);
            return;
        }
        try {
            void var2_3;
            this.delegate.write(source, (long)var2_3);
            return;
        }
        catch (IOException e) {
            void var1_2;
            this.hasErrors = true;
            this.onException.invoke((Object)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void flush() {
        try {
            this.delegate.flush();
            return;
        }
        catch (IOException e) {
            void var1_1;
            this.hasErrors = true;
            this.onException.invoke((Object)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void close() {
        try {
            this.delegate.close();
            return;
        }
        catch (IOException e) {
            void var1_1;
            this.hasErrors = true;
            this.onException.invoke((Object)var1_1);
            return;
        }
    }

    public final Timeout timeout() {
        return this.delegate.timeout();
    }
}

