/*
 * Decompiled with CFR 0.152.
 */
package shared.system.os;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import shared.system.os.DesktopOS;
import shared.system.os.OS;

public final class DesktopOSKt {
    private static final Lazy currentDesktopOS$delegate = LazyKt.lazy(DesktopOSKt::currentDesktopOS_delegate$lambda$0);

    public static final OS platformCurrentOs() {
        switch (WhenMappings.$EnumSwitchMapping$0[DesktopOSKt.getCurrentDesktopOS().ordinal()]) {
            case 1: {
                return OS.Linux;
            }
            case 2: {
                return OS.Mac;
            }
            case 3: {
                return OS.Windows;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final DesktopOS getCurrentDesktopOS() {
        Lazy lazy = currentDesktopOS$delegate;
        return (DesktopOS)((Object)lazy.getValue());
    }

    /*
     * WARNING - void declaration
     */
    private static final DesktopOS currentDesktopOS_delegate$lambda$0() {
        void var0;
        String os = System.getProperty("os.name");
        Intrinsics.checkNotNull((Object)os);
        if (StringsKt.startsWith((String)os, (String)"Linux", (boolean)true)) {
            return DesktopOS.Linux;
        }
        if (StringsKt.equals((String)os, (String)"Mac OS X", (boolean)true)) {
            return DesktopOS.Mac;
        }
        if (StringsKt.startsWith((String)os, (String)"Win", (boolean)true)) {
            return DesktopOS.Windows;
        }
        throw new IllegalStateException(("Unknown OS name: " + (String)var0).toString());
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DesktopOS.values().length];
            try {
                nArray[DesktopOS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DesktopOS.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

