/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.qrcode.internals;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.alexzhirkevich.qrose.qrcode.QRCodeDataType;
import io.github.alexzhirkevich.qrose.qrcode.internals.BitBuffer;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;

@StabilityInferred(parameters=1)
public abstract class QRData {
    private final QRCodeDataType dataType;
    private final String data;

    /*
     * WARNING - void declaration
     */
    public QRData(QRCodeDataType dataType, String data) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.dataType = var1_1;
        this.data = var2_2;
    }

    public final QRCodeDataType getDataType() {
        return this.dataType;
    }

    public final String getData() {
        return this.data;
    }

    public abstract int length();

    public abstract void write(BitBuffer var1);

    /*
     * WARNING - void declaration
     */
    public final int getLengthInBits(int type) {
        void var1_1;
        int n = type;
        boolean bl = n > 0 ? n < 10 : false;
        if (bl) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.dataType.ordinal()]) {
                case 1: {
                    return 10;
                }
                case 2: {
                    return 9;
                }
                case 3: {
                    return 8;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        boolean bl2 = n > 0 ? n < 27 : false;
        if (bl2) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.dataType.ordinal()]) {
                case 1: {
                    return 12;
                }
                case 2: {
                    return 11;
                }
                case 3: {
                    return 16;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        boolean bl3 = n > 0 ? n < 41 : false;
        if (bl3) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.dataType.ordinal()]) {
                case 1: {
                    return 14;
                }
                case 2: {
                    return 13;
                }
                case 3: {
                    return 16;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        throw new IllegalArgumentException("'type' must be greater than 0 and cannot be greater than 40: " + (int)var1_1);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QRCodeDataType.values().length];
            try {
                nArray[QRCodeDataType.NUMBERS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[QRCodeDataType.UPPER_ALPHA_NUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[QRCodeDataType.DEFAULT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

