/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.qrcode.internals;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.alexzhirkevich.qrose.qrcode.QRCodeDataType;
import io.github.alexzhirkevich.qrose.qrcode.internals.BitBuffer;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRData;
import kotlin.jvm.internal.Intrinsics;

@StabilityInferred(parameters=1)
public final class QRAlphaNum
extends QRData {
    /*
     * WARNING - void declaration
     */
    public QRAlphaNum(String data) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(QRCodeDataType.UPPER_ALPHA_NUM, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(BitBuffer buffer) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int i = 0;
        int dataLength = this.getData().length();
        while (i + 1 < dataLength) {
            buffer.put(QRAlphaNum.charCode(this.getData().charAt(i)) * 45 + QRAlphaNum.charCode(this.getData().charAt(i + 1)), 11);
            i += 2;
        }
        if (i < var3_3) {
            void var2_2;
            void var1_1;
            var1_1.put(QRAlphaNum.charCode(this.getData().charAt((int)var2_2)), 6);
        }
    }

    @Override
    public final int length() {
        return this.getData().length();
    }

    private static int charCode(char c) {
        char c2;
        char c3 = c;
        boolean bl = '0' <= c3 ? c3 < ':' : false;
        if (bl) {
            return c - 48;
        }
        boolean bl2 = 'A' <= c3 ? c3 < '[' : false;
        if (bl2) {
            return c - 65 + 10;
        }
        c3 = c;
        if (c3 == ' ') {
            return 36;
        }
        if (c3 == '$') {
            return 37;
        }
        if (c3 == '%') {
            return 38;
        }
        if (c3 == '*') {
            return 39;
        }
        if (c3 == '+') {
            return 40;
        }
        if (c3 == '-') {
            return 41;
        }
        if (c3 == '.') {
            return 42;
        }
        if (c3 == '/') {
            return 43;
        }
        if (c3 == ':') {
            return 44;
        }
        throw new IllegalArgumentException("Illegal character: " + c2);
    }
}

