/*
 * Decompiled with CFR 0.152.
 */
package com.materialkolor.dynamiccolor;

import com.materialkolor.contrast.Contrast;
import com.materialkolor.dynamiccolor.ContrastCurve;
import com.materialkolor.dynamiccolor.ToneDeltaPair;
import com.materialkolor.dynamiccolor.TonePolarity;
import com.materialkolor.hct.Hct;
import com.materialkolor.palettes.TonalPalette;
import com.materialkolor.scheme.DynamicScheme;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u00a3\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0004\u0012\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0004\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0004\u0012\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001bR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001cR#\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001c\u001a\u0004\b\u0019\u0010\u001dR\u0011\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001eR\u001f\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\f\u0010\u001cR\u001f\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001cR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0006\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u001fR\u001f\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u001cR\u001f\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b\u0018\u00010\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u001cR0\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020!0 j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020!`\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$"}, d2={"Lcom/materialkolor/dynamiccolor/DynamicColor;", "", "", "name", "Lkotlin/Function1;", "Lcom/materialkolor/scheme/DynamicScheme;", "Lcom/materialkolor/palettes/TonalPalette;", "palette", "", "tone", "", "isBackground", "background", "secondBackground", "Lcom/materialkolor/dynamiccolor/ContrastCurve;", "contrastCurve", "Lcom/materialkolor/dynamiccolor/ToneDeltaPair;", "toneDeltaPair", "opacity", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;ZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/materialkolor/dynamiccolor/ContrastCurve;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "scheme", "", "getArgb", "(Lcom/materialkolor/scheme/DynamicScheme;)I", "getTone", "(Lcom/materialkolor/scheme/DynamicScheme;)D", "Ljava/lang/String;", "Lkotlin/jvm/functions/Function1;", "()Lkotlin/jvm/functions/Function1;", "Z", "Lcom/materialkolor/dynamiccolor/ContrastCurve;", "Ljava/util/HashMap;", "Lcom/materialkolor/hct/Hct;", "Lkotlin/collections/HashMap;", "hctCache", "Ljava/util/HashMap;", "Companion"})
public final class DynamicColor {
    public static final Companion Companion = new Companion(null);
    public final String name;
    public final Function1<DynamicScheme, TonalPalette> palette;
    private final Function1<DynamicScheme, Double> tone;
    public final boolean isBackground;
    public final Function1<DynamicScheme, DynamicColor> background;
    public final Function1<DynamicScheme, DynamicColor> secondBackground;
    public final ContrastCurve contrastCurve;
    public final Function1<DynamicScheme, ToneDeltaPair> toneDeltaPair;
    public final Function1<DynamicScheme, Double> opacity;
    private final HashMap<DynamicScheme, Hct> hctCache;

    /*
     * WARNING - void declaration
     */
    private DynamicColor(String name, Function1<? super DynamicScheme, TonalPalette> palette, Function1<? super DynamicScheme, Double> tone, boolean isBackground, Function1<? super DynamicScheme, DynamicColor> background, Function1<? super DynamicScheme, DynamicColor> secondBackground, ContrastCurve contrastCurve, Function1<? super DynamicScheme, ToneDeltaPair> toneDeltaPair, Function1<? super DynamicScheme, Double> opacity) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(palette, (String)"palette");
        Intrinsics.checkNotNullParameter(tone, (String)"tone");
        this.name = var1_1;
        this.palette = var2_2;
        this.tone = var3_3;
        this.isBackground = isBackground;
        this.background = background;
        this.secondBackground = secondBackground;
        this.contrastCurve = contrastCurve;
        this.toneDeltaPair = toneDeltaPair;
        this.opacity = opacity;
        this.hctCache = new HashMap();
    }

    public /* synthetic */ DynamicColor(String string, Function1 function1, Function1 function12, boolean bl, Function1 function13, Function1 function14, ContrastCurve contrastCurve, Function1 function15, Function1 function16, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            function16 = null;
        }
        this(string, (Function1<? super DynamicScheme, TonalPalette>)function1, (Function1<? super DynamicScheme, Double>)function12, bl, (Function1<? super DynamicScheme, DynamicColor>)function13, (Function1<? super DynamicScheme, DynamicColor>)function14, contrastCurve, (Function1<? super DynamicScheme, ToneDeltaPair>)function15, (Function1<? super DynamicScheme, Double>)function16);
    }

    public final Function1<DynamicScheme, Double> getTone() {
        return this.tone;
    }

    /*
     * WARNING - void declaration
     */
    public final int getArgb(DynamicScheme scheme) {
        void var1_2;
        void var2_6;
        Hct hct;
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        DynamicScheme dynamicScheme = scheme;
        DynamicColor dynamicColor = this;
        Intrinsics.checkNotNullParameter((Object)dynamicScheme, (String)"scheme");
        Hct hct2 = dynamicColor.hctCache.get(dynamicScheme);
        if (hct2 != null) {
            hct = hct2;
        } else {
            double d = dynamicColor.getTone(dynamicScheme);
            hct2 = ((TonalPalette)dynamicColor.palette.invoke((Object)dynamicScheme)).getHct(d);
            if (dynamicColor.hctCache.size() > 4) {
                dynamicColor.hctCache.clear();
            }
            ((Map)dynamicColor.hctCache).put(dynamicScheme, hct2);
            hct = hct2;
        }
        int argb = hct.toInt();
        if (this.opacity == null) {
            return argb;
        }
        double d = ((Number)this.opacity.invoke((Object)scheme)).doubleValue();
        int alpha = RangesKt.coerceIn((int)((int)Math.rint(d * 255.0)), (int)0, (int)255);
        return var2_6 & 0xFFFFFF | var1_2 << 24;
    }

    /*
     * WARNING - void declaration
     */
    private double getTone(DynamicScheme scheme) {
        void var3_4;
        void var2_2;
        boolean decreasingContrast;
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        boolean bl = decreasingContrast = scheme.getContrastLevel() < 0.0;
        if (this.toneDeltaPair != null) {
            double fTone;
            ToneDeltaPair toneDeltaPair = (ToneDeltaPair)this.toneDeltaPair.invoke((Object)scheme);
            DynamicColor roleA = toneDeltaPair.getRoleA();
            DynamicColor roleB = toneDeltaPair.getRoleB();
            double delta = toneDeltaPair.getDelta();
            TonePolarity polarity = toneDeltaPair.getPolarity();
            boolean stayTogether = toneDeltaPair.getStayTogether();
            Function1<DynamicScheme, DynamicColor> function1 = this.background;
            Intrinsics.checkNotNull(function1);
            DynamicColor dynamicColor = (DynamicColor)function1.invoke((Object)scheme);
            double bgTone = dynamicColor.getTone(scheme);
            boolean aIsNearer = polarity == TonePolarity.NEARER || polarity == TonePolarity.LIGHTER && !scheme.isDark() || polarity == TonePolarity.DARKER && scheme.isDark();
            DynamicColor nearer = aIsNearer ? roleA : roleB;
            DynamicColor farther = aIsNearer ? roleB : roleA;
            boolean amNearer = Intrinsics.areEqual((Object)this.name, (Object)nearer.name);
            double expansionDir = scheme.isDark() ? 1 : -1;
            ContrastCurve contrastCurve = nearer.contrastCurve;
            Intrinsics.checkNotNull((Object)contrastCurve);
            double nContrast = contrastCurve.get(scheme.getContrastLevel());
            ContrastCurve contrastCurve2 = farther.contrastCurve;
            Intrinsics.checkNotNull((Object)contrastCurve2);
            double fContrast = contrastCurve2.get(scheme.getContrastLevel());
            double nInitialTone = ((Number)nearer.tone.invoke((Object)scheme)).doubleValue();
            double nTone = Contrast.INSTANCE.ratioOfTones(bgTone, nInitialTone) >= nContrast ? nInitialTone : Companion.foregroundTone(bgTone, nContrast);
            double fInitialTone = ((Number)farther.tone.invoke((Object)scheme)).doubleValue();
            double d = fTone = Contrast.INSTANCE.ratioOfTones(bgTone, fInitialTone) >= fContrast ? fInitialTone : Companion.foregroundTone(bgTone, fContrast);
            if (decreasingContrast) {
                nTone = Companion.foregroundTone(bgTone, nContrast);
                fTone = Companion.foregroundTone(bgTone, fContrast);
            }
            if ((fTone - nTone) * expansionDir < delta) {
                double d2;
                fTone = RangesKt.coerceIn((double)(nTone + delta * expansionDir), (double)0.0, (double)100.0);
                if ((d2 - nTone) * expansionDir < delta) {
                    nTone = RangesKt.coerceIn((double)(fTone - delta * expansionDir), (double)0.0, (double)100.0);
                }
            }
            if (50.0 <= nTone && nTone < 60.0) {
                if (expansionDir > 0.0) {
                    nTone = 60.0;
                    v6 = Math.max(fTone, 60.0 + delta * expansionDir);
                } else {
                    nTone = 49.0;
                    v6 = Math.min(fTone, 49.0 + delta * expansionDir);
                }
            } else if (50.0 <= fTone && fTone < 60.0) {
                if (stayTogether) {
                    if (expansionDir > 0.0) {
                        nTone = 60.0;
                        v6 = Math.max(fTone, 60.0 + delta * expansionDir);
                    } else {
                        nTone = 49.0;
                        v6 = Math.min(fTone, 49.0 + delta * expansionDir);
                    }
                } else {
                    v6 = fTone = expansionDir > 0.0 ? 60.0 : 49.0;
                }
            }
            if (amNearer) {
                return nTone;
            }
            return fTone;
        }
        double answer = ((Number)this.tone.invoke((Object)scheme)).doubleValue();
        if (this.background == null) {
            return answer;
        }
        double bgTone = ((DynamicColor)this.background.invoke((Object)scheme)).getTone(scheme);
        ContrastCurve contrastCurve = this.contrastCurve;
        if (contrastCurve == null) {
            return answer;
        }
        double desiredRatio = contrastCurve.get(scheme.getContrastLevel());
        if (!(Contrast.INSTANCE.ratioOfTones(bgTone, answer) >= desiredRatio)) {
            answer = Companion.foregroundTone(bgTone, desiredRatio);
        }
        if (var2_2 != false) {
            answer = Companion.foregroundTone(bgTone, desiredRatio);
        }
        if (this.isBackground && 50.0 <= answer && answer < 60.0) {
            double d = answer = Contrast.INSTANCE.ratioOfTones(49.0, bgTone) >= desiredRatio ? 49.0 : 60.0;
        }
        if (this.secondBackground != null) {
            boolean bl2;
            void var1_1;
            double bgTone1 = ((DynamicColor)this.background.invoke((Object)scheme)).getTone(scheme);
            double bgTone2 = ((DynamicColor)this.secondBackground.invoke((Object)scheme)).getTone((DynamicScheme)var1_1);
            double upper = Math.max(bgTone1, bgTone2);
            double lower = Math.min(bgTone1, bgTone2);
            if (Contrast.INSTANCE.ratioOfTones(upper, answer) >= desiredRatio && Contrast.INSTANCE.ratioOfTones(lower, answer) >= desiredRatio) {
                return answer;
            }
            double lightOption = Contrast.INSTANCE.lighter(upper, desiredRatio);
            double darkOption = Contrast.INSTANCE.darker(lower, desiredRatio);
            List availables = new ArrayList();
            if (!(lightOption == -1.0)) {
                availables.add(lightOption);
            }
            if (!(darkOption == -1.0)) {
                availables.add(darkOption);
            }
            if (bl2 = com.materialkolor.dynamiccolor.DynamicColor$Companion.tonePrefersLightForeground(bgTone1) || com.materialkolor.dynamiccolor.DynamicColor$Companion.tonePrefersLightForeground(bgTone2)) {
                if (lightOption == -1.0) {
                    return 100.0;
                }
                return lightOption;
            }
            if (availables.size() == 1) {
                return ((Number)availables.get(0)).doubleValue();
            }
            if (darkOption == -1.0) {
                return 0.0;
            }
            return darkOption;
        }
        return (double)var3_4;
    }

    public final boolean equals(Object other) {
        DynamicColor dynamicColor;
        if (this == other) {
            return true;
        }
        if (!(other instanceof DynamicColor)) {
            return false;
        }
        dynamicColor = dynamicColor;
        if (!Intrinsics.areEqual((Object)this.name, (Object)dynamicColor.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.palette, dynamicColor.palette)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tone, dynamicColor.tone)) {
            return false;
        }
        if (this.isBackground != dynamicColor.isBackground) {
            return false;
        }
        if (!Intrinsics.areEqual(this.background, dynamicColor.background)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.secondBackground, dynamicColor.secondBackground)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contrastCurve, (Object)dynamicColor.contrastCurve)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.toneDeltaPair, dynamicColor.toneDeltaPair)) {
            return false;
        }
        return Intrinsics.areEqual(this.opacity, dynamicColor.opacity);
    }

    public final int hashCode() {
        int n = this.name.hashCode();
        n = n * 31 + this.palette.hashCode();
        n = n * 31 + this.tone.hashCode();
        n = n * 31 + Boolean.hashCode(this.isBackground);
        n = n * 31 + (this.background == null ? 0 : this.background.hashCode());
        n = n * 31 + (this.secondBackground == null ? 0 : this.secondBackground.hashCode());
        n = n * 31 + (this.contrastCurve == null ? 0 : this.contrastCurve.hashCode());
        n = n * 31 + (this.toneDeltaPair == null ? 0 : this.toneDeltaPair.hashCode());
        n = n * 31 + (this.opacity == null ? 0 : this.opacity.hashCode());
        return n;
    }

    public final String toString() {
        return "DynamicColor(name=" + this.name + ", palette=" + this.palette + ", tone=" + this.tone + ", isBackground=" + this.isBackground + ", background=" + this.background + ", secondBackground=" + this.secondBackground + ", contrastCurve=" + this.contrastCurve + ", toneDeltaPair=" + this.toneDeltaPair + ", opacity=" + this.opacity + ")";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lcom/materialkolor/dynamiccolor/DynamicColor$Companion;", "", "<init>", "()V", "", "bgTone", "ratio", "foregroundTone", "(DD)D", "tone", "", "tonePrefersLightForeground", "(D)Z"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final double foregroundTone(double bgTone2, double ratio) {
            void var3_3;
            double lighterTone = Contrast.INSTANCE.lighterUnsafe(bgTone2, ratio);
            double darkerTone = Contrast.INSTANCE.darkerUnsafe(bgTone2, ratio);
            double lighterRatio = Contrast.INSTANCE.ratioOfTones(lighterTone, bgTone2);
            double darkerRatio = Contrast.INSTANCE.ratioOfTones(darkerTone, bgTone2);
            boolean bgTone2 = com.materialkolor.dynamiccolor.DynamicColor$Companion.tonePrefersLightForeground(bgTone2);
            if (bgTone2) {
                void var1_2;
                boolean negligibleDifference;
                boolean bl = negligibleDifference = Math.abs(lighterRatio - darkerRatio) < 0.1 && lighterRatio < ratio && darkerRatio < ratio;
                if (lighterRatio >= ratio || lighterRatio >= darkerRatio || var1_2 != false) {
                    return lighterTone;
                }
                return darkerTone;
            }
            if (darkerRatio >= var3_3 || darkerRatio >= lighterRatio) {
                return darkerTone;
            }
            return lighterTone;
        }

        public static boolean tonePrefersLightForeground(double tone) {
            return Math.rint(tone) < 60.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

