/*
 * Decompiled with CFR 0.152.
 */
package com.materialkolor.dynamiccolor;

import com.materialkolor.utils.MathUtils;

public final class ContrastCurve {
    private final double low;
    private final double normal;
    private final double medium;
    private final double high;

    /*
     * WARNING - void declaration
     */
    public ContrastCurve(double low, double normal, double medium, double high) {
        void var3_2;
        void var1_1;
        this.low = var1_1;
        this.normal = var3_2;
        this.medium = medium;
        this.high = high;
    }

    /*
     * WARNING - void declaration
     */
    public final double get(double contrastLevel) {
        if (contrastLevel <= -1.0) {
            return this.low;
        }
        if (contrastLevel < 0.0) {
            return MathUtils.lerp(this.low, this.normal, (contrastLevel - -1.0) / 1.0);
        }
        if (contrastLevel < 0.5) {
            return MathUtils.lerp(this.normal, this.medium, (contrastLevel - 0.0) / 0.5);
        }
        if (contrastLevel < 1.0) {
            void var1_1;
            return MathUtils.lerp(this.medium, this.high, (double)((var1_1 - 0.5) / 0.5));
        }
        return this.high;
    }

    public final boolean equals(Object other) {
        ContrastCurve contrastCurve;
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContrastCurve)) {
            return false;
        }
        contrastCurve = contrastCurve;
        if (Double.compare(this.low, contrastCurve.low) != 0) {
            return false;
        }
        if (Double.compare(this.normal, contrastCurve.normal) != 0) {
            return false;
        }
        if (Double.compare(this.medium, contrastCurve.medium) != 0) {
            return false;
        }
        return Double.compare(this.high, contrastCurve.high) == 0;
    }

    public final int hashCode() {
        int n = Double.hashCode(this.low);
        n = n * 31 + Double.hashCode(this.normal);
        n = n * 31 + Double.hashCode(this.medium);
        n = n * 31 + Double.hashCode(this.high);
        return n;
    }

    public final String toString() {
        return "ContrastCurve(low=" + this.low + ", normal=" + this.normal + ", medium=" + this.medium + ", high=" + this.high + ")";
    }
}

