/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.ParagraphIntrinsics;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics_skikoKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.unit.Density;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.paragraph.Paragraph;

@StabilityInferred(parameters=0)
public final class SkiaParagraphIntrinsics
implements ParagraphIntrinsics {
    private final String text;
    private final TextStyle style;
    private final List<AnnotatedString.Range<SpanStyle>> spanStyles;
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    private final Density density;
    private final FontFamily.Resolver fontFamilyResolver;
    private final ResolvedTextDirection textDirection;
    private ParagraphLayouter layouter;
    private float minIntrinsicWidth;
    private float maxIntrinsicWidth;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public SkiaParagraphIntrinsics(String text, TextStyle style, List<AnnotatedString.Range<SpanStyle>> spanStyles, List<AnnotatedString.Range<Placeholder>> placeholders, Density density, FontFamily.Resolver fontFamilyResolver) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = text;
        this.style = var2_2;
        this.spanStyles = var3_3;
        this.placeholders = placeholders;
        this.density = density;
        this.fontFamilyResolver = fontFamilyResolver;
        this.textDirection = SkiaParagraphIntrinsics_skikoKt.resolveTextDirection-Ikz0yAw(this.text, TextDirection.box-impl(this.style.getTextDirection-s_7X-co()), this.style.getLocaleList());
        ParagraphLayouter paragraphLayouter = this.layouter = this.newLayouter();
        Intrinsics.checkNotNull((Object)paragraphLayouter);
        Paragraph para = paragraphLayouter.layoutParagraph(Float.POSITIVE_INFINITY);
        this.minIntrinsicWidth = (float)Math.ceil(para.getMinIntrinsicWidth());
        this.maxIntrinsicWidth = (float)Math.ceil(var1_1.getMaxIntrinsicWidth());
    }

    public final String getText() {
        return this.text;
    }

    public final ResolvedTextDirection getTextDirection() {
        return this.textDirection;
    }

    /*
     * WARNING - void declaration
     */
    public final ParagraphLayouter layouter() {
        void var1_1;
        ParagraphLayouter paragraphLayouter = this.layouter;
        if (paragraphLayouter == null) {
            paragraphLayouter = this.newLayouter();
        }
        ParagraphLayouter layouter = paragraphLayouter;
        this.layouter = null;
        return var1_1;
    }

    private final ParagraphLayouter newLayouter() {
        return new ParagraphLayouter(this.text, this.textDirection, this.style, this.spanStyles, this.placeholders, this.density, this.fontFamilyResolver);
    }

    @Override
    public final float getMinIntrinsicWidth() {
        return this.minIntrinsicWidth;
    }

    @Override
    public final float getMaxIntrinsicWidth() {
        return this.maxIntrinsicWidth;
    }
}

