/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ShaderBrush;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.ParagraphBuilder;
import androidx.compose.ui.text.platform.ParagraphLayouter_skikoKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Density;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.Paragraph;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nParagraphLayouter.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphLayouter.skiko.kt\nandroidx/compose/ui/text/platform/ParagraphLayouter\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n708#2:223\n696#2:224\n205#3:225\n1747#4,3:226\n*S KotlinDebug\n*F\n+ 1 ParagraphLayouter.skiko.kt\nandroidx/compose/ui/text/platform/ParagraphLayouter\n*L\n114#1:223\n114#1:224\n130#1:225\n154#1:226,3\n*E\n"})
public final class ParagraphLayouter {
    private final String text;
    private final ParagraphBuilder builder;
    private Paragraph paragraphCache;
    private boolean updateForeground;
    private float width;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public ParagraphLayouter(String text, ResolvedTextDirection textDirection, TextStyle style, List<AnnotatedString.Range<SpanStyle>> spanStyles, List<AnnotatedString.Range<Placeholder>> placeholders, Density density, FontFamily.Resolver fontFamilyResolver) {
        void var2_2;
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)textDirection), (String)"textDirection");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = var1_1;
        this.builder = new ParagraphBuilder(fontFamilyResolver, this.text, (TextStyle)var3_3, 0L, null, 0, spanStyles, placeholders, density, (ResolvedTextDirection)var2_2, null, 0, 3128, null);
        this.width = Float.NaN;
    }

    public final Font getDefaultFont() {
        return this.builder.getDefaultFont$ui_text();
    }

    public final TextStyle getTextStyle() {
        return this.builder.getTextStyle();
    }

    private final void invalidateParagraph(boolean onlyForeground) {
        if (onlyForeground && this.builder.getSpanStyles().isEmpty()) {
            this.updateForeground = true;
            return;
        }
        this.paragraphCache = null;
    }

    /*
     * WARNING - void declaration
     */
    public final LineMetrics[] emptyLineMetrics$ui_text(Paragraph paragraph) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"paragraph");
        return this.builder.emptyLineMetrics$ui_text((Paragraph)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setParagraphStyle(int maxLines, String ellipsis) {
        Intrinsics.checkNotNullParameter((Object)ellipsis, (String)"ellipsis");
        if (this.builder.getMaxLines() != maxLines || !Intrinsics.areEqual((Object)this.builder.getEllipsis(), (Object)ellipsis)) {
            void var2_3;
            boolean bl;
            this.builder.setMaxLines(bl ? 1 : 0);
            this.builder.setEllipsis((String)var2_3);
            bl = true;
            bl = false;
            ParagraphLayouter paragraphLayouter = this;
            paragraphLayouter.invalidateParagraph(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setColor-8_81llA(long color) {
        long actualColor;
        long $this$takeOrElse_u2dDxMtmZc$iv;
        long l = $this$takeOrElse_u2dDxMtmZc$iv = color;
        long l2 = actualColor = $this$takeOrElse_u2dDxMtmZc$iv != 16L ? $this$takeOrElse_u2dDxMtmZc$iv : this.builder.getTextStyle().getColor-0d7_KjU();
        if (!Color.equals-impl0((long)this.builder.getTextStyle().getColor-0d7_KjU(), (long)actualColor)) {
            void var3_4;
            this.builder.setTextStyle(TextStyle.copy-p1EtxEg$default$7db5f84e(this.builder.getTextStyle(), (long)var3_4, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, 0, 0, 0L, null, null, null, 0, 0, null, 0xFFFFFE));
            this.invalidateParagraph(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setBrush-12SF9DM(Brush brush, long brushSize, float alpha) {
        long l;
        long actualSize = this.builder.getBrushSize-NH-jbRc();
        if (!(Intrinsics.areEqual((Object)this.builder.getTextStyle().getBrush(), (Object)brush) && !((l = actualSize) == 9205357640488583168L) && ParagraphLayouter_skikoKt.access$sameValueAs(Size.getWidth-impl((long)actualSize), Size.getWidth-impl((long)brushSize)) && ParagraphLayouter_skikoKt.access$sameValueAs(Size.getHeight-impl((long)actualSize), Size.getHeight-impl((long)brushSize)) && ParagraphLayouter_skikoKt.access$sameValueAs(this.builder.getTextStyle().getAlpha(), alpha))) {
            void var2_2;
            void var1_1;
            this.builder.setTextStyle(TextStyle.copy-Ns73l9s$default$21dd0f8d(this.builder.getTextStyle(), (Brush)var1_1, alpha, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, 0, 0, 0L, null, null, null, 0, 0, null, 0x1FFFFFC));
            this.builder.setBrushSize-uvyYCjk((long)var2_2);
            this.invalidateParagraph(true);
        }
    }

    public final void setBrushSize-uvyYCjk(long brushSize) {
        block6: {
            block7: {
                boolean bl;
                if (Size.equals-impl0((long)this.builder.getBrushSize-NH-jbRc(), (long)brushSize)) break block6;
                this.builder.setBrushSize-uvyYCjk(brushSize);
                if (this.builder.getTextStyle().getBrush() instanceof ShaderBrush) break block7;
                Iterable $this$any$iv = this.builder.getSpanStyles();
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
                    Iterator iterator;
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        if (!(((SpanStyle)((AnnotatedString.Range)(object = (AnnotatedString.Range)object)).getItem()).getBrush() instanceof ShaderBrush)) continue;
                        bl = true;
                        break;
                    }
                } else {
                    bl = false;
                }
                if (!bl) break block6;
            }
            this.invalidateParagraph(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setTextStyle(Shadow shadow, TextDecoration textDecoration) {
        if (!Intrinsics.areEqual((Object)this.builder.getTextStyle().getShadow(), (Object)shadow) || !Intrinsics.areEqual((Object)this.builder.getTextStyle().getTextDecoration(), (Object)textDecoration)) {
            void var1_1;
            void var2_4;
            this.builder.setTextStyle(TextStyle.copy-p1EtxEg$default$7db5f84e(this.builder.getTextStyle(), 0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, (TextDecoration)var2_4, (Shadow)var1_1, null, 0, 0, 0L, null, null, null, 0, 0, null, 0xFFCFFF));
            boolean bl = true;
            bl = false;
            ParagraphLayouter paragraphLayouter = this;
            paragraphLayouter.invalidateParagraph(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setDrawStyle(DrawStyle drawStyle) {
        if (!Intrinsics.areEqual((Object)this.builder.getDrawStyle(), (Object)drawStyle)) {
            void var1_1;
            this.builder.setDrawStyle((DrawStyle)var1_1);
            this.invalidateParagraph(true);
        }
    }

    public final void setBlendMode-s9anfk8(int blendMode) {
        if (!BlendMode.equals-impl0((int)this.builder.getBlendMode-0nO6VwU(), (int)blendMode)) {
            boolean bl;
            this.builder.setBlendMode-s9anfk8(bl ? 1 : 0);
            bl = true;
            bl = false;
            ParagraphLayouter paragraphLayouter = this;
            paragraphLayouter.invalidateParagraph(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Paragraph layoutParagraph(float width) {
        void var2_2;
        void var1_1;
        Paragraph paragraph = this.paragraphCache;
        if (paragraph != null) {
            void var3_3;
            boolean layoutRequired = false;
            if (this.updateForeground) {
                this.builder.updateForegroundPaint(paragraph);
                this.updateForeground = false;
                paragraph.markDirty();
                layoutRequired = true;
            }
            if (!ParagraphLayouter_skikoKt.access$sameValueAs(this.width, width)) {
                this.width = width;
                layoutRequired = true;
            }
            if (var3_3 != false) {
                paragraph.layout(width);
            }
            return paragraph;
        }
        paragraph = this.builder.build();
        paragraph.layout((float)var1_1);
        this.paragraphCache = paragraph;
        this.updateForeground = false;
        return var2_2;
    }
}

