/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AtomicReference;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.PlatformTextInputService;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputSession;
import java.util.List;
import kotlin.Deprecated;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@StabilityInferred(parameters=0)
public final class TextInputService {
    private final PlatformTextInputService platformTextInputService;
    private final AtomicReference<TextInputSession> _currentInputSession;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public TextInputService(PlatformTextInputService platformTextInputService) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)platformTextInputService, (String)"platformTextInputService");
        this.platformTextInputService = var1_1;
        this._currentInputSession = new AtomicReference<Object>(null);
    }

    public final TextInputSession getCurrentInputSession$ui_text() {
        return this._currentInputSession.get();
    }

    /*
     * WARNING - void declaration
     */
    public final TextInputSession startInput(TextFieldValue value, ImeOptions imeOptions, Function1<? super List<? extends EditCommand>, Unit> onEditCommand, Function1<? super ImeAction, Unit> onImeActionPerformed) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
        Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
        this.platformTextInputService.startInput(value, (ImeOptions)var2_2, (Function1<? super List<? extends EditCommand>, Unit>)var3_3, onImeActionPerformed);
        TextInputService textInputService = this;
        TextInputSession nextSession = new TextInputSession(textInputService, textInputService.platformTextInputService);
        this._currentInputSession.set$5d527811(nextSession);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void stopInput(TextInputSession session) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (this._currentInputSession.compareAndSet$2838e5b1((TextInputSession)var1_1, null)) {
            this.platformTextInputService.stopInput();
        }
    }

    @Deprecated(message="Use SoftwareKeyboardController.show or TextInputSession.showSoftwareKeyboard instead.", replaceWith=@ReplaceWith(expression="textInputSession.showSoftwareKeyboard()", imports={}))
    public final void showSoftwareKeyboard() {
        if (this.getCurrentInputSession$ui_text() != null) {
            this.platformTextInputService.showSoftwareKeyboard();
        }
    }

    @Deprecated(message="Use SoftwareKeyboardController.hide or TextInputSession.hideSoftwareKeyboard instead.", replaceWith=@ReplaceWith(expression="textInputSession.hideSoftwareKeyboard()", imports={}))
    public final void hideSoftwareKeyboard() {
        this.platformTextInputService.hideSoftwareKeyboard();
    }
}

